<?php

if (file_exists(dirname(__FILE__) . '/cmb2/init.php')) {
    require_once dirname(__FILE__) . '/cmb2/init.php';
} elseif (file_exists(dirname(__FILE__) . '/CMB2/init.php')) {
    require_once dirname(__FILE__) . '/CMB2/init.php';
}

add_action('cmb2_init', 'alt_metabox_endereco');
add_action('cmb2_init', 'alt_metabox_filial_contato');

/**
 * Define the metabox and field configurations.
 */
function alt_metabox_endereco()
{

    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_dados',
        'title' => 'Informações',
        'object_types' => array('filiais',), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));


    $cmb->add_field(array(
            'name' => 'Email',
            'desc' => 'Ex.: suporte@windi.com.br',
            'id' => $prefix . 'filiais_email',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => 'Endereço completo',
            'desc' => 'Ex.: Av. Gov. Ivo Silveira, 1833 Capoeiras, Florianópolis / SC. CEP: 88085-000',
            'id' => $prefix . 'filiais_endereco',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
            'attributes' => array(
                'required' => 'required',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => 'Link google maps',
            'desc' => '<a target="_blank" href="https://www.google.com.br/maps">Obter link</a>',
            'id' => $prefix . 'filial_mapa',
            'type' => 'wysiwyg',
            'show_on_cb' => 'cmb2_hide_if_no_cats',
        )
    );

    $cmb->add_field(array(
            'name' => 'Chave Altimus',
            'desc' => 'Chave fornecida pelo sistema Altimus para integração de veículos',
            'id' => $prefix . 'filiais_chave_altimus',
            'type' => 'text',
            'show_on_cb' => 'cmb2_hide_if_no_cats'
        )
    );


}


function alt_metabox_filial_contato(){
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_contato',
        'title' => 'Telefones para contato',
        'object_types' => array('filiais'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));



    $group_field_id = $cmb->add_field(array(
        'id' => $prefix . 'filial_contatos',
        'type' => 'group',
        'title'=>'Telefones',
        'description' => '',
        //'repeatable'  => false, // use false if you want non-repeatable group
        'options' => array(
            'group_title' => 'Telefone', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar Telefone',
            'remove_button' => 'Remover Telefone',
            'sortable' => true,
             'closed'         => true, // true to have the groups closed by default
             'remove_confirm' => 'Tem certeza que deseja remover esse contato?', // Performs confirmation before removing group.
        ),
    ));

    // Id's for group's fields only need to be unique for the group. Prefix is not needed.
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Tipo',
        'id' => 'tipo',
        'type' => 'select',
        'default' => 'telefone',
        'options' => array(
            'whatsapp' => 'Whatsapp',
            'telefone' => 'Telefone',
        ),
    ));
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Valor',
        'desc'=>'Apenas números ex: 47997466287',
        'id' => 'valor',
        'type' => 'text',
    ));
    $cmb->add_group_field($group_field_id, array(
        'name' => 'Titulo',
        'id' => 'descricao',
        'type' => 'text',
        // 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
    ));
}