<?php
#add_action('alt_import_blog_catarina', 'alt_import_blog_catarina');

function alt_import_blog_catarina()
{

    $url = 'http://cms-site.altimus.com.br/conteudos/show.json';
    $requests_response = Requests::request($url);
    $data = json_decode($requests_response->body, true);

    foreach ($data['conteudo'] as $info) {

        $post_id = -1;
        $title = $info['title'];
        $content = $info['conteudo'];
        $imagem = $info['imagem'];
        $slug = $info['slug'];
        $author_id = 1;

        $arrData = array(
            'comment_status' => 'closed',
            'ping_status' => 'closed',
            'post_author' => $author_id,
            'post_name' => $slug,
            'post_title' => $title,
            'post_content' => html_entity_decode(json_decode($content)),
            'post_status' => 'publish',
            'post_type' => 'post'
        );


        if (!post_exists_by_slug($slug)) {

            $post_id = wp_insert_post(
                $arrData
            );

            generate_image($imagem, $post_id);

        } else {
            $post_id = -2;
        }

    }


}

function generate_image($image_url, $post_id)
{
    $upload_dir = wp_upload_dir();
    $image_data = file_get_contents($image_url);
    $filename = basename($image_url);
    if (wp_mkdir_p($upload_dir['path']))
        $file = $upload_dir['path'] . '/' . $filename;
    else
        $file = $upload_dir['basedir'] . '/' . $filename;
    file_put_contents($file, $image_data);

    $wp_filetype = wp_check_filetype($filename, null);
    $attachment = array(
        'post_mime_type' => $wp_filetype['type'],
        'post_title' => sanitize_file_name($filename),
        'post_content' => '',
        'post_status' => 'inherit'
    );
    $attach_id = wp_insert_attachment($attachment, $file, $post_id);
    require_once(ABSPATH . 'wp-admin/includes/image.php');
    $attach_data = wp_generate_attachment_metadata($attach_id, $file);
    $res1 = wp_update_attachment_metadata($attach_id, $attach_data);
    $res2 = set_post_thumbnail($post_id, $attach_id);
}

function post_exists_by_slug($post_slug)
{
    $args_posts = array(
        'post_type' => 'post',
        'post_status' => 'Publish',
        'name' => $post_slug,
        'posts_per_page' => 1,
    );
    $loop_posts = new WP_Query($args_posts);
    if (!$loop_posts->have_posts()) {
        return false;
    } else {
        $loop_posts->the_post();
        return $loop_posts->post->ID;
    }
}


function ativar_importacao_blog()
{
    if (!wp_next_scheduled('alt_import_blog_catarina')) {
        wp_schedule_event(time(), 'hourly', 'alt_import_blog_catarina');
    }
}

add_action('alt_import_blog_catarina', 'alt_import_blog_catarina');
