<?php


if (!function_exists('alt_lista_veiculos')) {

    add_action('alt_lista_veiculos', 'alt_lista_veiculos');
    function alt_lista_veiculos()
    {
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        $args = array(
            //'numberposts' => 10,
            'posts_per_page' => get_total_veiculo_no_estoque(),
            'paged' => $paged,
            'post_type' => 'veiculos',
            'post_status' => array('publish'),


        );


        $args = array_merge($args, alt_query_filtro_veiculos_ordenacao(), alt_query_filtro_veiculos());


        //print_r($args);
        $query = new WP_Query($args);


        $paginacao = array(
            'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))),
            'total' => $query->max_num_pages,
            'current' => max(1, get_query_var('paged')),
            'format' => '?paged=%#%',
            'show_all' => true,
            'type' => 'array',
            'end_size' => 2,
            'mid_size' => 1,
            'prev_next' => false,
            'prev_text' => sprintf('<i></i> %1$s', 'Anterior'),
            'next_text' => sprintf('%1$s <i></i>', 'Próximo'),
            'add_args' => false,
            'add_fragment' => '',
        );

        $posts = $query->posts;
        $arrResult['max_num_pages'] = $query->max_num_pages;
        $arrResult['paginacao'] = $paginacao;

        foreach ($posts as $post) {


            $arrData['objeto'] = $post;
            $arrData['id'] = $post->ID;
            $arrData['name'] = $post->post_title;
            $arrData['regular_price'] = get_post_meta($post->ID, 'alt_preco', true) ?? 0;
            $arrData['slug'] = get_permalink($post->ID);

            $obj_tipo = get_the_terms($post->ID, 'tipo');
            $arrData['tipo'] = $obj_tipo[0]->name ?? null;


            $objMarca = get_the_terms($post->ID, 'marca', true);
            $arrData['marca'] = $objMarca[0]->name ?? null;


            $objModelo = get_the_terms($post->ID, 'modelo');
            $arrData['modelo'] = $objModelo[0]->name ?? null;


            $objCarroceria = get_the_terms($post->ID, 'carroceria');
            $arrData['carroceria'] = $objCarroceria[0]->name;


            $arrData['description'] = $post->post_content;

            $arrData['imagem_principal'] = get_the_post_thumbnail_url($post->ID, 'full');


            $info = get_post_meta($post->ID);
            $info['alt_acessorios'] = get_post_meta($post->ID, 'alt_acessorios', true);
            unset($info['alt_imagens']);
            unset($info['_edit_lock']);
            unset($info['_edit_last']);
            unset($info['_thumbnail_id']);


            foreach ($info as $key => $meta) {


                $value = $meta[0];
                if ($key == 'alt_acessorios') {

                    foreach ($meta as $i => $acessorio) {
                        $value[] = $acessorio;
                    }
                    if (isset($value['descricao'])) {
                        unset($value['descricao']);
                    }


                }


                $save_meta['value'] = $value;
                $save_meta['key'] = $key;
                $arrData['meta_data'][] = $save_meta;

            }


            //Carregar Imagens
            $position = 0;
            $arrListImagens = get_post_meta($post->ID, 'alt_imagens', true);
            if(!empty($arrListImagens)){
                foreach ($arrListImagens as $imagens) {


                    $name = basename($imagens);

                    $save_img['src'] = $imagens;
                    $save_img['name'] = $name;
                    $save_img['alt'] = $name;
                    $save_img['position'] = $position;

                    $arrData['images'][] = $save_img;

                    $position++;
                }
            }



            $arrResult['veiculos'][] = $arrData;

        }

        wp_reset_postdata();

        wp_reset_query();

        return $arrResult;


    }
}

if (!function_exists('alt_query_filtro_veiculos')) {
    add_action('alt_query_filtro_veiculos', 'alt_query_filtro_veiculos');
    function alt_query_filtro_veiculos()
    {

        $meta_query = [];
        if (isset($_GET['destaque'])) {

            $meta_query[] = array(
                'key' => 'alt_destaque',
                'value' => 'on',
                'compare' => '='
            );


        }

        if (isset($_GET['carrozero'])) {

            $meta_query['relation'] = 'OR';
            $meta_query[] = array(
                'key' => 'alt_zerokm',
                'compare' => '=',
                'value' => 'on'
            );

            $meta_query[] = array(
                'key' => 'alt_zerokm',
                'compare' => '=',
                'value' => '1'
            );


        }


        if (isset($_GET['repasse'])) {
            $valor = $_GET['repasse'];


            if ($valor == 'off') {
                $meta_query['relation'] = 'OR';
                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => ''
                );


            } else {
                $meta_query['relation'] = 'OR';
                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => 'on'
                );

                $meta_query[] = array(
                    'key' => 'alt_repasse',
                    'compare' => '=',
                    'value' => '1'
                );

            }


        }

        if (isset($_GET['min_km'])) {
            $meta_query[] = array(
                'key' => 'alt_kilometragem',
                'value' => $_GET['min_km'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_km'])) {
            $meta_query[] = array(
                'key' => 'alt_kilometragem',
                'value' => $_GET['max_km'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['min_preco'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => $_GET['min_preco'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_preco'])) {
            $meta_query[] = array(
                'key' => 'alt_preco',
                'value' => $_GET['max_preco'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['filial'])) {
            $meta_query[] = array(
                'key' => 'alt_localizacao',
                'value' => $_GET['filial'],
                'compare' => '=',

            );
        }

        if (isset($_GET['ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['ano'],
                'compare' => '=',

            );
        }


        if (isset($_GET['min_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['min_ano'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['max_ano'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['cambio'])) {
            $meta_query[] = array(
                'key' => 'alt_cambio',
                'value' => $_GET['cambio'],
                'compare' => '=',

            );
        }

        if (isset($_GET['combustivel'])) {
            $meta_query[] = array(
                'key' => 'alt_combustivel',
                'value' => $_GET['combustivel'],
                'compare' => '=',

            );
        }


        if (isset($_GET['min_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['min_ano'],
                'compare' => '>=',
                'type' => 'NUMERIC'
            );
        }

        if (isset($_GET['max_ano'])) {
            $meta_query[] = array(
                'key' => 'alt_ano_mod',
                'value' => $_GET['max_ano'],
                'compare' => '<=',
                'type' => 'NUMERIC'
            );
        }


        if (isset($_GET['acessorios'])) {

            $arrFiltroAcessorios = explode(':', $_GET['acessorios']);
            $meta_query['relation'] = 'OR';

            foreach ($arrFiltroAcessorios as $acessorio) {

                $meta_query[] = array(
                    'key' => 'alt_acessorios',
                    'value' => serialize($acessorio),
                    'compare' => 'LIKE',
                );
            }


        }


        if (isset($_GET['veiculo_id'])) {
            $return['post__in'] = array($_GET['veiculo_id']);
        }

        $return['meta_query'] = $meta_query;


        if (!empty($_GET['carroceria'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'carroceria',
                'field' => 'slug',
                'terms' => $_GET['carroceria'],
            );
        }

        if (!empty($_GET['tipo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'tipo',
                'field' => 'slug',
                'terms' => $_GET['tipo'],
            );
        }

        if (!empty($_GET['marca'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'marca',
                'field' => 'slug',
                'terms' => $_GET['marca'],
            );
        }

        if (!empty($_GET['modelo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'modelo',
                'field' => 'slug',
                'terms' => $_GET['modelo'],
            );
        }
        if (!empty($_GET['tipo'])) {
            $return['tax_query'][] = array(
                'taxonomy' => 'tipo',
                'field' => 'slug',
                'terms' => $_GET['tipo'],
            );
        }


        if (isset($_GET['veiculo'])) {
            $return['s'] = $_GET['veiculo'];
        }

        return $return;
    }
}

if (!function_exists('alt_query_filtro_veiculos_ordenacao')) {
    function alt_query_filtro_veiculos_ordenacao()
    {

        $type = 'order_destaque_desc';
        switch ($_GET['orderby']) {
            case 'order_destaque_desc':
                $type = 'order_destaque_desc';
                break;
            case 'order_preco_desc':
                $type = 'order_preco_desc';
                break;
            case 'order_preco_asc':
                $type = 'order_preco_asc';
                break;
            case 'order_ano_desc':
                $type = 'order_ano_desc';
                break;
            case 'order_ano_asc':
                $type = 'order_ano_asc';
                break;

        }


        if ($type == 'order_destaque_desc') {
            return [
                //'meta_key' => 'alt_destaque',
                'orderby' => 'alt_destaque',
                'order' => 'DESC'
            ];
        }

        if ($type == 'order_preco_desc') {
            return [
                'meta_key' => 'alt_preco',
                'orderby' => 'meta_value_num',
                'order' => 'DESC',
            ];
        }

        if ($type == 'order_preco_asc') {
            return [
                'meta_key' => 'alt_preco',
                'orderby' => 'meta_value_num',
                'order' => 'ASC',
            ];
        }

        if ($type == 'order_ano_desc') {
            return [
                'meta_key' => 'alt_ano_mod',
                'orderby' => 'meta_value_num',
                'order' => 'DESC',
            ];
        }

        if ($type == 'order_ano_asc') {
            return [
                'meta_key' => 'alt_ano_mod',
                'orderby' => 'meta_value_num',
                'order' => 'ASC',
            ];
        }


        return [];
    }

}

if (!function_exists('alt_delete_veiculos')) {
    function alt_delete_veiculos($post_id)
    {


        $post = get_post($post_id);

        if (empty($post)) {
            return ['msg' => 'Veiculo não encontrado'];
        }

        wp_delete_attachment($post_id);


        if (empty($post)) {
            return ['msg' => 'Nenhum veiculo localizado'];
        };

        $arrImagens = alt_get_caracteristicas($post_id, 'alt_imagens');


        if ($arrImagens):
            foreach ($arrImagens as $id => $attachment):
                wp_delete_attachment($id, true);
                wp_delete_post($id, true);
            endforeach;
        endif;

        wp_delete_attachment($post_id, true);
        wp_delete_post($post_id, true);

        return ['msg' => 'Removido com sucesso'];
    }
}

if (!function_exists('alt_editar_incluir_veiculo')) {
    function alt_editar_incluir_veiculo($request)
    {

        $nome = $request['name'];
        $slug = $request['slug'];
        $description = $request['description'];


        $id = $request['id'];

        $my_post = array(
            'ID' => $id,
            'post_title' => wp_strip_all_tags($nome),
            'post_content' => $description,
            'post_type' => 'veiculos',
            'post_status' => 'publish',
            'post_author' => get_current_user_id()

        );


        if (empty($id)) {
            $post_id = wp_insert_post($my_post);
        } else {
            $post_id = $id;
            wp_update_post($my_post);
        }


        //$post_id = 98512;

        /**
         * Associar meta dados
         */
        foreach ($request['meta_data'] as $data) {
            if (!add_post_meta($post_id, $data['key'], $data['value'], true)) {
                update_post_meta($post_id, $data['key'], $data['value']);
            }
        }


        /**
         * Associar preço do veiculo
         */

        if (!add_post_meta($post_id, 'alt_preco', $request['regular_price'], true)) {
            update_post_meta($post_id, 'alt_preco', $request['regular_price']);
        }


        /**
         * Associar imagens ao veiculo
         */

        if (isset($request['images']) && !empty($request['images'])) {


            alt_salvar_imagem_no_veiculo($post_id, $request['images']);


            // $arrImg['98480'] = 'http://wordpress.local/wp-content/uploads/2020/09/42404a817e786fcc60be6c13abd5ce5a.jpg';


        }

        /**
         * Associar Carroceria
         */
        $carroceria = $request['carroceria'] ?? null;
        if (empty($carroceria) || strtolower($carroceria) == 'null' || $carroceria == null) {
            $carroceria = "Não definida";
        }
        $terms_carroceria = term_exists($carroceria, 'carroceria', 0);

        if (empty($terms_carroceria)) {
            $terms_carroceria = wp_insert_term($carroceria, 'carroceria', array('parent' => 0));
        }
        $parent_carroceria_id = $terms_carroceria['term_id'];
        wp_set_post_terms($post_id, $parent_carroceria_id, 'carroceria');


        /**
         * Associar veiculo a uma carroceria
         */
        $tipo = $request['tipo'] ?? 'Não definida';
        $termsTipo = term_exists($tipo, 'tipo', 0);
        if (empty($termsTipo)) {
            $termsTipo = wp_insert_term($tipo, 'tipo', array('parent' => 0));
        }
        $parent_tipo_id = $termsTipo['term_id'];
        wp_set_post_terms($post_id, $parent_tipo_id, 'tipo');


        /**
         * Associar veiculo a uma marca
         */
        $marca = $request['marca'] ?? 'Não definida';
        $termsMarca = term_exists($marca, 'marca', 0);


        if (empty($termsMarca)) {
            $termsMarca = wp_insert_term($marca, 'marca', array('parent' => 0));
        }
        $parent_marca_id = $termsMarca['term_id'];
        wp_set_post_terms($post_id, $parent_marca_id, 'marca');


        /**
         * Associar veiculo a um modelo
         */
        $modelo = $request['modelo'] ?? 'Não definida';
        $termsModelo = term_exists($modelo, 'modelo', 0);
        if (empty($termsModelo)) {
            $termsModelo = wp_insert_term($modelo, 'modelo', array('parent' => 0));
        }
        $parent_modelo_id = $termsModelo['term_id'];
        wp_set_post_terms($post_id, $parent_modelo_id, 'modelo');


        /**
         * Definir titulo pelo sistema
         */
        $nome = alt_formatar_titulo($post_id, $request);


        $response = [
            'nome' => $nome,
            'id' => $post_id
        ];

        return $response;
    }
}

if (!function_exists('alt_formatar_titulo')) {
    function alt_formatar_titulo($post_id, $request)
    {


        $arrFormacao = get_formacao_titulo();


        if (!empty($arrFormacao)) {
            $nome = "";
            foreach ($arrFormacao as $indices) {

                if ($indices == 'marca') {
                    $objMarca = get_the_terms($post_id, 'marca');
                    $nome .= $objMarca[0]->name . ' ';
                }
                if ($indices == 'modelo') {
                    $objModelo = get_the_terms($post_id, 'modelo');
                    $nome .= $objModelo[0]->name . ' ';
                }
                if ($indices == 'modelo_complemento') {


                    $value = $request[array_search('alt_modelo_complemento', array_column($request, 'key'))]->value;
                    $modelo_complemento = $value ?? get_post_meta($post_id, 'alt_modelo_complemento', true);

                    if (!empty($modelo_complemento)) {
                        $nome .= $modelo_complemento . ' ';
                    }
                }
                if ($indices == 'ano_fabricacao') {

                    $value = $request[array_search('alt_ano_fab', array_column($request, 'key'))]->value;
                    $ano_fabricacao = $value ?? get_post_meta($post_id, 'alt_ano_fab', true);

                    if (!empty($ano_fabricacao)) {
                        $nome .= $ano_fabricacao . ' ';
                    }

                }
                if ($indices == 'ano_modelo') {

                    $value = $request[array_search('alt_ano_mod', array_column($request, 'key'))]->value;
                    $ano_modelo = $value ?? get_post_meta($post_id, 'alt_ano_mod', true);

                    //Adicionar uma barra entre o ano fab e ano mod
                    if (isset($ano_fabricacao)) {
                        $nome = substr($nome, 0, -1);
                        $nome .= '/';
                    }

                    if (!empty($ano_modelo)) {
                        $nome .= $ano_modelo . ' ';
                    }
                }
                if ($indices == 'cor') {

                    $value = $request[array_search('alt_cor', array_column($request, 'key'))]->value;
                    $cor = $value ?? get_post_meta($post_id, 'alt_cor', true);


                    if (!empty($cor)) {
                        $nome .= $cor . ' ';
                    }
                }
                if ($indices == 'porta') {

                    $value = $request[array_search('alt_portas', array_column($request, 'key'))]->value;
                    $portas = $value ?? get_post_meta($post_id, 'alt_portas', true);

                    if (!empty($portas)) {
                        $nome .= $portas . 'P ';
                    }
                }
                if ($indices == 'cambio') {
                    $value = $request[array_search('alt_cambio', array_column($request, 'key'))]->value;
                    $cambio = $value ?? get_post_meta($post_id, 'alt_cambio', true);

                    if (!empty($cambio)) {
                        $nome .= $cambio . ' ';
                    }
                }


            };


            $my_post = array(
                'ID' => $post_id,
                'post_title' => $nome
            );

            wp_update_post($my_post);

            return $nome;
        }
    }
}

if (!function_exists('alt_salvar_imagem_no_veiculo')) {
    function alt_salvar_imagem_no_veiculo($parent_post_id, $arrImagens)
    {


        //Ler todas as imagens
        $arrImg = [];
        foreach ($arrImagens as $indice => $image) {
            try {


                $url_original = $image['src'];
                $upload_dir = wp_upload_dir();
                $image_data = file_get_contents($url_original);
                $filename = basename($url_original);

                if (wp_mkdir_p($upload_dir['path'])) {
                    $file = $upload_dir['path'] . '/' . $filename;
                } else {
                    $file = $upload_dir['basedir'] . '/' . $filename;
                }

                file_put_contents($file, $image_data);


                $wp_filetype = wp_check_filetype($filename, null);

                $attachment = array(
                    'post_mime_type' => $wp_filetype['type'],
                    'post_title' => sanitize_file_name($filename),
                    'post_content' => '',
                    'post_status' => 'inherit'
                );

                $attach_id = wp_insert_attachment($attachment, $file, $parent_post_id);

                require_once(ABSPATH . 'wp-admin/includes/image.php');
                $attach_data = wp_generate_attachment_metadata($attach_id, $file);
                $res1 = wp_update_attachment_metadata($attach_id, $attach_data);


                if ($indice == 0) {
                    $res2 = set_post_thumbnail($parent_post_id, $attach_id);
                }


                $arrImg[$attach_id] = $upload_dir['baseurl'] . '/' . $attach_data['file'];

            } catch (Exception $e) {
                throw $e;
            }


        }

        //Serilizar os dados
        //Associar os dados com um campo
        if (!add_post_meta($parent_post_id, 'alt_imagens', $arrImg, true)) {
            update_post_meta($parent_post_id, 'alt_imagens', $arrImg);
        }


    }
}
