<?php


function api_veiculos_get()
{
    $user = get_current_user_id();

    if (empty($user)) {
        $response = new WP_Error('acesso', 'Usuário sem permissão para listar veículos', ['status' => 403]);
        return rest_ensure_response($response);
    }

    $response = alt_lista_veiculos();

    return rest_ensure_response($response);
}

function api_veiculos_delete($request)
{

    $user = wp_get_current_user();

    try {

        //Validar informações obrigatórias
        if (empty($user)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        $data = $request->get_params();
        if (isset($data['id'])) {
            $post_id = $data['id'];
        }else{
            throw new \Exception('Nenhum ID informado');
        }



        $response = alt_delete_veiculos($post_id);

    } catch (\Exception $e) {


        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);


    }


    return rest_ensure_response($response);


}

function api_veiculos_post($request)
{
    $user = wp_get_current_user();


    try {

        //Validar informações obrigatórias

        if (empty($user)) {
            throw new \Exception('Usuário sem permissão', 403);
        }

        if (!isset($request['tipo']) || empty($request['tipo'])) {
            throw new \Exception('Informe o tipo do veículo', 403);
        }
        if (!isset($request['marca']) || empty($request['marca'])) {
            throw new \Exception('Informe a marca do veículo', 403);
        }
        if (!isset($request['modelo']) || empty($request['modelo'])) {
            throw new \Exception('Informe o modelo do veículo', 403);
        }


        $response = alt_editar_incluir_veiculo($request);

    } catch (\Exception $e) {

        $response = new WP_Error($e->getCode(), $e->getMessage(), ['status' => $e->getCode()]);
    }


    return rest_ensure_response($response);
}


function registrar_api_rest_veiculos()
{
    register_rest_route(
        'api/v1',
        '/veiculos',
        [
            'methods' => WP_REST_Server::READABLE,
            'callback' => 'api_veiculos_get'
        ]
    );

    register_rest_route(
        'api/v1',
        '/veiculos',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_veiculos_post'
        ]
    );
    register_rest_route(
        'api/v1',
        '/veiculos/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::EDITABLE,
            'callback' => 'api_veiculos_post'
        ]
    );

    register_rest_route(
        'api/v1',
        '/veiculos/(?P<id>\d+)',
        [
            'methods' => WP_REST_Server::DELETABLE,
            'callback' => 'api_veiculos_delete'
        ]
    );


}

function expire_token()
{
    return time() + (60 * 60 * 24);
}

add_action('jwt_auth_expire', 'expire_token');
add_action('rest_api_init', 'registrar_api_rest_veiculos');


add_action('wp_ajax_nopriv_alt_load_filtro', 'alt_load_filtro');
add_action('wp_ajax_alt_load_filtro', 'alt_load_filtro');
function alt_load_filtro()
{

    $filter = [];

    /*
    if (!empty($_GET['marca'])) {
        $filter['tax_query'][] = array(
            'taxonomy' => 'marca',
            'field' => 'slug',
            'terms' => $_GET['marca'],
        );
    }
    */
    /*if (!empty($_GET['modelo'])) {
        $filter['tax_query'][] = array(
            'taxonomy' => 'modelo',
            'field' => 'slug',
            'terms' => $_GET['modelo'],
        );
    }*/

    //Busca os dados que queremos
    $args = array(
        'posts_per_page' => '-1',
        'post_type' => 'veiculos',
        'post_status' => array('publish'),
    );


    if (!empty($filter)) {
        $args = array_merge($args, $filter);
    }
    $query = new WP_Query($args);


    $arrDados = $query->posts;

    foreach ($arrDados as $veiculo) {


        $ano = get_post_meta($veiculo->ID, 'alt_ano_mod', true) ?? null;
        $arrReturn['ano'][$ano] = intval($ano);


        $combustivel = get_post_meta($veiculo->ID, 'alt_combustivel', true) ?? null;
        $arrReturn['combustivel'][$combustivel] = $combustivel;


        $cambio = get_post_meta($veiculo->ID, 'alt_cambio', true) ?? null;
        $arrReturn['cambio'][$cambio] = $cambio;


        $arrDados = get_the_terms($veiculo->ID, 'marca');
        foreach ($arrDados as $item) {
            $arrReturn['marca'][$item->slug] = array(
                'term_id' => $item->term_id,
                'slug' => $item->slug,
                'name' => $item->name
            );
        };

        $arrDados = get_the_terms($veiculo->ID, 'modelo');
        foreach ($arrDados as $item) {
            $arrReturn['modelo'][$item->slug] = array(
                'term_id' => $item->term_id,
                'slug' => $item->slug,
                'name' => $item->name
            );
        };


    }


    if (empty($arrReturn)) {
        return [];
    }
    header('Content-Type: application/json');
    echo json_encode($arrReturn);
    die;

}
