<?php
require_once plugin_dir_path( __FILE__ ) . '../metabox/metabox_depoimentos.php';

function alt_post_depoimentos()
{
    add_image_size('alt-depoimentos', 300, 300, true);
    $args_cursos_post_type = array(
        'labels' => array('name' => 'Depoimentos', 'add_new' => 'Adicionar depoimentos', 'add_new_item'=>'Nome', 'edit_item'=>'Nome'),
        'public' => true,
        'menu_icon'=>'dashicons-admin-comments',
        'supports' => array('title','editor','thumbnail'),
        'register_meta_box_cb' => '');
    register_post_type('depoimentos', $args_cursos_post_type);
}

add_action('init', 'alt_post_depoimentos');

add_shortcode('shortcode_depoimentos', 'shortcode_depoimentos');

function shortcode_depoimentos()
{


    global $post;
    ob_start();
    // WP Query Parameters
    $args = array(
        'post_type' => 'depoimentos',
        'post_status' => array('publish')
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) :

        while ($query->have_posts()) : $query->the_post();

            $nome = get_the_title();

            $foto = get_the_post_thumbnail_url(get_the_ID(),'alt-depoimentos');



            include('template/depoimentos.php');


            ?>

        <?php
        endwhile;
    endif;

}


if (!function_exists('alt_listar_depoimentos')) {
    add_action('alt_listar_depoimentos', 'alt_listar_depoimentos');
    function alt_listar_depoimentos()
    {

        $args = array('numberposts' => 10, 'post_type' => 'depoimentos', 'post_status' => array('publish'));
        $posts = get_posts($args);
        $arrPosts = [];
        foreach ($posts as $post) {


            $url_img = get_the_post_thumbnail_url($post->ID, 'alt-depoimentos');
            if (!filter_var($url_img, FILTER_VALIDATE_URL)) {
                $url_img = 'https://via.placeholder.com/55';
            }

            $arrData['titulo'] = $post->post_title;
            $arrData['url_img'] = $url_img;
            $arrData['content'] = $post->post_content;
            $arrData['nome'] = get_post_meta($post->ID, 'nome', true) ?? null;
            $arrData['cargo'] = get_post_meta($post->ID, 'cargo', true) ?? null;


            $arrPosts[] = $arrData;
        }

        return $arrPosts;

    }


}
