//===============
//	VARIÁVEIS GLOBAIS
//	Declaradas como propriedades de objeto para dar namespace
//===============
var g = {};

(function($){
	//===============
	//  TOGGLES GENÉRICOS
	//  Abre e fecha itens por clique
	//  Depende da aplicação de data-attributes ou aria-roles específicos
	//===============
	$.fn.toggleItem = function (options) {
		var defaults = {
			type: 'aria' // 'aria' apenas manipula os atributos ARIA, 'class' adiciona classe ao toggle. 'toggle' utiliza a função .toggle() do jQuery
		};

		var settings = $.extend( {}, defaults, options );

		function ariaSetup (toggle, target) {
			if ( settings.type == 'aria' ) {
				if ( toggle.attr('aria-expanded') == 'false' ) {
					target.attr('aria-hidden', 'true');
				} else {
					target.attr('aria-hidden', 'false');
				}
			} else {
				toggle.removeAttr('aria-controls').removeAttr('aria-expanded');
			}
		}

		// Destrói Toggle
		this.destroyToggle = function () {
			this.each( function () {
				var target = $('#' + $(this).attr('aria-controls') );

				$(this).unbind('click');
				$(this).attr('aria-expanded', 'false');
				target.removeAttr('aria-hidden');
			});
		}

		// Retorna em um .each para que o plugin se aplique independentemente a cada instância da collection selecionada
		return this.each( function () {
			var toggle = $(this);
			var target = $('#' + toggle.attr('aria-controls') );

			ariaSetup( toggle, target );

			toggle.on('click', function () {
				if ( settings.type == 'aria' ) {
					if ( toggle.attr('aria-expanded') == 'false' ) {
						toggle.attr('aria-expanded', 'true');
						target.attr('aria-hidden', 'false');
					} else {
						toggle.attr('aria-expanded', 'false');
						target.attr('aria-hidden', 'true');
					}    
				}
				else if ( settings.type == 'toggle' ) {
					target.toggle();                
				} else if ( settings.type == 'class' ) {
					toggle.toggleClass('is-opened'); 
				}
			})          
		})
	}
})(jQuery);

$(document).ready(function () {
	g.page = $('body');

	//===============
	//	BREAKPOINTS UTILIZADOS
	//  Mudá-los aqui implica em mudá-los no /template/[TEMA_ATUAL]/scss/_variaveis.scss
	//===============
	g.bp = {
		xs: 0,
		sm: 425,
		md: 768,
		lg: 1024,
		xg: 1104
	}

	g.dimensions = {
		width: $(window).outerWidth(),
		height: $(window).outerHeight(),
	}

	// Toggles e Accordions em mobile
	if ( Modernizr.mq('(max-width: '+ g.bp['md'] +'px)')) {
		// Implementa os toggles
		toggle = $('.menu-principal_toggle').toggleItem({type: 'aria'});

		// Se o filtro por faixa de preço está aberto
		if ( $("#filtro_faixa_preco").attr('data-accordion-opened') == "true" ) {
			// Clica no botão dele para fechar
			$("#filtro_faixa_preco").parent().prev().trigger('click');
		}
	}

	// Ao redimensionar
	$(window).resize( function () {
		// Se a janela tiver aumentado de tamanho
		if ( g.dimensions.width < $(window).outerWidth() ) {
			// Verifica se passou do tamanho médio
			if ( Modernizr.mq('(min-width: '+ (g.bp['md'] + 1) +'px)')) {
				// Destrói o toggle
				toggle.destroyToggle();
				setFixedHeader();
			}			

			// Verifica se passou do tamanho grande
			if ( Modernizr.mq('(min-width: '+ (g.bp['lg'] + 1) +'px)')) {
				setFooterPadding();
			}
		} else {
			// Se diminuiu de tamanho e ficou menor que o tamanho médio
			if ( Modernizr.mq('(max-width: '+ g.bp['md'] +'px)')) {
				// Refaz o toggle
				toggle = $('.menu-principal_toggle').toggleItem({type: 'aria'});
				resetFixedHeader();
			}

			// Se diminuiu de tamanho e ficou menor que o tamanho grande
			if ( Modernizr.mq('(max-width: '+ g.bp['lg'] +'px)')) {
				resetFooterPadding();
			}
		}

		// Atualiza dimensões da janela
		g.dimensions = {
			width: $(window).outerWidth(),
			height: $(window).outerHeight(),
		}
	})

	//===============
	//	SLIDER DE BANER IMAGENS
	//  Galeria de imagens primárias do veículo
	//===============
    if ($('.veiculo-aberto_slider-principal .veiculo-aberto_slider-principal_slide').length > 1 ){
        var slider = $('.veiculo-aberto_slider-principal').bxSlider({
            pagerCustom: '.mini_imagem',
            infiniteLoop: false,
            keyboardEnabled:true,
            prevText: 'Anterior',
            nextText: 'Próximo',
        })
    }

    //===============
    //	SLIDER DE IMAGENS
    //  Galeria de imagens secundárias do veículo
    //===============
    if ($('.miniatura_slides .mini_imagem').length > 1 ) {
        $('.miniatura_slides').bxSlider({
            auto: false,
            slideWidth: 171,
            slideMargin: 10,
            minSlides: 2,
            maxSlides: 4,
            pager: false,
            controls: true,
            infiniteLoop: false,
            prevText: "Anterior",
            nextText: "Próximo"
        })
    }

	//===============
	//	SLIDER DA HOME
	//===============
	if ( $('.banner-slider .banner-slider_slide').length > 1 ) {
		var slider = $('.banner-slider').bxSlider({
			auto: true,
			mode: 'horizontal',
			controls: true,
			pager: false,
			pause: 5000,
            touchEnabled: false,
			duration: 1000,
			preloadImages: true,
			prevText: 'Anterior',
			nextText: 'Próximo',
			adaptiveHeight: true
		})


	}

	//===============
	//	VÍDEOS RESPONSIVOS
	//===============
	$('.video').fitVids();

	//===============
	//	TOPO FIXO
	//===============
	function setFixedHeader () {
		var linha_1_height = $('.topo_linha-1').outerHeight();
		var linha_2_height = $('.topo_linha-2').outerHeight();

		// Dá um padding no topo para criar espaço para acomodar os itens fixos
		$('.topo').css({ 'padding-top': linha_1_height + linha_2_height });
		// Move a linha 2 para debaixo da linha 1
		$('.topo_linha-2').css({ top: linha_1_height });		
	}

	function resetFixedHeader () {
		$('.topo, .topo_linha-2').attr('style', '');
	}

	if (
		g.page.hasClass('has-topo-fixo')
		&&  Modernizr.mq('(min-width: '+ (g.bp['md'] + 1) +'px)')
	) {
		setFixedHeader();
	}

	//===============
	//	PADDING RODAPÉ FIXO
	//  Ajusta padding ao fim do site para acomodar o rodapé fixo
	//===============
	function setFooterPadding () {
		var fixed_footer_height = $('.rodape-fixo').outerHeight();

		$('.rodape_linha-2').css({ 'padding-bottom': fixed_footer_height + 15 })
	}

	function resetFooterPadding () {
		$('.rodape_linha-2').attr('style', '');
	}

	if (
		$('.rodape-fixo').length > 0
		&&  Modernizr.mq('(min-width: '+ (g.bp['lg'] + 1) +'px)')
	) {
		setFooterPadding();
	}
});	

$(window).load( function () {
	//===============
	// ALTURAS DE PRODUTOS
	// Ajuste de altura de produtos nas listagens
	//===============
	function adjustHeights() {
		var selector = '.veiculo';
		var itens = $(selector).length; // Conta itens da lista
		var heights = []; // Inicia array de alturas (conjunto de alturas por linha)
		var offsets = []; // Inicia array de offsets (para contagem de linhas)

		// Limpa min-heights, para resetar quando for executado mais uma vez
		$(selector).css({'min-height': ''});
		
		// Conta linhas
		$(selector).each( function (index) {
			var current_offset = $(this).offset().top; // Guarda o offset atual
			
			// Se o offset atual ainda não existe no array de offsets, é porque é uma nova linha
			if ( $.inArray( current_offset, offsets ) == -1 ) {
				// Guarda offset da linha na lista
				offsets.push(current_offset);

				// Se já tiver havido quebra de linha (evidenciado pelo aumento do tamanho do array de offsets)
				if ( offsets.length == 2 ) {
					// Determina o índice do item que quebra linha como quantidade de "itens por linha"
					itens_by_line = index;
				}           
			}
		});

		// Caso não tenha havido nenhuma quebra de linha, é porque temos menos itens que o necessário para isso. Então, define-se a quantidade absoluta de itens como itens por linha
		if ( itens_by_line == undefined ) {
			var itens_by_line = itens;
		}
		
		var line_amount = Math.ceil( itens / itens_by_line );
		line_number = 0; // Inicia a contagem de linhas em zero
		heights[line_number] = []; // Cria conjunto vazio de alturas no primeiro item do array de alturas
		var line_heights = []; // Inicia array com alturas de uma linha específica

		// Cria um array de alturas para cada linha
		// Para cada item
		$(selector).each( function (index) {
			// Verifica se o índice é divisível pela quantidade de itens da linha.
			// Se for divisível, é porque é uma nova linha
			if ( index % itens_by_line == 0 )   {
				line_heights = []; // Reseta o array de alturas, para uma nova linha
				
				// Incrementa o número da linha, mas apenas se não for o primeiro item
				if (index != 0) {
					line_number++;
				}
				
				// Ao fim do processo, guarda a lista de alturas no item do array de alturas, no índice correspondente ao número da linha, de modo que cada linha tenha um array de alturas correspondente aos seus itens
				heights[line_number] = line_heights;
			}
			
			line_heights.push( $(this).outerHeight() ); // Inclui a altura do item atual, isso sempre ocorre
		});

		// O array de offsets tem que ter o mesmo número de itens que o de alturas, pois os itens correspondem à quantidade de linhas
		// console.log(offsets);
		// console.log(heights);
		// console.log(line_amount);

		// Circula pelos itens para aplicar alturas
		$(selector).each( function (index) {
			line_number_in_array = Math.floor(index / itens_by_line); // Verifica a qual linha este item pertence
			line_max_height = Math.max.apply( null, heights[line_number_in_array] ); // Verifica a maior altura dentre os itens desta linha

			// Aplica a maior altura ao item
			$(this).css({'min-height': line_max_height});
		})
	}

	// Executa o ajuste de altura
	adjustHeights();

	// Executa o ajuste ao redimensionar a tela
	$(window).resize( function() {
		adjustHeights();
	});
	
})