var parvusTableOrder = 0;

(function ($)
{

    $.fn.parvusTable = function (config,param)
    {

        var carregado = true;
        var renderizado = false;
        var tableId;

        var configuracao = $.extend ({
            header : {
                class : 'table table-bordered table-hover table-striped'
            },
            filter : {
                class : 'alert alert-warning'
            }
        }, config);

        var parametro = $.extend ({
            pagina  : 1,
            limite  : 100,
            inicio  : 0,
            total   : 0,
            order   : '',
            orderby : ''
        }, param);

        var label = $.fn.parvusTable.label;

        this.carrega = function ()
        {

            var objeto = this;
            var temFiltro = false;

            if (!renderizado)
            {

                this.renderiza();

            }

            /** Gatilho antes de iniciar o carregamento **/
            objeto.trigger('carregando',objeto);

            parametro.inicio = (parametro.pagina - 1) * parametro.limite;

            $(objeto).find('.parvus-table-filtro-input,.parvus-table-filtro-select').each (function ()
            {

                var value = $(this).val();

                parametro[$(this).attr('name').replace('parvus-filtro-','')] = value;

                if (value != '')
                {

                    temFiltro = true;

                }

            });

            var URL = configuracao.ajax.URL;

            if (typeof(configuracao.ajax.URL) == 'function')
            {

                URL = configuracao.ajax.URL();

            }

            $.ajax({
                url		: URL,
                data	: $.param($.extend({}, parametro)),
                type	: 'GET',
                success : function (prJSON)
                {

                    var HTML = '';

                    $(prJSON.body).each (function (i,data)
                    {

                        var classe = '';

                        if (data.row !== undefined)
                        {

                            classe = data.row.class;

                        }

                        HTML += '<tr class="'+classe+'">';

                            $.each (configuracao.column, function (i,item)
                            {

                                var value = data.column[item.name];

                                if (value == null)
                                {

                                    value = '';

                                }

                                HTML += '<td align="'+item.align+'">'+value+'</td>';

                            });

                        HTML += '</tr>';

                    });

                    if (HTML == '')
                    {

                        HTML += '<tr><td colspan="100" align="center"><b>'+label.zerado+'</b></td></tr>';

                    }

                    $(objeto).find('tbody').html(HTML);

                    objeto.paginacao (prJSON.head.item);

                    localStorage.removeItem(tableId);

                    localStorage.setItem(tableId, JSON.stringify($.extend({}, parametro)));

                    carregado = true;

                    if (temFiltro)
                    {

                        objeto.find('.parvus-table-acao').append('<p class="'+configuracao.filter.class+'">'+label.filtro.aviso+' <a href="javascript:void(0);" class="parvus-table-filtro-remove">'+label.filtro.remover+'</a></p>');

                        $(objeto).find('.parvus-table-filtro-remove').on('click',function ()
                        {

                            $(objeto).find('.parvus-table-filtro-input, .parvus-table-filtro-select').val('').trigger('focusout');

                            objeto.carrega();

                        });

                    }

                    setTimeout(function ()
                    {

                        /** Gatilho ao terminar de carregar **/
                        objeto.trigger('carregado',objeto);

                    },50);

                }
            });

        };

        this.paginacao = function (prTotal)
        {

            parametro.total  = prTotal;
            var objeto       = this;
            var elemento     = $(this);
            var quantidade   = Math.ceil(prTotal / parametro.limite);
            var HTML         = '';

            HTML = '<div class="row">';

                HTML += '<div class="col-lg-4 col-md-4">';

                    HTML+= '<p class="parvus-table-exibicao">';

                        var resultadoLabel = label.exibicao;

                        resultadoLabel = resultadoLabel.replace('{1}',parametro.inicio + 1);
                        resultadoLabel = resultadoLabel.replace('{2}',parametro.inicio + parametro.limite);
                        resultadoLabel = resultadoLabel.replace('{3}',parametro.total);

                        HTML+= resultadoLabel;

                    HTML+= '</p>';

                HTML += '</div>';

                HTML += '<div class="col-lg-8 col-md-8">';

                    HTML+= '<ul class="pagination pull-right">';

                        for (var x = 1; x <= quantidade; x ++)
                        {

                            HTML += '<li class="'+(x == parametro.pagina ? 'active' : '')+'"><a href="javascript:void(0);" class="parvus-table-paginacao-link">'+x+'</a></li>';

                        }

                    HTML += '</ul>';

                HTML += '</div>';

            HTML += '</div>';

            elemento.find('.parvus-table-acao').html(HTML);

            elemento.find('.parvus-table-coluna-ordena').off().on('click',function ()
            {

                var th = $(this);

                var trOrderbyAsc  = 'parvus-table-orderby-asc';
                var trOrderbyDesc = 'parvus-table-orderby-desc';

                parametro.order   = th.data('parvus-table-name');
                parametro.orderby = th.hasClass(trOrderbyDesc) ? 'asc' : 'desc';

                $('.parvus-table-coluna-ordena').removeClass(trOrderbyAsc).removeClass(trOrderbyDesc);

                if (parametro.orderby == 'asc')
                {

                    th.addClass(trOrderbyAsc);
                    th.removeClass(trOrderbyDesc);

                }
                else
                {

                    th.addClass(trOrderbyDesc);
                    th.removeClass(trOrderbyAsc);

                }

                objeto.carrega();

            });

            elemento.find('.parvus-table-paginacao-link').off().on('click',function ()
            {

                var pagina = $(this).text();

                /** Gatilho antes de iniciar o carregamento **/
                objeto.trigger('paginado',[objeto,pagina]);

                parametro.pagina = pagina;

                objeto.carrega();

            });

            elemento.find('.parvus-table-filtro-input').off('focusin').on('focusin',function ()
            {

                var td = $(this).parents('td');

                td.find('.parvus-table-filtro-range').show();

            })
            .off('focusout').on('focusout',function ()
            {

                var td = $(this).parents('td');

                if ($(this).val() == '' && !$(this).hasClass('parvus-table-filtro-range'))
                {

                    td.find('.parvus-table-filtro-range').val('').hide();

                }

            })
            .off('keypress').on('keypress',function (event)
            {

                var tecla = event.keyCode?event.keyCode:event.which;

                if (tecla == 13 && carregado)
                {

                    /** Gatilho ao filtrar**/
                    objeto.trigger('filtrado',[objeto]);

                    carregado = false;

                    parametro.pagina = 1;

                    objeto.carrega();

                }

            });

            elemento.find('.parvus-table-filtro-select').on('change',function ()
            {

                /** Gatilho ao filtrar**/
                objeto.trigger('filtrado',[objeto]);

                carregado = false;

                parametro.pagina = 1;

                objeto.carrega();


            })

        };

        this.renderiza = function()
        {

            var elemento = $(this);

            if (tableId == null)
            {

                tableId = window.location.href+'-'+parvusTableOrder;

                var parametroStorage = $.parseJSON(localStorage.getItem(tableId));

                if (parametroStorage !== undefined && parametroStorage !== null)
                {

                    parametro = parametroStorage;

                }

                parvusTableOrder ++;

            }

            $.each (configuracao.column, function (i,item)
            {

                configuracao.column[i] = $.extend({
                    width: 'auto',
                    align: 'left',
                    filtra : true,
                    ordena: true,
                    range: false,
                    input : {
                        class : ''
                    }
                }, item);

            });

            var HTML = '';

            HTML = '<div class="parvus-table-acao clearfix"></div>';

            HTML += '<table width="100%" cellpadding="0" cellspacing="0" border="0" class="parvus-table-base '+configuracao.header.class+'">';

                HTML += '<thead>';

                    HTML += '<tr>';

                        $.each (configuracao.column, function (i,item)
                        {

                            var classe = '';

                            if (parametro.order == item.name)
                            {

                                classe = parametro.orderby == 'asc' ? 'parvus-table-orderby-asc' : 'parvus-table-orderby-desc';

                            }

                            HTML += '<th data-parvus-table-name="'+item.name+'" style="width:'+item.width+';'+(item.ordena ? 'cursor: pointer;' : '')+'" class="'+classe+' '+(item.ordena ? 'parvus-table-coluna-ordena' : '')+'">';

                                HTML += item.label;

                            HTML += '</th>';

                        });

                    HTML += '</tr>';

                    HTML += '<tr class="parvus-table-filtro">';

                        $.each (configuracao.column, function (i,item)
                        {

                            HTML += '<td>';

                                if (item.filtra)
                                {

                                    var name = item.name;
                                    var value  = '';

                                    if (parametro[name] !== undefined)
                                    {

                                        value = parametro[name];

                                    }

                                    if(item.enumeracao)
                                    {

                                        HTML += '<select class="form-control parvus-table-filtro-select '+item.input.class+'" name="parvus-filtro-'+name+'">';

                                            HTML += item.enumeracao;

                                        HTML += '</select>';

                                    }
                                    else
                                    {

                                        HTML += '<input type="text" class="form-control parvus-table-filtro-input '+item.input.class+'" name="parvus-filtro-'+name+'" value="'+value+'" />';

                                        if (item.range)
                                        {

                                            HTML += '<input style="display: none;" type="text" class="form-control parvus-table-filtro-range parvus-table-filtro-input '+item.input.class+'" name="parvus-filtro-'+name+'-2" value="'+value+'" />';

                                        }

                                    }

                                }

                            HTML += '</td>';

                        });

                    HTML += '</tr>';

                HTML += '</thead>';

                HTML += '<tbody></tbody>';

            HTML += '</table>';

            HTML += '<div class="parvus-table-acao"></div>';

            elemento.append(HTML);

            renderizado = true;

            setInterval(function ()
            {

                /** Gatilho ao renderizar a tabela**/
                elemento.trigger('renderizado',[]);

            },150);

        };

        return this;

    };

    $.fn.parvusTable.label = {
        'filtro'        : {
            'aviso'   : 'A consulta está sendo filtrada.',
            'remover' : 'Remover todos os filtros.'
        },
        'exibicao'      : 'Mostrando de <b>{1}</b> até <b>{2}</b> de <b>{3}</b> registros.',
        'zerado'        : 'Nenhum registro foi encontrado.'
    };

    $.fn.parvusTable.header = {
        class : 'table table-bordered table-hover table-striped'
    };

}(jQuery));