@extends('frontend/base/section')

@section('content')
    <style>
        .alert{
            background: #0a6aa1;
            color: #ffffff;
            padding: 10px;
            border-radius: 10px;
            float: left;
            margin-top: 30px;
        }
        .alert-completo{
            background: #0a6aa1;
            color: #ffffff;
            padding: 10px;
            border-radius: 10px;
            margin-top: 30px;
            text-align: center;
        }
    </style>
    <div class="centralizado">

        <h2 class="pagina_titulo visuallyhidden">{{ $pagina }}</h2>

        <div class="b-xs-12">

            @if(!empty($aMensagem))
                <div class="alert-completo">
                    {{$aMensagem}}
                </div>
            @endif

            <form id="formulario" class="form-ficha" method="POST" onsubmit="return validarFormulario()">


                <fieldset>

                    <legend>Dados Pessoais</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="nome">Nome: *</label>
                                    <input type="text" id="nome" name="nome" class="text" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="cpf">CPF: *</label>
                                    <input type="text" id="cpf" name="cpf"  class="text CPF" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="rg">RG: *</label>
                                    <input type="text" id="rg" name="rg"  class="text" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="orgao_emissor_rg">Órgão Emissor:</label>
                                    <input type="text" id="orgao_emissor_rg" name="orgao_emissor_rg" class="text" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="data_emissao_rg">Data Emissão:</label>
                                    <input type="text" id="data_emissao_rg" name="data_emissao_rg" class="text data" aria-required="true" required>
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="uf_rg">UF:</label>
                                    <select id="uf_rg" name="uf_rg" class="text" aria-required="true">
                                        {{ $aEnumeracao['estado'] }}
                                    </select>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="telefone">Telefone:</label>
                                    <input type="text" id="telefone" name="telefone" class="text telefone" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="celular">Celular:</label>
                                    <input type="text" id="celular" name="celular" class="text telefone" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="email">E-mail:</label>
                                    <input type="email" id="email" name="email" class="text" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="naturalidade">Naturalidade:</label>
                                    <input type="text" id="naturalidade" name="naturalidade" class="text" aria-required="true" required>
                                </div>
                            </div>

                        </div>


                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="data_nascimento">Data Nascimento:</label>
                                    <input type="text" id="data_nascimento" name="data_nascimento" class="text data" aria-required="true" required>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="sexo">Sexo:</label>
                                    <select id="sexo" name="sexo" class="text" aria-required="true">

                                        {{ $aEnumeracao['sexo'] }}

                                    </select>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="estado_civil">Estado Civil:</label>
                                    <select id="estado_civil" name="estado_civil" class="text" aria-required="true">

                                        {{ $aEnumeracao['estadoCivil'] }}

                                    </select>
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="profissao">Profissão:</label>
                                    <input type="text" id="profissao" name="profissao" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="numero_dependente">Nº Dependentes:</label>
                                    <input type="text" id="numero_dependente" name="numero_dependente" min="0" class="text inteiro" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="nome_pai">Nome do Pai:</label>
                                    <input type="text" id="nome_pai" name="nome_pai" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="nome_mae">Nome da Mãe:</label>
                                    <input type="text" id="nome_mae" name="nome_mae" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div><!-- .grid-container -->

                </fieldset>

                <fieldset>

                    <legend>Dados do Cônjuge</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="conjuge_nome">Nome:</label>
                                    <input type="text" id="conjuge_nome" name="conjuge_nome" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="conjuge_cpf">CPF:</label>
                                    <input type="text" id="conjuge_cpf" name="conjuge_cpf" class="text CPF" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="conjuge_rg">RG:</label>
                                    <input type="text" id="conjuge_rg" name="conjuge_rg" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="conjuge_data_nascimento">Data Nascimento:</label>
                                    <input type="text" id="conjuge_data_nascimento" name="conjuge_data_nascimento" class="text data" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div>

                </fieldset>

                <br>

                <fieldset>

                    <legend>Endereço</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-8">
                                <div class="campo">
                                    <label for="endereco_residencial">End. Residencial:</label>
                                    <input type="text" id="endereco_residencial" name="endereco_residencial" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_numero">Número:</label>
                                    <input type="text" id="endereco_numero" name="endereco_numero" min="0" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-8">
                                <div class="campo">
                                    <label for="endereco_complemento">Complemento:</label>
                                    <input type="text" id="endereco_complemento" name="endereco_complemento" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="endereco_bairro">Bairro:</label>
                                    <input type="text" id="endereco_bairro" name="endereco_bairro" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_cep">CEP:</label>
                                    <input type="text" id="endereco_cep" name="endereco_cep" class="text CEP" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="endereco_cidade">Cidade:</label>
                                    <input type="text" id="endereco_cidade" name="endereco_cidade" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_uf">UF:</label>
                                    <select id="endereco_uf" name="endereco_uf" class="text" aria-required="true">

                                        {{ $aEnumeracao['estado'] }}

                                    </select>
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_tipo_residencia">Tipo Residência:</label>
                                    <input type="text" id="endereco_tipo_residencia" name="endereco_tipo_residencia" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_tempo_residencia">Tempo Residência:</label>
                                    <input type="text" id="endereco_tempo_residencia" name="endereco_tempo_residencia" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_telefone">Telefone:</label>
                                    <input type="text" id="endereco_telefone" name="endereco_telefone" class="text telefone" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="endereco_tipo_telefone">Tipo Telefone:</label>
                                    <input type="text" id="endereco_tipo_telefone" name="endereco_tipo_telefone" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-8">
                                <div class="campo">
                                    <label for="endereco_correspondencia">Endereço p/ Corresp.:</label>
                                    <input type="text" id="endereco_correspondencia" name="endereco_correspondencia" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div>

                </fieldset>

                <br>

                <fieldset>

                    <legend>Dados Profissionais</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_tipo_ocupacao">Tipo de Ocupação:</label>
                                    <input type="text" id="profissional_tipo_ocupacao" name="profissional_tipo_ocupacao" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_profissao">Profissão:</label>
                                    <input type="text" id="profissional_profissao" name="profissional_profissao" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="profissional_empresa">Empresa:</label>
                                    <input type="text" id="profissional_empresa" name="profissional_empresa" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_cnpj">CNPJ:</label>
                                    <input type="text" id="profissional_cnpj" name="profissional_cnpj" class="text CNPJ" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_cargo_funcao">Cargo ou Função:</label>
                                    <input type="text" id="profissional_cargo_funcao" name="profissional_cargo_funcao" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_data_admissao">Data Admissão:</label>
                                    <input type="text" id="profissional_data_admissao" name="profissional_data_admissao" class="text data" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_telefone">Telefone:</label>
                                    <input type="text" id="profissional_telefone" name="profissional_telefone" class="text telefone" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-5">
                                <div class="campo">
                                    <label for="profissional_endereco_comercial">Endereço Comercial:</label>
                                    <input type="text" id="profissional_endereco_comercial" name="profissional_endereco_comercial" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_endereco_numero">Número:</label>
                                    <input type="text" id="profissional_endereco_numero" min="0" name="profissional_endereco_numero" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_endereco_bairro">Bairro:</label>
                                    <input type="text" id="profissional_endereco_bairro" name="profissional_endereco_bairro" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_endereco_cep">CEP:</label>
                                    <input type="text" id="profissional_endereco_cep" name="profissional_endereco_cep" class="text CEP" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_endereco_cidade">Cidade:</label>
                                    <input type="text" id="profissional_endereco_cidade" name="profissional_endereco_cidade" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_endereco_uf">UF:</label>
                                    <select id="profissional_endereco_uf" name="profissional_endereco_uf" class="text" aria-required="true">

                                        {{ $aEnumeracao['estado'] }}

                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_salario">Salário Atual (retirada):</label>
                                    <input type="text" id="profissional_salario" name="profissional_salario" class="text real" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-6">
                                <div class="campo">
                                    <label for="profissional_fonte_renda">Outras fontes de renda:</label>
                                    <input type="text" id="profissional_fonte_renda" name="profissional_fonte_renda" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_origem">Origem:</label>
                                    <input type="text" id="profissional_origem" name="profissional_origem" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="profissional_renda_bruta">Renda Bruta:</label>
                                    <input type="text" id="profissional_renda_bruta" name="profissional_renda_bruta" class="text real" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="profissional_mes_ano">Mês/Ano:</label>
                                    <input type="text" id="profissional_mes_ano" name="profissional_mes_ano" class="text ref" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div>

                </fieldset>

                <br />

                <fieldset>

                    <legend>Referências</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="referencia_pessoal_1">Pessoal:</label>
                                    <input type="text" id="referencia_pessoal_1" name="referencia_pessoal_1" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_telefone_1">Telefone:</label>
                                    <input type="text" id="referencia_telefone_1" name="referencia_telefone_1" class="text telefone" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="referencia_pessoal_2">Pessoal:</label>
                                    <input type="text" id="referencia_pessoal_2" name="referencia_pessoal_2" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_telefone_2">Telefone:</label>
                                    <input type="text" id="referencia_telefone_2" name="referencia_telefone_2" class="text telefone" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="referencia_banco_1">Banco:</label>
                                    <input type="text" id="referencia_banco_1" name="referencia_banco_1" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_agencia_1">Agência:</label>
                                    <input type="text" id="referencia_agencia_1" name="referencia_agencia_1" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_conta_corrente_1">Conta Corrente:</label>
                                    <input type="text" id="referencia_conta_corrente_1" name="referencia_conta_corrente_1" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="referencia_gerente_1">Gerente:</label>
                                    <input type="text" id="referencia_gerente_1" name="referencia_gerente_1" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_banco_telefone_1">Telefone:</label>
                                    <input type="text" id="referencia_banco_telefone_1" name="referencia_banco_telefone_1" class="text telefone" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="referencia_banco_2">Banco:</label>
                                    <input type="text" id="referencia_banco_2" name="referencia_banco_2" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_agencia_2">Agência:</label>
                                    <input type="text" id="referencia_agencia_2" name="referencia_agencia_2" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_conta_corrente_2">Conta Corrente:</label>
                                    <input type="text" id="referencia_conta_corrente_2" name="referencia_conta_corrente_2" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="referencia_gerente_2">Gerente:</label>
                                    <input type="text" id="referencia_gerente_2" name="referencia_gerente_2" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="referencia_banco_telefone_2">Telefone:</label>
                                    <input type="text" id="referencia_banco_telefone_2" name="referencia_banco_telefone_2" class="text telefone" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div>

                </fieldset>

                <br>

                <fieldset>

                    <legend>Descrição do Bem a ser Financiado</legend>

                    <div class="grid-container">

                        <div class="clearfix">

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="marca">Marca:</label>
                                    <input type="text" id="marca" name="marca" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-4">
                                <div class="campo">
                                    <label for="modelo">Modelo:</label>
                                    <input type="text" id="modelo" name="modelo" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="ano">Ano:</label>

                                    <input type="text" id="ano" name="ano" class="text" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="combustivel">Combustível:</label>
                                    <input type="text" id="combustivel" name="combustivel" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                        <div class="clearfix">

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="valor_venda">Valor de Venda R$:</label>
                                    <input type="text" id="valor_venda" name="valor_venda" class="text real" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-3">
                                <div class="campo">
                                    <label for="valor_financiado">Valor Financiado R$:</label>
                                    <input type="text" id="valor_financiado" name="valor_financiado" class="text real" aria-required="true">
                                </div>
                            </div>

                            <div class="b-md-2">
                                <div class="campo">
                                    <label for="numero_parcela">Nº de Parcelas:</label>
                                    <input type="number" id="numero_parcela" min="0" step="1" name="numero_parcela" class="text" aria-required="true">
                                </div>
                            </div>

                        </div>

                    </div>

                </fieldset>

                <br>

                @if($recaptcha)
                    <div class="g-recaptcha" data-sitekey="{{$recaptcha}}"></div>
                @endif



                <div class="botao">
                    <input type="submit" value="Enviar" class="bt">



                </div>

                @if(!empty($aMensagem))
                    <div class="alert">
                        {{$aMensagem}}
                    </div>
                @endif


            </form>

        </div>

    </div>



@endsection

@section('javascript')

    <script>


        function validarFormulario(){

            @if(!$recaptcha)
                return true;
            @endif

            var response = grecaptcha.getResponse();

            if(response.length == 0){
                alert('Preencha o captcha');
                return false;
            }

            return true;
        }

        @if(!empty($aMensagem))
            alert('{{ $aMensagem }}');
        @endif


    </script>

@endsection


