@section('tags')
    <meta property="og:description" content="{{$descricao}}"/>

    <!-- GOOGLE PLUS -->
    <meta itemprop="name" content="{{$titulo}}">
    <meta itemprop="description" content="{{$titulo}}">
    <meta itemprop="image" content="{{$imagem}}"/>
    <meta itemprop="url" content="{{$url}}"/>

    <meta name="twitter:card" content="{{$descricao}}"/>
    <meta name="twitter:site" content="{{$url}}"/>
    <!-- FACEBOOK -->
    <meta property="og:site_name" content="{{$url}}">
    <meta property="og:title" content="{{$titulo}}"/>
    <meta property="og:locale" content="pt_BR">
    <meta property="og:url" content="{{$url}}"/>
    <meta property="og:image" content="{{$imagem}}"/>
    <meta property="og:image:width" content="400">
    <meta property="og:image:height" content="300">
    <meta property="og:image:type" content="image/jpeg">
@endsection

@extends('frontend/base/section')

@section('content')


    <style>
        .botao-wpp {
            text-decoration: none;
            color: #eee;
            display: inline-block;
            background-color: #25d366;
            font-weight: bold;
            padding-top: 20px;
            padding-bottom: 20px;
            border-radius: 3px;
            width: 100%;
            text-align: center;
            font-size: 20px;
        }

        .botao-wpp:hover {
            background-color: darken(#25d366, 5%);
        }
        .botao-wpp:visited {
            background-color: darken(#25d366, 5%);
            color: #eee;
        }

        .botao-wpp:focus {
            background-color: darken(#25d366, 15%);
        }
    </style>

    <div class="centralizado veiculo-aberto" itemscope itemtype="http://schema.org/Car">

        <h2 class="pagina_titulo veiculo-aberto_nome visuallyhidden"
            itemprop="none">{{ substr($veiculo->nome,0,-9) }}</h2>

        <div class="clearfix">

            <div class="b-xs-12 b-md-8">
                @include('frontend/estoque/veiculo/fotos')
            </div>

            <div class="b-xs-12 b-md-4">
                @if($modelos=='modelo1')
                    @include('frontend/estoque/veiculo/formulario')
                @else
                    @include('frontend/estoque/veiculo/detalhes')
                @endif
            </div>

        </div>
        @if($modelos=='modelo2')
            <div class="b-xs-12">
                <hr>
            </div>
            <div class="b-xs-12 b-md-12">
                <strong style="    color: #AAAAAA;
    font-weight: bold;
    width: 30%;">Observação</strong>
                {{ nl2br($veiculo->observacao) }}
            </div>
        @endif
        <div class="b-xs-12">
            <hr>
        </div>

        <div class="clearfix">



            <div class="b-xs-12 b-md-6">
                @if($modelos=='modelo1')
                    @include('frontend/estoque/veiculo/detalhes')
                @else
                    @include('frontend/estoque/veiculo/opcionais')
                @endif

            </div>



            <div class="b-xs-12 b-md-6">
                @if($modelos=='modelo1')
                    @include('frontend/estoque/veiculo/opcionais')
                @else
                    @include('frontend/estoque/veiculo/formulario')
                @endif
            </div>



        </div>

    </div>




@endsection

@section('javascript')

    <script>


        @if($_SESSION['msg'])

        alert('{{ $_SESSION['msg'] }}');

        {{ ''; unset($_SESSION['msg']) }}

        @endif


    </script>

@endsection