@extends('backend/base/section')

@section('content')

    <form method="post">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="javascript:history.go(-1)" class="btn btn-default">Voltar</a>

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/empresa/partial/painel/cadastro')

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>

    $('form').submit( function(){

        var editor = CKEDITOR.instances['descricao'];
        var valor = editor.getData();
        var erroDescricao = $('#erro-descricao');
        var erroInput = $('#erro-input');
        var imagem = $("#imagem-exibe").attr("src");

        erroDescricao.removeClass('vermelho');
        erroDescricao.text('');
        erroInput.removeClass('vermelho');
        erroInput.text('');

        if (valor === '')
        {

            erroDescricao.addClass('vermelho');
            erroDescricao.text('Este campo é requerido.');

            swal('Atenção', 'Preencha todos os campos obrigatórios.');

            if (imagem == '' || imagem == undefined)
            {

                erroInput.addClass('vermelho');
                erroInput.text('Este campo é requerido.');

                swal('Atenção','Preencha todos os campos obrigatórios.');

            }

            return false;

        }

        return true;

    });

    function imagemClick ()
    {

        $('#file-upload').trigger('click');

    }

    function imagemClickGaleria ()
    {

        $('.file-upload-galeria').trigger('click');

    }


    function imagemExclui (prId)
    {

        swal.setDefaults( {
            confirmButtonText   : "Excluir",
            cancelButtonText    : "Cancelar"
        });

        swal({
                title: "Atenção",
                text: 'Confirma a exclusão da imagem?',
                type: "warning",
                showCancelButton: true,
                confirmButtonText: "Excluir",
                closeOnConfirm: true
            },
            function()
            {
                ajax('backend/empresa/delete-imagem', 'id='+prId, function ()
                {

                    $('#div-'+prId).remove();

                })


            });

        swal.setDefaults( {
            confirmButtonText   : "Ok",
            cancelButtonText    : "Cancelar"
        });

    }

    $('#file-upload').on('change', function ()
    {

        if($(this).val() !== '')
        {

            $('#file-upload').parent().find('input[type=button]').val('Para realizar o upload clique em salvar');

        }
        else
        {

            $('#file-upload').parent().find('input[type=button]').val('Selecionar imagem');

        }

    });

    $('.file-upload-galeria').on('change', function ()
    {

        if($(this).val() !== '')
        {

            $('.file-upload-galeria').parent().find('input[type=button]').val('Para realizar o upload clique em salvar');

        }
        else
        {

            $('.file-upload-galeria').parent().find('input[type=button]').val('Selecionar imagem');

        }

    });

    </script>

@endsection