@extends('backend/base/section')

@section('content')

    <form method="post">

        <input type="hidden" name="id" value="{{ $item->id }}">

        <div class="panel panel-white" id="acao">

            <div class="panel-body">

                <input type="submit" class="btn btn-primary" value="Salvar" />

                <a href="backend/contato-filial/index" class="btn btn-default">Voltar</a>

                @if (\Parvus\Input::get('id') != NULL)

                    <a href="javascript:void(0);" onClick="exclui('backend/contato-filial/delete?id={{ $item['id'] }}')" class="btn btn-danger pull-right">Excluir</a>

                @endif

            </div>

        </div><!-- .panel -->

        <div class="row">

            <div class="col-md-12">

                @include('backend/contato/partial/painel/nome')

            </div><!-- .col -->


            <div class="col-md-12">

                @include('backend/contato/partial/painel/exibicao')

            </div><!-- .col -->


            <div class="col-md-12">

                @include('backend/contato/partial/painel/endereco')

            </div><!-- .col -->

            <div class="col-md-6">

                @include('backend/contato/partial/painel/telefone')

            </div><!-- .col -->

            <div class="col-md-6">

                @include('backend/contato/partial/painel/horario')

            </div><!-- .col -->

        </div><!-- .row -->

    </form>

@endsection

@section('javascript')

    <script>



        function mostrarOuNaoExibicaoDaLocalizacao(){
            if($('#custom_exibicao').val()=='Sim'){

                $('.mostrar_descricao_exibicao').show('slow');

            }else{

                $('.mostrar_descricao_exibicao').hide('slow');
                $('#descricao_exibicao').empty();

            }
        };


        $(document).ready(function () {
            mostrarOuNaoExibicaoDaLocalizacao();
        })



        $('.custom_exibicao').on('change', function () {


            mostrarOuNaoExibicaoDaLocalizacao();


        });


            $('.telefone_tipo').on('change', function ()
        {

            var div = $('.telefone_'+$(this).data('ordem'));

            if($(this).val() !== '')
            {

                $(this).parent().addClass('obrigatorio');

                div.addClass('obrigatorio');

                div.find('input').removeAttr('disabled').attr('required');

                div.find('select').removeAttr('disabled').attr('required');

            }
            else
            {

                $(this).parent().removeClass('obrigatorio');

                div.removeClass('obrigatorio');

                div.find('input').removeAttr('required').attr('disabled','disabled').val('');

                div.find('select').removeAttr('required').attr('disabled','disabled').val('');

            }

        });

        $('.horario_tipo').on('change', function ()
        {

            var div = $('.horario_'+$(this).data('ordem'));

            if($(this).val() !== '')
            {

                $(this).parent().addClass('obrigatorio');

                div.addClass('obrigatorio');

                div.find('input').removeAttr('disabled').attr('required');

            }
            else
            {

                $(this).parent().removeClass('obrigatorio');

                div.removeClass('obrigatorio');

                div.find('input').removeAttr('required').attr('disabled','disabled').val('');

            }

        });

        $('.telefone_tipo').trigger('change');
        $('.horario_tipo').trigger('change');

    </script>

@endsection