<?php

    namespace Lib;

    class Paginacao
    {

        public static final function paginacao($prQuantidadePagina, $prURL = 'paginacao/index')
        {

            $totalPagina = (int) ($_SESSION["totalRegistro"] / $prQuantidadePagina);

            /**
             * Caso o resto da paginação seja diferente de 0 adiciona uma página para exibir os demais registros
             */
            if ($_SESSION["totalRegistro"] % $prQuantidadePagina != 0)
            {

                $totalPagina++;

            }

            $paginaAtual = ($_SESSION["init"] + $prQuantidadePagina) / $prQuantidadePagina;

            $html = ('<!-- INÍCIO: Paginação -->');

            $html.= ('<div class="align-center">');

                $html.= ('<div class="paginacao">');

                    if ($paginaAtual == 1)
                    {

                        $html.= ('<span class="paginacao_pagina is-active">1</span>');

                    }
                    else
                    {


                        $html.= ('<a class="paginacao_pagina" href="'.$prURL.'?init=0" title="Página 1">1</a>');

                    }

                    if ($totalPagina > 1)
                    {

                        if ($totalPagina != 2)
                        {

                            /**
                             * Efetua a paginação, colocando "paginacao_reticencias" para separar os intervalos muito grandes.
                             * Inicia o contador de reticências em 0, sendo que se estiver nas primeiras ou últimas páginas deve apenas conter uma na tela
                             * se for entre um  intervalo pode conter duas
                             */
                            $qtdReticencias = 0;

                            /**
                             * Percorre as páginas de 2 à total - 1, pois a primeira e a última sempre estão disponíveis.
                             */
                            foreach (range(2, $totalPagina - 1) as $pagina)
                            {

                                $html.= (' ');

                                /**
                                 * Se possuir mais de 7 páginas faz a paginação
                                 */
                                if ($totalPagina > 7)
                                {

                                    /**
                                     * Se a página atual for maior que 2 sempre exibe somente 2 páginas para frente.
                                     * Se for 1 ou 2 efetua a subtração para apresentar as 5 primeiras apenas.
                                     */
                                    $qtdProxima = $paginaAtual > 2 ? 2 : (5 - $paginaAtual);

                                    /**
                                     * Se a página atual somada a quantidade de páginas que devem ser exibidas for menor que o total.
                                     */
                                    if ($paginaAtual + $qtdProxima < $totalPagina)
                                    {

                                        /**
                                         * Se a paginação que será montada for maior que a página atual somada a quantidade de páginas que devem ser
                                         * exibidas
                                         */
                                        if ($pagina > $paginaAtual + $qtdProxima)
                                        {

                                            /**
                                             * Se a página atual for maior que 4 e já possuir duas reticencias apenas continua
                                             */
                                            if ($paginaAtual > 4 && $qtdReticencias == 2)
                                            {
                                                continue;
                                            }
                                            /**
                                             * Se a página atual for menor que 5 e já possuir uma reticencias continua
                                             */
                                            else if ($paginaAtual < 5 && $qtdReticencias == 1)
                                            {
                                                continue;
                                            }

                                            /**
                                             * Exibe as reticências na tela e aumenta a variável, informando que já foi apresentado e continua para a
                                             * próxima página
                                             */

                                            $html.= ('<span class="paginacao_reticencias">...</span>');

                                            $qtdReticencias++;

                                            continue;

                                        }
                                        /**
                                         * Se a paginação for menor que a página atual diminuido 2 (sempre mostrar 2 páginas quando estiver no meio da
                                         * paginação)
                                         */
                                        else if ($pagina < $paginaAtual - 2)
                                        {

                                            /**
                                             * Se já possuir uma reticências continua
                                             */
                                            if ($qtdReticencias == 1)
                                            {
                                                continue;
                                            }

                                            /**
                                             * Exibe as reticências na tela e aumenta a variável, informando que já foi apresentado e continua para a
                                             * próxima página
                                             */
                                            $html.= ('<span class="paginacao_reticencias">...</span>');

                                            $qtdReticencias++;

                                            continue;

                                        }

                                    }

                                    /**
                                     * Se a página atual somada a 2 for maior ou igual ao total de páginas
                                     */
                                    if ($paginaAtual + 2 >= $totalPagina)
                                    {

                                        /**
                                         * Se o total de páginas subtraido da paginação atual for maior que quatro
                                         */
                                        if ($totalPagina - $pagina > 4)
                                        {

                                            /**
                                             * Se a quantidade de reticências já for 1 continua
                                             */
                                            if ($qtdReticencias == 1)
                                            {
                                                continue;
                                            }

                                            /**
                                             * Exibe as reticências na tela e aumenta a variável, informando que já foi apresentado e continua para a
                                             * próxima página
                                             */
                                            $html.= ('<span class="paginacao_reticencias">...</span>');
                                            $qtdReticencias++;

                                            continue;

                                        }

                                    }

                                }

                                if ($pagina == $paginaAtual)
                                {

                                    $html.= ('<span class="paginacao_pagina is-active">'.$pagina.'</span>');

                                }
                                else
                                {

                                    $html.= ('<a class="paginacao_pagina" href="'.$prURL.'?init='.(($pagina - 1) * $prQuantidadePagina).'" title="Página '.$pagina.'">'.$pagina.'</a>');

                                }

                            }

                        }


                        $html.= ' ';

                        if ($paginaAtual != $totalPagina)
                        {

                            $html.= ('<a class="paginacao_pagina '.($_SESSION['init'] == $totalPagina * $prQuantidadePagina ? 'is-active' : '').'" href="'.$prURL.'?init='.(($totalPagina - 1) * $prQuantidadePagina).'" title="Página '.$totalPagina.'">'.$totalPagina.'</a>');

                        }
                        else
                        {

                            $html.= ('<span class="paginacao_pagina is-active">'.$totalPagina.'</span>');

                        }

                    }

                $html.= ('</div>');

            $html.= ('</div>');

            $html.= ('<!-- FIM: Paginação -->');

            return $html;
        }

    }