<?php

namespace Lib;

use Base\Decimal;

class Filtro
{
    public function buscaTextualFilter($veiculo, $termos)
    {

        //REMOVER CARACTERES ESPECIAIS
        $termos = $this->removerCaracteresEspeciais($termos);
        //SEPARAR AS PALAVRAS DO TERMO EM UM ARRAY ADICIONANDO %

        $arrTermos = explode(' ',$termos);

        foreach($arrTermos as $termo){

            $veiculo->orWhereRaw("LOWER(veiculo.nome) like ?", ['%'.$termo.'%']);

            $veiculo = $veiculo->orWhereRaw("REPLACE(LOWER(veiculo.nome), '-', '') like ?", ['%'.$termo.'%']);
        }

        return $veiculo;
    }

    public function removerCaracteresEspeciais($pesquisa)
    {
        // matriz de entrada
        $what = array('-');
        $termo = str_replace($what,' ',$pesquisa);
        return $termo;
    }

    public static final function veiculo($prModal, $filtro = array())
    {

        $veiculo = $prModal;


        /**
         * Filtro vindo da Pesquisa
         */
        if ($_SESSION['filtro']['pesquisa']) {

            $termos = $_SESSION['filtro']['pesquisa'];

            $termos = Filtro::removerCaracteresEspeciais($termos);
            //SEPARAR AS PALAVRAS DO TERMO EM UM ARRAY ADICIONANDO %

            $arrTermos = explode(' ',$termos);

            foreach($arrTermos as $termo){
                $veiculo = $veiculo->whereRaw("REPLACE(LOWER(veiculo.nome), '-', '') like ?", ['%'.$termo.'%']);
            }


            /*$veiculo = $veiculo->where('nome', 'like', '%' . $_SESSION['filtro']['pesquisa'] . '%')
                ->orWhereHas('veiculoMarca', function ($q) {
                    $q->where('nome', 'like', '%' . $_SESSION['filtro']['pesquisa'] . '%');
                })
                ->orWhereHas('veiculoMarcaModelo', function ($q) {
                    $q->where('nome', 'like', '%' . $_SESSION['filtro']['pesquisa'] . '%');
                });*/

        }
        /**
         * Filtro por Marca
         */
        if ($_SESSION['filtro']['marca']) {


            $veiculo = $veiculo->whereIn('veiculo_marca_id', array_keys($_SESSION['filtro']['marca']));

        }
        if (isset($filtro['marca'])) {
            $veiculo = $veiculo->whereIn('veiculo_marca_id', array($filtro['marca']));
        }

        /**
         * Filtro por Modelo
         */
        if ($_SESSION['filtro']['modelo']) {

            $veiculo = $veiculo->whereIn('veiculo_marca_modelo_id', array_keys($_SESSION['filtro']['modelo']));

        }
        if (isset($filtro['modelo'])) {
            $veiculo = $veiculo->whereIn('veiculo_marca_modelo_id', array($filtro['modelo']));
        }


        /**
         * Filtro por combustivel
         */
        if (isset($filtro['combustivel'])) {

            $veiculo = $veiculo->where('combustivel', 'like', '%' . $filtro['combustivel'] . '%');
        }


        /**
         * Corrige o Faixa De Ate
         */


        if (isset($filtro['faixa_de'])) {
            $veiculo->where('valor', '>=', Decimal::salva($filtro['faixa_de']));
        }


        if (isset($filtro['faixa_ate'])) {
            $veiculo->where('valor', '<=', Decimal::salva($filtro['faixa_ate']));
        }


        /**
         * Criação do ano até
         */

        if ($filtro['ano_de'] && $filtro['ano_ate']) {
            $veiculo = $veiculo->whereBetween('fabricacao', [$filtro['ano_de'], $filtro['ano_ate']]);
        }


        if (isset($filtro['outros'])) {

            if ($filtro['outros'] == 'Destaque') {
                $veiculo->where('destaque', '1');
            }

            if ($filtro['outros'] == 'Repasse') {
                $veiculo->where('repasse', '1');
            }

            if ($filtro['outros'] == 'Oferta') {
                $veiculo->where('oferta', '1');
            }

            if ($filtro['outros'] == 'Mais Recentes') {
                $veiculo->orderBy('id', 'desc');
            }


        }


        return $veiculo;

    }



}