<?php
	namespace Base;

    use Backend\ContatoFilial;

    class Enumeracao
	{

		private $aItem = array();
		private $html  = NULL;

        /**
         * @param bool $prBool ean
         * @return null|string
         */
        public final function modelosDetalhes($prId = null, $prBoolean = false)
        {


            array_push($this->aItem, array('label' => 'Modelo 1', 'id' => 'modelo1'));
            array_push($this->aItem, array('label' => 'Modelo 2', 'id' => 'modelo2'));

            return $this->html($prId);
        }

            /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function simNao($prId = null, $prBoolean = false)
        {


            array_push ($this->aItem, array('label' => 'Sim', 'id' => ($prBoolean ? '1' : 'Sim')));
            array_push ($this->aItem, array('label' => 'Não', 'id' => ($prBoolean ? '0' : 'Não')));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function tipoTelefone($prId = null)
        {

            array_push ($this->aItem, array('label' => 'WhatsApp', 'id' => 'WhatsApp'));
            array_push ($this->aItem, array('label' => 'Telefone', 'id' => 'Telefone'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function exibePlaca($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Inicío (Primeira letra e primeiro número)', 'id' => 'Início'));
            array_push ($this->aItem, array('label' => 'Final (Última letra e último número)',      'id' => 'Final'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function tipoBanner($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Largura fixa',      'id' => 'Largura fixa'));
            array_push ($this->aItem, array('label' => 'Largura variável',  'id' => 'Largura variável'));

            return $this->html($prId);

        }

        public final function tipoFormulario($prId = null){
            array_push ($this->aItem, array('label' => 'Formulário',      'id' => 'formulario'));
            array_push ($this->aItem, array('label' => 'WhatsApp',  'id' => 'whatsapp'));
            return $this->html($prId);
        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function exibeTema($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Tema 1',  'id' => 'Tema 1'));
            array_push ($this->aItem, array('label' => 'Tema 2',  'id' => 'Tema 2'));
            array_push ($this->aItem, array('label' => 'Tema 3',  'id' => 'Tema 3'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function exibeSexo($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Masculino', 'id' => 'Masculino'));
            array_push ($this->aItem, array('label' => 'Feminino',  'id' => 'Feminino'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function exibeEstadoCivil($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Solteiro', 'id' => 'Solteiro'));
            array_push ($this->aItem, array('label' => 'Casado',  'id' => 'Casado'));

            return $this->html($prId);

        }

        public final function situacaoNoticia($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Ativo',   'id' => 'Ativo'));
            array_push ($this->aItem, array('label' => 'Inativo', 'id' => 'Inativo'));

            return $this->html($prId);

        }

        public final function autenticacaoSeguranca($prId = null)
        {

            array_push ($this->aItem, array('label' => 'TLS', 'id' => 'tls'));
            array_push ($this->aItem, array('label' => 'SSL', 'id' => 'ssl'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function exibeAno($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Ano modelo', 'id' => 'Ano modelo'));
            array_push ($this->aItem, array('label' => 'Ano fabricação+Ano modelo', 'id' => 'Ano fabricação+Ano Modelo'));

            return $this->html($prId);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function cliente($prId = NULL)
        {

            foreach (\Model\Cliente::orderby('id','desc')->get() as $item)
            {

                array_push ($this->aItem, array('label' => $item->nome, 'id' => $item->id));

            }

            return $this->html($prId,NULL,true);

        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function estoqueOrdem($prId = null)
        {

            array_push ($this->aItem, array('label' => 'Maior Preço Primeiro', 'id' => 'Maior Preço Primeiro'));
            array_push ($this->aItem, array('label' => 'Menor Preço Primeiro', 'id' => 'Menor Preço Primeiro'));
            array_push ($this->aItem, array('label' => 'Ordem Alfabética dos Modelos', 'id' => 'Ordem Alfabética dos Modelos'));

            return $this->html($prId);

        }

        /**
         * @param null $prId
         * @return null|string
         */
        public final function estado ($prId = NULL)
        {

            array_push ($this->aItem, array('id' => 'AC', 'label' => 'Acre'));
            array_push ($this->aItem, array('id' => 'AL', 'label' => 'Alagoas'));
            array_push ($this->aItem, array('id' => 'AP', 'label' => 'Amapá'));
            array_push ($this->aItem, array('id' => 'AM', 'label' => 'Amazonas'));
            array_push ($this->aItem, array('id' => 'BA', 'label' => 'Bahia'));
            array_push ($this->aItem, array('id' => 'CE', 'label' => 'Ceará'));
            array_push ($this->aItem, array('id' => 'DF', 'label' => 'Distrito Federeal'));
            array_push ($this->aItem, array('id' => 'GO', 'label' => 'Goias'));
            array_push ($this->aItem, array('id' => 'ES', 'label' => 'Espírito Santo'));
            array_push ($this->aItem, array('id' => 'MA', 'label' => 'Maranhão'));
            array_push ($this->aItem, array('id' => 'MT', 'label' => 'Mato Grosso'));
            array_push ($this->aItem, array('id' => 'MS', 'label' => 'Mato Grosso do Sul'));
            array_push ($this->aItem, array('id' => 'MG', 'label' => 'Minas Gerais'));
            array_push ($this->aItem, array('id' => 'PA', 'label' => 'Pará'));
            array_push ($this->aItem, array('id' => 'PB', 'label' => 'Paraíba'));
            array_push ($this->aItem, array('id' => 'PR', 'label' => 'Paraná'));
            array_push ($this->aItem, array('id' => 'PE', 'label' => 'Pernambuco'));
            array_push ($this->aItem, array('id' => 'PI', 'label' => 'Piauí'));
            array_push ($this->aItem, array('id' => 'RJ', 'label' => 'Rio de Janeiro'));
            array_push ($this->aItem, array('id' => 'RN', 'label' => 'Rio Grande do Norte'));
            array_push ($this->aItem, array('id' => 'RS', 'label' => 'Rio Grande do Sul'));
            array_push ($this->aItem, array('id' => 'RO', 'label' => 'Rondônia'));
            array_push ($this->aItem, array('id' => 'RR', 'label' => 'Roraima'));
            array_push ($this->aItem, array('id' => 'SP', 'label' => 'São Paulo'));
            array_push ($this->aItem, array('id' => 'SC', 'label' => 'Santa Catarina'));
            array_push ($this->aItem, array('id' => 'SE', 'label' => 'Sergipe'));
            array_push ($this->aItem, array('id' => 'TO', 'label' => 'Tocantins'));

            return $this->html($prId);
        }

        /**
         * @param bool $prBoolean
         * @return null|string
         */
        public final function contatoTipo($prId = null)
        {

            $matriz = \Model\ContatoFilial::where('tipo', 'Matriz')->first();

            if($matriz->id == NULL || $prId == 'Matriz')
            {
                array_push ($this->aItem, array('label' => 'Matriz', 'id' => 'Matriz'));
            }

            array_push ($this->aItem, array('label' => 'Filial', 'id' => 'Filial'));

            return $this->html($prId);

        }

        /**
         * Monta o HTML
         * @param null $prId
         * @param null $prPadrao
         * @param bool $prMultiple
         * @param $prRetornoArray
         * @return null|string
         */
		private final function html ($prId = NULL, $prPadrao = NULL, $prMultiple = false, $prRetornoArray = false, $prSelecione = true)
		{

			if (!isset($prId) && $prPadrao != NULL)
			{

				$prId = $prPadrao;

			}

			if (!is_array($prId))
            {

                $prId = array($prId);

            }

            $this->html = NULL;

			if (!$prMultiple || $prSelecione)
            {

                $this->html .= '<option value="">-- Selecione --</option>';

            }

            foreach ($this->aItem as $ordem => $item)
            {

                if ($item['id'] == NULL)
                {

                    $this->aItem[$ordem]['id'] = $item['label'];

                }

            }

            if ($prRetornoArray)
            {

                return $this->aItem;

            }

			foreach ($this->aItem as $item)
			{

				$this->html.= '<option '.(in_array($item['id'],$prId) ? 'selected' : NULL).' value="'.$item['id'].'">'.$item['label'].'</option>';

			}

			$this->aItem = array();

			return $this->html;

		}

	}