<?php

namespace Controller;

use Lib\Lib;
use Model\Analytics;
use Model\Cliente;
use Model\ParametroGeral;
use Model\VeiculoImagem;
use Parvus\Header;
use Parvus\Input;
use Parvus\Redirect;
use PHPMailer\PHPMailer\Exception;
use Symfony\Component\HttpFoundation\Response;

class Venda extends Base
{

    public final function actionGetIndex()
    {
        unset($_SESSION['filtro']);
        $this->pagina = 'Venda seu veículo';

        $enumeracao = new \Base\Enumeracao();

        $this->view('venda/index', array(

            'aEnumeracao' => array(
                'estado' => $enumeracao->estado(),
                'sexo' => $enumeracao->exibeSexo(),
                'estadoCivil' => $enumeracao->exibeEstadoCivil(),
            )
        ));

    }


    private function reArrayFiles(&$file)
    {


        $file_ary = array();
        $file_count = count($file['name']);
        $file_key = array_keys($file);
        for ($i = 0; $i < $file_count; $i++) {
            foreach ($file_key as $val) {
                $file_ary[$i][$val] = $file[$val][$i];
            }
        }
        return $file_ary;
    }

    public final function actionPostIndex()
    {

        $aDado = $_POST['outros'];



        $arrFiles = $_FILES['file'];



        if($aDado['recaptcha']=='false'){

            $mensagem = "Captcha não preechido.";
            $status = false;
            return Header::JSON(
                [
                    'mensagem' => $mensagem,
                    'status' => $status
                ]
            );
        }



        $html = 'Proposta de financiamento enviada pelo site:<br /><br />';

        $html .= '<table width="100%" cellpadding="3" cellspacing="0" border="1">';

        $html .= '<tr>';

        $html .= '<td colspan="2" style="background-color: #c7c7c7"><b>Veículo</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Dados de contato</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['nome'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['telefone'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['email'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Marca</b></td>';

        $html .= '</tr>';


        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['marca'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Modelo</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['modelo'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td width="50%"><b>Fabricação</b></td>';
        $html .= '<td width="50%"><b>Modelo</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td>' . $aDado['ano_fabricacao'] . '</b></td>';
        $html .= '<td>' . $aDado['ano_modelo'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Cor</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['cor'] . '</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2"><b>Observação</b></td>';

        $html .= '</tr>';

        $html .= '<tr>';

        $html .= '<td colspan="2">' . $aDado['observacao'] . '</b></td>';

        $html .= '</tr>';

        $html .= '</table>';


        foreach ($arrFiles['name'] as $x => $imagem) {

            if ($imagem != NULL) {

                $aAnexo[] = [
                    'name' => $imagem,
                    'type' => $arrFiles['type'][$x],
                    'tmp_name' => $arrFiles['tmp_name'][$x],
                    'error' => $arrFiles['error'][$x],
                    'size' => $arrFiles['size'][$x],
                ];

            }

        }

        try {
            $email = \Lib\Email::envia(
                $html,
                'Compra/Venda de veículos',
                Cliente::where('id', $this->clienteId)->first(),
                'contato',
                $aAnexo
            );

            $status = true;
            $mensagem = "Mensagem enviada com sucesso, em breve entraremos em contato.";

        } catch (Exception $e) {
            $status = false;
            $mensagem = $e->getMessage();
        }


        return Header::JSON(
            [
                'mensagem' => $mensagem,
                'status' => $status
            ]
        );

    }


}
