<?php

namespace Controller;

use Backend\Versao;
use Model\ParametroGeral;
use Parvus\DB;
use Parvus\Input;

class Update
{

    /**
     *
     */
    public final function actionGetIndex()
    {
        try {


            $versao = Input::get('versao');
            $is_unifique = Input::get('unifique');


            if (empty($is_unifique)) {
                $is_unifique = false;
            } else {
                $is_unifique = true;
            }

            if (empty($versao)) {
                die('nenhuma versao selecionada');
            }

            echo "Versao selecionada " . $versao . "<br/>";


            $model = ParametroGeral::where('id', 1)->first();


            $arrDadosVersao['data'] = date('Y-m-d');
            $arrDadosVersao['texto'] = '<ul><li>Versão: ' . $versao . '</li></ul>';


            $mod_versao = new \Model\Versao();
            $mod_versao->saveArray($arrDadosVersao);


            $arquivo = $versao . '.zip';


            $this->realizarAAtualizacaoDosArquivos($arquivo, $model, $is_unifique);
            $this->atualizaBancoDeDados();


            $arrSave['id'] = $model->id;
            $arrSave['versao'] = $versao;
            $model->saveArray($arrSave);


        } catch (\Exception $e) {
            echo $e->getCode();
            echo " Ocorreu um erro:" . $e->getMessage();
            die;
        }



        die('Processamento realizado');

    }

    private function atualizaBancoDeDados()
    {

        /** Verifica se tem o arquivo SQL de update */
        $caminho = getcwd();
        $caminho = str_replace('public_html', '_html', getcwd());
        $arquivo = str_replace('public', 'SQL/Update.sql', $caminho); //MUDA DE WINDOWS PARA LINUX
        $arquivo = str_replace('_html', 'public_html', $arquivo);

        try {
            if (file_exists($arquivo)) {

                /** Executa cada comando para atualizar o banco */
                foreach (explode('#TABLE#', file_get_contents($arquivo)) as $sql) {

                    try {

                        if (empty($sql)) {
                            continue;
                        }
                        DB::statement($sql);
                        print_r($sql);
                        echo "<hr/>";

                    } catch (\Exception $e) {
                        echo $e->getMessage();
                        echo "<hr/>";
                        continue;
                    }

                }
                unlink($arquivo);
            } else {
                throw new \Exception('Nenhum arquivo para atualização de banco de dados ' . $arquivo);
            }
        } catch (\Exception $e) {
            throw $e;
        }


    }

    private function realizarAAtualizacaoDosArquivos($arquivo, $model, $is_unifique)
    {

        try {
            /**
             * Monta diretorio dos arquivo local e remoto
             */
            $aArquivo = [
                'local' => getcwd() . '/' . $arquivo,
                'remote' => '/public_html/versao/' . $arquivo
            ];

            print_r("Baixando ZIP <br/>");
            /** Coneca com o FTP e faz o download do arquivo */
            $ftp = ftp_connect('ftp.manutencaosites.windi.com.br') or die('Não foi possivel fazer conexão');
            ftp_login($ftp, 'manutencaosites', 'Sc!6CBHANZ[t') or die('Não foi possivel fazer login');
            ftp_get($ftp, $aArquivo['local'], $aArquivo['remote'], FTP_BINARY) or die('Não foi possivel fazer o download');
            ftp_close($ftp);

            $arquivo_img_antigo = 'assets/frontend/tema_' . substr($model->tema, -1, 1) . '/imagens/topo_bg.jpg';
            $arquivo_img_novo = 'assets/frontend/tema_' . substr($model->tema, -1, 1) . '/imagens/topo_bg_novo.jpg';

            print_r("ZIP baixado <br/>");

            if (file_exists($arquivo_img_antigo)) {

                copy($arquivo_img_antigo, $arquivo_img_novo);

                print_r("Copiar ZIP ANTIGO");
            }

            if (!file_exists($aArquivo['local'])) {
                throw new \Exception('O arquivo não foi baixado');
            }


            print_r("Descompatar ZIP <br/><br/>");

            $arquivo = str_replace('public', '', getcwd());
            $arquivo = str_replace('_html', 'public_html', $arquivo);

            //Tentativa 1
            if ($is_unifique) {

                system("unzip " . $aArquivo['local'] . ' -d ' . $arquivo);
                print_r('Atualizou os códigos fonte <br/>');

            } else {
                //Tentativa 2
                /** Faz a descompactação do arquivo */
                $zip = new \ZipArchive();
                $zip->open($aArquivo['local']);
                if ($zip->extractTo($arquivo) == true) {
                    print_r('Atualizou os códigos fonte .<br/>');
                } else {
                    throw new \Exception('Erro ao abrir o arquivo zip e fazer o processamento.');
                }
            }

            print_r("ZIP extraido<br/>");
            /** Deleta o ZIP */
            print_r('Excluir ZIP ' . $aArquivo['local'] . '<br/>');
            unlink($aArquivo['local']);
        } catch (\Exception $e) {
            throw $e;
        }


    }

}