<?php
	namespace Controller;

    use Lib\Date;
    use Model\Noticia;
    use Parvus\DB;
    use Parvus\Input;
    use Parvus\Redirect;

    class Noticias extends Base
	{

		public final function actionGetIndex()
		{
            unset($_SESSION['filtro']);
		    $this->pagina = 'Notícias';

            $noticia = Noticia::where('cliente_id', $this->clienteId)
                ->where('situacao', 'Ativo')
                ->groupBy(DB::raw('date_format(data, "%Y-%m")'))
                ->orderby(DB::raw('date_format(data, "%Y-%m")'), 'desc');

            foreach ($noticia->get([DB::raw('distinct(date_format(data, "%Y-%m")) as data'),  DB::raw('count(1) as total')]) as $item)
            {

                $aFiltro[$item->data] = Date::mesExtenso(Date::date($item->data, 'm')).'/'.Date::date($item->data, 'Y').' ('.$item->total.')';

            }


            if($_SESSION['filtro']['data'] == NULL)
            {

                $_SESSION['filtro']['data'] = date('Y-m');

                $aData['inicial'] = date('Y-m-01');
                $aData['final']   = date('Y-m-t');

                if($aFiltro[date('Y-m')] == NULL)
                {

                    $aData['inicial'] = Date::sub(date('Y-m-01'),1,'m');
                    $aData['final']   = Date::sub(date('Y-m-t'),1,'m');

                    $_SESSION['filtro']['data'] = Date::date(Date::sub(date('Y-m'),1,'m'), 'Y-m');

                }

            }
            else
            {
                
                $aData['inicial'] = $_SESSION['filtro']['data'].'-01';
                $aData['final']   = $_SESSION['filtro']['data'].'-'.Date::date($_SESSION['filtro']['data'], 't');

            }

            $noticia = Noticia::where('cliente_id', $this->clienteId)
                ->where('situacao', 'Ativo')
                ->whereBetween('data', [$aData['inicial'], $aData['final']])
                ->orderBy('data','desc')
                ->select([
                    DB::raw('SQL_CALC_FOUND_ROWS * ')
                ])
                ->limit(6)
                ->offset($_SESSION['init'] ? $_SESSION['init'] : 0)
                ->get();

            $_SESSION['totalRegistro'] = DB::select('SELECT FOUND_ROWS() as quantidade')[0]['quantidade'];

		    $this->view('noticia/index', [
		        'aFiltro' => $aFiltro,
                'noticia' => $noticia,
                'ativo'   => $_SESSION['filtro']['data']
            ]);

		}

		public final function actionGetNoticia()
        {

            $this->pagina = 'Notícias';

            $noticia = Noticia::where('cliente_id', $this->clienteId)
                ->where('alias', Input::get('alias'))
                ->first();

            $this->sub_pagina = $noticia->chamada;

            $this->view('noticia/aberta', [
                'noticia' => $noticia,
                    'temBreadcrumb' => '0'
            ]);

        }

		public final function actionGetFiltro()
        {

            $_SESSION['filtro']['data']  = Input::get('mes');

            Redirect::to('noticias');

        }


	}