<?php

    namespace Controller;

    use Model\Cliente;
    use Model\Pagina;
    use Model\PaginaCliente;
    use Model\ParametroGeral;
    use Model\Usuario;
    use Parvus\Date;
    use Parvus\DB;
    use Parvus\Input;
    use Parvus\Redirect;

    class Install
    {

        public final function actionGetIndex ()
        {

            /**
             * Formulario de instalação
             */
            $view = new \Parvus\View();

            $html = $view->render('frontend/install/form', [
                'url' => str_replace('install/', '',"http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]/")
            ]);

            exit($html);

        }

        public final function actionPostIndex ()
        {

            /** Salva o Post na seção, necessario pois como configura o banco de dados, precisamos recarregar a pagina para entrar em vigor o banco*/
            $_SESSION['INSTALADOR'] = $_POST;

            /** Layout do arquivo de banco */
            $arquivo_database[] = '<?php';

            $arquivo_database[] = 'return array (';

                $arquivo_database[] = '\'driver\' => \'mysql\',';

                $arquivo_database[] = '\'default\' => array (';
                    $arquivo_database[] = '\'prefix\'    => \'\',';
                    $arquivo_database[] = '\'host\'      => \'localhost\',';
                    $arquivo_database[] = '\'charset\'   => \'utf8\',';
                    $arquivo_database[] = '\'collation\' => \'utf8_unicode_ci\'';
                $arquivo_database[] = '),';

                $arquivo_database[] = '\'local\' => array (';
                    $arquivo_database[] = '\'mysql\' => array (';
                        $arquivo_database[] = '\'database\'  => \''.Input::get('banco_dados').'\',';
                        $arquivo_database[] = '\'username\'  => \''.Input::get('banco_dados_usuario').'\',';
                        $arquivo_database[] = '\'password\'  => \''.Input::get('banco_dados_senha').'\'';
                    $arquivo_database[] = ')';
                $arquivo_database[] = '),';

                $arquivo_database[] = '\'production\' => array (';
                    $arquivo_database[] = '\'mysql\' => array (';
                        $arquivo_database[] = '\'database\'  => \''.Input::get('banco_dados').'\',';
                        $arquivo_database[] = '\'username\'  => \''.Input::get('banco_dados_usuario').'\',';
                        $arquivo_database[] = '\'password\'  => \''.Input::get('banco_dados_senha').'\'';
                    $arquivo_database[] = ')';
                $arquivo_database[] = ')';

            $arquivo_database[] = ');';

            /** Cria o arquivo de banco de dados */
            $fileName = str_replace('public', '',getcwd()).'app/config/Database.php';
            $fileName = str_replace('_html', 'public_html', $fileName);

            $fp = fopen($fileName, 'w+') or die ('Não conseguiu criar o arquivo de configuração do banco de dados');
            fwrite($fp, implode(chr(10).chr(13), $arquivo_database));

            fclose($fp);

            chmod($fileName, 0777);

            /** FIM */

            Redirect::to('install/db');

        }

        public final function actionGetDB()
        {

            /** Instação do banco de dados */

            /** Faz a criação das tabelas, OBS: Arquivo não pode ter comentarios, cada comando deve ser separador por #TABLE# */
            $fileBD = str_replace('public', '',getcwd()).'SQL/Install.sql';
            $fileBD = str_replace('_html', 'public_html', $fileBD);

            foreach (explode('#TABLE#', file_get_contents($fileBD)) as $sql)
            {
                if(empty($sql)){
                    continue;
                }
                DB::statement($sql);

            }

            /** Instalação do cliente */
            $model = Cliente::firstOrNew(['id' => 1]);

            $model->saveArray([
                'codigo' => $_SESSION['INSTALADOR']['cliente_codigo'],
                'url' => $_SESSION['INSTALADOR']['url'],
                'nome'   => $_SESSION['INSTALADOR']['cliente_nome'],
                'CNPJ'   => $_SESSION['INSTALADOR']['cliente_CNPJ'],
                'log_cadastro_data' => Date::now()
            ]);

            /** Personalização do cliente (Tema)*/
            if(ParametroGeral::where('id', 1)->first()->id == null)
            {

                $model = ParametroGeral::insert([
                    'cliente_id' => 1,
                    'tema'       => $_SESSION['INSTALADOR']['parametro_geral_tema']
                ]);

            }

            /** Cria paginas */
            $aPagina = [
                "1"	=> "Empresa",
                "2"	=> "Estoque",
                "3"	=> "Fotos",
                "4"	=> "Notícias",
                "5"	=> "Ficha Cadastral",
                "6"	=> "Contato"
            ];

            foreach ($aPagina as $id => $pagina)
            {

                $model = Pagina::firstOrNew(['id' => $id]);

                $model->saveArray([
                    'id'   => $id,
                    'nome' => $pagina
                ]);

                /** Define que o cliente tem todas as paginas */
                if(PaginaCliente::where('id', $id)->first()->id == null)
                {

                    PaginaCliente::insert([
                        'pagina_id'               => $id,
                        'cliente_id'              => 1,
                        'exibe'                   => 'Sim',
                        'log_cadastro_usuario_id' => 1
                    ]);

                }

            }

            /** Cria usuário da windi */
            Usuario::insert([
                'cliente_id'              => '1',
                'email'                   => 'admin@windi.com.br',
                'senha'                   => 'ee6feb72dfaa67d691e51bade60092ef',
                'nome'                    => 'Windi',
                'tipo'                    => 'Administrador',
                'log_cadastro_data'       => Date::now(),
                'log_cadastro_usuario_id' => '1'
            ]);

            /** Cria usuário do cliente */
            Usuario::insert([
                'cliente_id'              => '1',
                'email'                   => $_SESSION['INSTALADOR']['usuario_email'],
                'senha'                   => md5(senhaPrefixo.$_SESSION['INSTALADOR']['usuario_senha']),
                'nome'                    => $_SESSION['INSTALADOR']['cliente_nome'],
                'tipo'                    => 'Administrador',
                'log_cadastro_data'       => Date::now(),
                'log_cadastro_usuario_id' => '1'
            ]);
            /** FIM */

            Redirect::to('install/exclui');

        }

        public final function actionGetExclui()
        {

            /** Exclui o arquivo da instalação para evitar problemas */
            if (environment != 'local')
            {

                $file = str_replace('public', '',getcwd()).'app/controller/Install.php';
                $file = str_replace('_html', 'public_html', $file);
                unlink($file);

            }

            Redirect::to('/');

        }

    }