<?php

namespace Controller;

use Model\Cliente;
use Model\ParametroGeral;
use Parvus\DB;
use Parvus\Input;
use Parvus\Redirect;

class Contato extends Base
{

    public final function actionGetIndex()
    {

        $this->pagina = 'Contato';
        $filial = \Model\ContatoFilial::orderBy(DB::raw('FIELD(tipo, "Matriz", "Filial")'))->get();



        $this->view('contato/index', [
            'filial' => $filial
        ]);

    }

    public final function actionPostIndex()
    {

        $existeRecaptcha = (isset($_POST['g-recaptcha-response']));


        if ($existeRecaptcha) {
            $dados = Input::get('g-recaptcha-response');
            if (empty($dados)) {
                $_SESSION['msg_error'] = 'Captcha não preenchido';
                $arrForm['contato_nome'] = Input::get('contato_nome');
                $arrForm['contato_email'] = Input::get('contato_email');
                $arrForm['contato_telefone'] = Input::get('contato_telefone');
                $arrForm['contato_assunto'] = Input::get('contato_assunto');
                $arrForm['contato_mensagem'] = Input::get('contato_mensagem');
                $_SESSION['form'] = $arrForm;


                Redirect::back();
            }
        }

        $html = 'Contato realizado pelo site:<br /><br />';

        $html .= "<b>Nome: </b>" . Input::get('contato_nome') . "<br />";
        $html .= "<b>E-mail: </b>" . Input::get('contato_email') . "<br />";
        $html .= "<b>Telefone: </b>" . (Input::get('contato_telefone') ? \Lib\Mascara::telefone(Input::get('contato_telefone')) : 'Não informado') . "<br />";
        $html .= "<b>Mensagem: <br /></b>" . nl2br(Input::get('contato_mensagem')) . "<br />";


        $email = \Lib\Email::envia($html, 'Contato - ' . Input::get('contato_assunto'), Cliente::where('id', $this->clienteId)->first(), 'contato');

        $_SESSION['msg'] = 'Contato enviado com sucesso!';
        unset($_SESSION['form']);
        unset($_SESSION['msg_error']);

        Redirect::back();

    }

}