<?php
    namespace Backend;

    use Parvus\Date;
    use Parvus\Input;
    use Parvus\Redirect;

    class Versao extends Base
    {

        protected $title = 'Histórico de versões';

        /**
         * Remove
         */
        public final function actionGetDelete ()
        {

            $versaoModel = new \Model\Versao();
            $versaoModel->delete(Input::get('id'));

            \Base\Mensagem::sucesso('Versão excluída com sucesso!');

            Redirect::to('backend/versao/index');

        }

        /**
         * Persistência
         */
        public final function actionPostForm ()
        {

            $id = Input::get('id');

            if (is_numeric($id))
            {
                $versaoModel = \Model\Versao::where('id',$id)->first();
            }
            else
            {
                $versaoModel = new \Model\Versao();
            }

            $versaoModel->saveArray(array (
                'texto' => Input::get('texto'),
                'data'  => Date::save(Input::get('data'))
            ));

            \Base\Mensagem::sucesso('Versão salva com sucesso!');

            Redirect::to('backend/versao/index');

        }

        /**
         * Formulário
         */
        public final function actionGetForm ()
        {

            $this->titulo = 'Versão';

            $id = Input::get('id');

            if (is_numeric($id))
            {
                $aItem = \Model\Versao::where('id',$id)->first();

                $this->subtitle = $aItem->nome;
            }
            else
            {
                $aItem = new \stdClass();
            }

            $this->view('versao/form', array (
                'item' => $aItem
            ));

        }

        /**
         * Index
         */
        public final function actionGetIndex ()
        {

            $this->titulo = 'Versão';

            $this->view('versao/index', array (
                'aModel' => \Model\Versao::orderby('data','desc')->get()
            ));

        }

    }