<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class RodapeFixo extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Rodapé Fixo';

            $item = \Model\RodapeFixo::where('id', 1)->first();


            $enumeracao = new Enumeracao();

            $this->view('configuracao/rodapeFixo/form', array(
                'item'        => $item,
                'aEnumeracao' => array(
                    'telefone_tipo_1' => $enumeracao->tipoTelefone($item->telefone_tipo_1),
                    'telefone_tipo_2' => $enumeracao->tipoTelefone($item->telefone_tipo_2),
                    'telefone_tipo_3' => $enumeracao->tipoTelefone($item->telefone_tipo_3),
                    'telefone_tipo_4' => $enumeracao->tipoTelefone($item->telefone_tipo_4),
                    'exibe'    => $enumeracao->simNao($item->exibe),
                )
            ));

        }

        public final function actionPostForm()
        {

            $model = \Model\RodapeFixo::where('id', Input::get('id'))
                ->first();


            if($model->id == null)
            {

                $model = new \Model\RodapeFixo();

            }

            $model->saveArray([
                'exibe'             => Input::get('exibe'),
                'frase_principal'   => Input::get('frase_principal'),
                'frase_whatsapp'   => Input::get('frase_whatsapp'),
                'frase_secundaria'  => Input::get('frase_secundaria'),
                'telefone_tipo_1'   => Input::get('telefone_tipo_1'),
                'telefone_numero_1' => Input::get('telefone_numero_1'),
                'telefone_frase_1'  => Input::get('telefone_frase_1'),
                'telefone_tipo_2'   => Input::get('telefone_tipo_2'),
                'telefone_numero_2' => Input::get('telefone_numero_2'),
                'telefone_frase_2'  => Input::get('telefone_frase_2'),
                'telefone_tipo_3'   => Input::get('telefone_tipo_3'),
                'telefone_numero_3' => Input::get('telefone_numero_3'),
                'telefone_frase_3'  => Input::get('telefone_frase_3'),
                'telefone_tipo_4'   => Input::get('telefone_tipo_4'),
                'telefone_numero_4' => Input::get('telefone_numero_4'),
                'telefone_frase_4'  => Input::get('telefone_frase_4'),
            ]);

            Mensagem::sucesso('Rodapé fixo alterados com sucesso!');
            Redirect::back();

        }

    }