<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\Table;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Rodape extends Base
    {

        public final function actionGetIndex ()
        {

            $this->titulo = 'Rodapé';

            $table = new Table();

            $table->th('Telefone');
            $table->th('E-mail');
            $table->acao();

            foreach (\Model\Rodape::get() as $item)
            {

                $table->td(array(
                    $item->telefone,
                    $item->email,
                    $table->button('Editar','backend/rodape/form?id='.$item->id)
                ));

            }

            $this->view('rodape/index', array(
                'table' => $table->html(),
            ));

        }

        public final function actionGetForm()
        {

            $this->titulo = 'Rodapé';

            $item = \Model\Rodape::where('id', Input::get('id'))->first();

            $enumeracao = new Enumeracao();

            $this->view('rodape/form', array(
                'item'        => $item,
                'aEnumeracao'   => array(
                    'estado' => $enumeracao->estado($item->endereco_uf)
                )
            ));

        }

        public final function actionPostForm()
        {

            $model = \Model\Rodape::where('id', Input::get('id'))->first();

            if ($model->id == NULL){

                $model = new \Model\Rodape();

            }

            $model->saveArray([
                'telefone' => Input::get('telefone'),
                'email'    => Input::get('email'),
                'endereco_rua'      => Input::get('endereco_rua'),
                'endereco_numero'   => Input::get('endereco_numero'),
                'endereco_cidade'   => Input::get('endereco_cidade'),
                'endereco_uf'       => Input::get('endereco_uf'),
                'endereco_cep'      => Input::get('endereco_cep'),
                'endereco_complemento' => Input::get('endereco_complemento'),
                'endereco_bairro'      => Input::get('endereco_bairro'),
            ]);

            Mensagem::sucesso('Rodapé alterados com sucesso!');
            Redirect::to('backend/rodape/index');

        }

        public final function actionGetDelete ()
        {

            $model = new \Model\Rodape();
            $model->delete(Input::get('id'));

            Mensagem::sucesso('Rodapé excluída com sucesso!');

            Redirect::to('backend/rodape/index');

        }

    }