<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\W2O;
use Parvus\Input;
use Parvus\Redirect;

class ParametroGeral extends Base
{

    public final function actionGetForm()
    {

        $this->titulo = 'Parâmetros Gerais';

        $item = \Model\ParametroGeral::where('cliente_id', '=', $this->usuario->cliente_id)->first();

        $enumeracao = new Enumeracao();

        $this->view('configuracao/parametroGeral/form', array(
            'item' => $item,
            'tema' => $item->tema,
            'aEnumeracao' => array(
                'modelos'=>$enumeracao->modelosDetalhes($item->modelos),
                'exibir_cores'=>$enumeracao->simNao($item->exibir_cores),
                'tipo_formulario'=>$enumeracao->tipoFormulario($item->tipo_formulario),
                'tipo_banner' => $enumeracao->tipoBanner($item->tipo_banner),
                'filtro_exibe_marca' => $enumeracao->simNao($item->filtro_exibe_marca),
                'filtro_exibe_ano' => $enumeracao->simNao($item->filtro_exibe_ano),
                'exibe_' => $enumeracao->simNao($item->filtro_exibe_ano),
                'exibe_todo_opcional' => $enumeracao->simNao($item->exibe_todo_opcional),
                'importa_noticia_blog' => $enumeracao->simNao($item->importa_noticia_blog),
                'exibe_placa' => $enumeracao->exibePlaca($item->exibe_placa),
                'exibe_ano' => $enumeracao->exibeAno($item->exibe_ano),
                'ordem' => $enumeracao->estoqueOrdem($item->ordem),
                'exibe_estoque_home' => $enumeracao->simNao($item->exibe_estoque_home),
                'tem_fundo_preco_estoque' => $enumeracao->simNao($item->tem_fundo_preco_estoque),
                'compartilhar_veiculo' => $enumeracao->simNao($item->compartilhar_veiculo),
                'exibe_localizacao'=>$enumeracao->simNao($item->exibe_localizacao),
                'menu_fixo' => $enumeracao->simNao($item->menu_fixo),
                'exibe_localizacao' => $enumeracao->simNao($item->exibe_localizacao),
            )
        ));

    }

    public final function actionPostForm()
    {

        $model = \Model\ParametroGeral::where('id', Input::get('id'))
            ->where('cliente_id', $this->usuario->cliente_id)
            ->first();


        $menu_fixo = Input::get('menu_fixo');


        if (empty($menu_fixo)) {
            $menu_fixo = 'Não';
        }


        $model->saveArray([
            'modelos'=>Input::get('modelos'),
            'exibir_cores'=>Input::get('exibir_cores'),
            'numero_whatsapp'=>Input::get('numero_whatsapp'),
            'tipo_formulario'=>Input::get('tipo_formulario'),
            'tipo_banner' => Input::get('tipo_banner'),
            'filtro_exibe_marca' => Input::get('filtro_exibe_marca'),
            'filtro_exibe_ano' => Input::get('filtro_exibe_ano'),
            'filtro_exibe_mais_recente_dia' => Input::get('filtro_exibe_mais_recente_dia'),
            'filtro_exibe_quantidade_veiculo' => Input::get('filtro_exibe_quantidade_veiculo'),
            'exibe_auto_load_estoque' => Input::get('exibe_auto_load_estoque'),
            'exibe_todo_opcional' => Input::get('exibe_todo_opcional'),
            'exibe_placa_mascara' => Input::get('exibe_placa_mascara'),
            'exibe_ano' => Input::get('exibe_ano'),
            'ordem' => Input::get('ordem'),
            'importa_noticia_blog' => Input::get('importa_noticia_blog'),
            'exibe_estoque_home' => Input::get('exibe_estoque_home'),
            'quantidade_veiculo_home' => Input::get('quantidade_veiculo_home'),
            'tem_fundo_preco_estoque' => Input::get('tem_fundo_preco_estoque'),
            'compartilhar_veiculo' => Input::get('compartilhar_veiculo'),
            'link_facebook' => Input::get('link_facebook'),
            'exibe_localizacao' =>  Input::get('exibe_localizacao'),
            'menu_fixo' => $menu_fixo,
            'recaptcha' => Input::get('recaptcha'),
            
        ]);

        if (Input::file('imagem')) {

            if (Input::file('imagem')['dimension']['width'] < '1920' || Input::file('imagem')['dimension']['height'] < '208') {

                Mensagem::erro('Imagem com tamanho de 1920px largura por 208 altura.');

                Redirect::back();

            }

            if (Input::file('imagem')['size']['megabyte'] <= 2) {

                move_uploaded_file(Input::file('imagem')['tmp_name'], 'assets/frontend/tema_' . substr($model->tema, -1, 1) . '/imagens/topo_bg_novo.jpg');

            } else {

                Mensagem::sucesso('O tamanho do arquivo deve ser de até 2 MB');

                Redirect::back();

            }


        }

        Mensagem::sucesso('Parâmetros gerais alterados com sucesso!');
        Redirect::back();

    }

}