<?php
    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Model\PaginaCliente;

    use Parvus\Date;
    use Parvus\Input;
    use Parvus\Redirect;

    class Pagina extends Base

    {

        public final function actionGetForm()
        {

            $this->titulo = 'Páginas';

            $enumeracao = new Enumeracao();

            foreach (\Model\Pagina::get() as $item)
            {

                $model = PaginaCliente::where('pagina_id', $item->id)
                    ->where('cliente_id', $this->usuario->cliente_id)
                    ->first();

                $aItem[] = array(
                    'id'         => $item->id,
                    'nome'       => $model->nome ? $model->nome : $item->nome,
                    'enumeracao' => $enumeracao->simNao(($model->exibe == 'Sim' ? 'Sim' : 'Não'))
                );

            }


            $configuracao_geral = \Model\ParametroGeral::where('cliente_id', $this->usuario->cliente_id)->first();




            $this->view('configuracao/pagina/form', array(
                'aItem'  => $aItem,
                'aPaginaHome'=>$configuracao_geral['nome_pagina_home']
            ));

        }

        public final function actionPostForm()
        {

            PaginaCliente::where('cliente_id', $this->usuario->cliente_id)->delete();


            $configuracao_geral = \Model\ParametroGeral::where('cliente_id', $this->usuario->cliente_id)->first();
            $configuracao_geral->nome_pagina_home = Input::get('aPaginaHome');
            $configuracao_geral->save();



            foreach (Input::get('aPagina') as $id => $opcao)
            {

                $model = new PaginaCliente();

                $model->saveArray([
                    'pagina_id'               => $id,
                    'cliente_id'              => $this->usuario->cliente_id,
                    'exibe'                   => $opcao,
                    'nome'                    => Input::get('aPaginaNome')[$id],
                    'log_cadastro_data'       => Date::now(),
                    'log_cadastro_usuario_id' => $this->usuario->id
                ]);

            }

            Mensagem::sucesso('Páginas alteradas com sucesso!');

            Redirect::back();

        }

    }