<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\Table;
    use Parvus\Date;
    use Parvus\Input;
    use Parvus\Redirect;

    class Noticia extends Base
    {

        public final function actionGetIndex ()
        {

            $this->titulo = 'Notícias';

            $table = new Table();

            $table->th('Chamada');
            $table->th('Situacao');
            $table->th('Data','',TABLE_ALIGN_CENTER);
            $table->acao();

            foreach (\Model\Noticia::where('cliente_id', $this->usuario->cliente_id)->get() as $item)
            {

                $table->td(array(
                    $item->chamada,
                    $item->situacao,
                    Date::date($item->data,'d/m/Y'),
                    $table->button('Editar','backend/noticia/form?id='.$item->id)
                ));

            }

            $this->view('noticia/index', array(
               'table' => $table->html(),
            ));

        }

        public final function actionPostForm ()
        {

            $model = \Model\Noticia::where('id',Input::get('id'))->first();


            /**
             * Passa os valores para o array
             */


            $aItem = array(
                'cliente_id' => $this->usuario->cliente_id,
                'tipo'       => Input::get('tipo'),
                'situacao'   => Input::get('situacao'),
                'data'       => Input::get('data'),
                'alias'      => Input::get('chamada'),
                'imagem'     => Input::file('imagem')['name'],
                'chamada'    => Input::get('chamada'),
                'integra'    => Input::get('integra'),
            );

            if ($aItem['situacao'] == '')
            {

                $aItem['situacao'] = 'Ativo';

            }

            $aItem['alias'] = $this->alias($aItem['alias']);

            /**
             * Se não estiver cadastrada, insere uma nova
             */

            if ($model->id == NULL){

                $model = new \Model\Noticia();

            }

            /**
             * Se não foi inserida uma imagem, pega a que já está cadastrada
             */
            if($aItem['imagem'] == NULL)
            {

                $aItem['imagem'] = $model->imagem;

            }

            $model->saveArray([
                'cliente_id'  => $aItem['cliente_id'],
                'tipo'        => 'Manual',
                'situacao'    => $aItem['situacao'],
                'data'        => Date::now(),
                'alias'       => $aItem['alias'],
                'imagem'      => $aItem['imagem'],
                'chamada'     => $aItem['chamada'],
                'integra'     => $aItem['integra'],
            ]);

            if(Input::file('imagem'))
            {


                $imagem = new \Lib\Imagem(Input::file('imagem'), '', 'arquivo/'.$this->usuario->cliente_id.'/noticia/'.$model->id);

                $imagem->criaPasta('arquivo/'.$this->usuario->cliente_id.'/noticia/');

                $aItem['imagem'] = $imagem->thumbnail();

                $model->saveArray([
                    'imagem' => $aItem['imagem']
                ]);

            }

            Mensagem::sucesso('Notícia inserida com sucesso!');

            Redirect::to('backend/noticia/index');

        }

        public final function actionGetForm ()
        {

            $model = \Model\Noticia::where('id',Input::get('id'))->first();

            $aItem = array(
                'id'          => $model->id,
                'cliente_id'  => $this->usuario->cliente_id,
                'tipo'        => $model->tipo,
                'situacao'    => $model->situacao,
                'data'        => $model->data,
                'alias'       => $model->alias,
                'imagem'      => $model->imagem,
                'chamada'     => $model->chamada,
                'integra'     => $model->integra
            );

            $enumeracao = new Enumeracao();

            $this->view('noticia/form', array(
                'aEnumeracao' => array(
                           'situacao' => $enumeracao->situacaoNoticia($model->situacao ? $model->situacao : 'Ativo'),
                ),
                'item' => $aItem
            ));

        }

        public final function alias($prNome)
        {

            $alias = $prNome;

            $alias = preg_replace("/&([a-z])[a-z]+;/i", "$1", htmlentities(trim(strtolower($alias))));

            $alias = str_replace(array('/','.', '-',',',':', '?', '!','&','$', '#','@','%','*'),' ',$alias);

            $alias = str_replace(' ', '-', $alias);

            $alias = preg_replace('/--+/', '-', $alias);

            return $alias;

        }

    }