<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Lib\Imagem;
    use Parvus\Input;
    use Parvus\Redirect;

    class Modal extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Modal';

            $item = \Model\Modal::where('id','1')->first();

            $enumeracao = new Enumeracao();

            $this->view('modal/form',array(
                'item'   => $item,
                'select' => $enumeracao->simNao($item->exibe)
            ));

        }

        public final function actionPostForm()
        {


            if(Input::file('imagem') != null)
            {

                if(Input::file('imagem')['size']['megabyte'] > '2')
                {

                    Mensagem::erro('O tamanho do arquivo deve ser de até 2 MB');

                    Redirect::back();
                    exit;

                }

                if(Input::file('imagem')['dimension']['width'] < 700 || Input::file('imagem')['dimension']['height'] < 450)
                {

                    Mensagem::erro('Imagem com proporção mínima de 700px largura por 450px altura');

                    Redirect::back();

                }

                $imagem = base64_encode(file_get_contents(Input::file('imagem')['tmp_name']));

                $icone = new \Lib\Imagem(Input::file('imagem'), '', 'arquivo/1/modal/', array('altura' => 450, 'largura' => 700));

                $imagem = $icone->resize();
            }

            $model = \Model\Modal::where('id', '1')->first();

            if(!$model)
            {

                $model = new \Model\Modal();

            }

            $model->saveArray([
                'id'     => '1',
                'exibe'  => Input::get('exibe'),
                'imagem' => $imagem
            ]);

            Mensagem::sucesso('Modal alterada com sucesso!');

            Redirect::back();

        }

    }