<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\Table;
use Parvus\Date;
use Parvus\Input;
use Parvus\Redirect;

class Google extends Base
{
    public final function actionGetForm ()
    {


        $this->titulo = 'Google 360º';

        $model = \Model\Google::where('cliente_id', $this->usuario->cliente_id)->first();
        $this->view('configuracao/google/form', array(
            'item' => $model
        ));


    }

    public final function actionPostForm ()
    {
        $model = \Model\Google::where('cliente_id', $this->usuario->cliente_id)->first();

        /**
         * Se não estiver cadastrado, insere um novo
         */

        if ($model == NULL)
        {

            $model = new \Model\Google();

        }

        $model->saveArray([
            'cliente_id'      => $this->usuario->cliente_id,
            'enabled'          => Input::get('enabled'),
        ]);

        Mensagem::sucesso('Script inserido com sucesso!');

        Redirect::to('backend/google/form');
    }

}