<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Email extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'E-mails';

            $enumeracao = new Enumeracao();

            $item = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $modelEmail = \Model\ConfiguracaoEmail::where('cliente_id', '=', $this->usuario->cliente_id)->first();

            if($modelEmail->id)
            {

                foreach (['ficha_cadastral', 'proposta', 'contato'] as $tipo) {

                    if($modelEmail->{'email_'.$tipo} == NULL)
                    {

                        $modelEmail->saveArray([
                            'nome_'.$tipo => $modelEmail->receptor_nome,
                            'email_'.$tipo => $modelEmail->receptor_email,
                        ]);

                    }

                }

            }

            $modelEmail = \Model\ConfiguracaoEmail::where('cliente_id', '=', $this->usuario->cliente_id)->first();

            $this->view('configuracao/email/form', array(
                'item'        => $item,
                'email'       => $modelEmail,
                'aEnumeracao' => array(
                    'autenticacaoSeguranca' => $enumeracao->autenticacaoSeguranca($modelEmail->autenticacao_seguranca),
                ),
            ));

        }

        public final function actionPostForm()
        {


            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'email_cabecalho'        => Input::get('email_cabecalho'),
                'email_rodape'           => Input::get('email_rodape'),
            ]);

            $model = \Model\ConfiguracaoEmail::where('cliente_id', $this->usuario->cliente_id)->first();

            if ($model == NULL)
            {

                $model = new \Model\ConfiguracaoEmail();

            }

            $model->saveArray([
                'cliente_id'             => $this->usuario->cliente_id,
                'smtp'                   => Input::get('smtp'),
                'emissor_email'          => Input::get('emissor_email'),
                'emissor_senha'          => Input::get('emissor_senha'),
                'porta'                  => Input::get('porta'),
                'autenticacao_seguranca' => Input::get('autenticacao_seguranca'),
                'receptor_nome'          => Input::get('receptor_nome'),
                'receptor_email'         => Input::get('receptor_email'),
                'nome_ficha_cadastral'   => Input::get('nome_ficha_cadastral'),
                'email_ficha_cadastral'  => Input::get('email_ficha_cadastral'),
                'nome_proposta'          => Input::get('nome_proposta'),
                'email_proposta'         => Input::get('email_proposta'),
                'nome_contato'           => Input::get('nome_contato'),
                'email_contato'          => Input::get('email_contato'),
            ]);

            Mensagem::sucesso('Configurações de e-mail salvas com sucesso!');

            Redirect::back();

        }

    }