<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Contato extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Contato';

            $contato = \Model\Contato::where('cliente_id', $this->usuario->cliente_id)->first();
            $cliente = \Model\Cliente::where('id', $this->usuario->cliente_id)->first();

            foreach (range(1,3) as $x)
            {

                $aTelefone[$x] = array(
                    'tipo'       => $contato->{'telefone_tipo_'.$x},
                    'icone'      => $contato->{'telefone_icone_'.$x},
                    'telefone'   => $contato->{'telefone_valor_'.$x},
                );

                $aHorario[$x] = array(
                    'tipo'       => $contato->{'horario_tipo_'.$x},
                    'horario'    => $contato->{'horario_valor_'.$x},
                );

            }

            $enumeracao = new Enumeracao();

            $this->view('configuracao/contato/form', array(
                'contato'       => $contato,
                'cliente'       => $cliente,
                'aTelefone'     => $aTelefone,
                'aHorario'      => $aHorario,
                'aEnumeracao'   => array(
                    'estado' => $enumeracao->estado($cliente->endereco_uf),
                    'telefone_icone_1' => $enumeracao->tipoTelefone($aTelefone[1]['icone']),
                    'telefone_icone_2' => $enumeracao->tipoTelefone($aTelefone[2]['icone']),
                    'telefone_icone_3' => $enumeracao->tipoTelefone($aTelefone[3]['icone']),
                )
            ));



        }

        public final function actionPostForm()
        {

            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'endereco_rua'          => Input::get('endereco_rua'),
                'endereco_numero'       => Input::get('endereco_numero'),
                'endereco_bairro'       => Input::get('endereco_bairro'),
                'endereco_cidade'       => Input::get('endereco_cidade'),
                'endereco_uf'           => Input::get('endereco_uf'),
                'endereco_cep'          => Input::get('endereco_cep'),
                'endereco_complemento'  => Input::get('endereco_complemento'),
            ]);

            $model = \Model\Contato::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'mapa_link'        => Input::get('mapa_link'),

                'telefone_icone_1' => Input::get('telefone_icone_1'),
                'telefone_tipo_1'  => Input::get('telefone_tipo_1'),
                'telefone_valor_1' => Input::get('telefone_valor_1'),

                'telefone_icone_2' => Input::get('telefone_icone_2'),
                'telefone_tipo_2'  => Input::get('telefone_tipo_2'),
                'telefone_valor_2' => Input::get('telefone_valor_2'),

                'telefone_icone_3' => Input::get('telefone_icone_3'),
                'telefone_tipo_3'  => Input::get('telefone_tipo_3'),
                'telefone_valor_3' => Input::get('telefone_valor_3'),

                'horario_tipo_1'   => Input::get('horario_tipo_1'),
                'horario_valor_1'  => Input::get('horario_valor_1'),

                'horario_tipo_2'   => Input::get('horario_tipo_2'),
                'horario_valor_2'  => Input::get('horario_valor_2'),

                'horario_tipo_3'   => Input::get('horario_tipo_3'),
                'horario_valor_3'  => Input::get('horario_valor_3'),
            ]);


            Mensagem::sucesso('Contato alterado com sucesso!');
            Redirect::back();

        }

    }