<?php

    namespace Backend;

    use Base\Enumeracao;
    use Base\Mensagem;
    use Base\W2O;
    use Parvus\Input;
    use Parvus\Redirect;

    class Cabecalho extends Base
    {

        public final function actionGetForm()
        {

            $this->titulo = 'Cabeçalho';

            $item = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $this->view('configuracao/cabecalho/form', array(
                'item'        => $item,
            ));

        }

        public final function actionPostForm()
        {

            $model = \Model\Cliente::where('id', '=', $this->usuario->cliente_id)->first();

            $model->saveArray([
                'telefone_cabecalho' => Input::get('telefone_cabecalho'),
                'email_cabecalho'    => Input::get('email_cabecalho'),
            ]);

            Mensagem::sucesso('Cabeçalho alterados com sucesso!');
            Redirect::back();

        }

    }