<?php

namespace Automatico;

use Imagine\Gd\Imagine;
use Imagine\Image\Box;
use Model\Cliente;
use Model\Usuario;
use Model\Veiculo;
use Model\VeiculoImagem;
use Model\VeiculoMarca;
use Model\VeiculoMarcaModelo;
use Parvus\Input;

class ConverteNome
{

    public final function actionGetIndex()
    {


            $modelVeiculo = \Model\Veiculo::get();

            foreach($modelVeiculo as $dado)
            {

                if ($dado['fabricacao'] && $dado['modelo'])
                {

                    $ano = $dado['fabricacao'] . '/' . $dado['modelo'];

                }
                else if ($dado['fabricacao'] && !$dado['modelo'])
                {

                    $ano = $dado['fabricacao'];

                }
                else if (!$dado['fabricacao'] && $dado['modelo'])
                {

                    $ano = $dado['modelo'];

                }

                $ano = $ano ? ' '.$ano : NULL;

                $cor =  $dado['cor'] ? ' '.$dado['cor'] : NULL;
                $nome = $dado->veiculoMarca->nome. ' ' . $dado->veiculoMarcaModelo->nome . ' ' . $dado->veiculoMarcaModelo->complemento.$cor.$ano;

                pre_print_r('ALTERADO DE: '. $dado['nome'].' PARA: '. $nome,false);

                \Model\Veiculo::where('id',$dado['id'])
                    ->where('cliente_id',$dado['cliente_id'])
                    ->update(['nome' => $nome]);

            }




    }

    public final function formataNomeVeiculo($prNome)
    {

        $alias = $prNome;

        $alias = preg_replace("/&([a-z])[a-z]+;/i", "$1", htmlentities(trim(strtolower($alias))));

        $alias = str_replace(array('/','.', '-'),' ',$alias);

        $alias = str_replace(' ', '-', $alias);

        $alias = str_replace(array('$','!','@','#','%','*','(',')',')'), '', $alias);

        $alias = preg_replace('/--+/', '-', $alias);

        return $alias;

    }

    public final function cURL ($prLink) {

        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $prLink);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
        $conteudo = curl_exec($ch);
        curl_close($ch);

        return $conteudo;
    }


}