<?php

    namespace Automatico;

    use Base\cURL;
    use Cake\Database\Exception;
    use Model\Noticia;
    use Model\ParametroGeral;
    use Parvus\Date;
    use Parvus\DB;

    class Blog
    {

        public final function actionGetIndex()
        {


            if(!is_dir('arquivo/1/noticia/'))
            {

                @mkdir('arquivo/1/noticia/');

            }

            /**
             * Verifica alias
             */

            $sql = " select * from noticia";
            $sql.= " where 1";
            $sql.= " and";
            $sql.= " (";
                $sql.= " alias like '%?%' ||";
                $sql.= " alias like '%!%' ||";
                $sql.= " alias like '%&%' ||";
                $sql.= " alias like '%$%' ||";
                $sql.= " alias like '%#%' ||";
                $sql.= " alias like '%@%'";
            $sql.= " )";


            foreach (DB::select($sql) as $item)
            {

                unset($model);

                $model = Noticia::where('id', $item['id'])->first();

                $model->saveArray(array(
                    'alias' => $this->alias($model['alias'])
                ));

            }

            $cURL = new cURL('http://feeds.feedburner.com/automotivas?format=xml');

            $conteudo = $cURL->get();

            foreach (ParametroGeral::where('importa_noticia_blog', 'Sim')->get() as $item)
            {

                foreach (simplexml_load_string($conteudo)->channel->item as $itemBlog)
                {

                    $quantidadeHoje = Noticia::where('tipo', 'Automatica')
                        ->where('data', Date::date($itemBlog->pubDate, 'Y-m-d'))
                        ->get()
                        ->count();

                    if($quantidadeHoje == '5')
                    {
                        continue;
                    }

                    $modelNoticia = Noticia::where('cliente_id', $item->cliente_id)
                        ->where('linkBlog', $itemBlog->link)
                        ->first();

                    if(!$modelNoticia)
                    {


                        $total++;

                        $titulo = utf8_decode($item->title);
                        $titulo = str_replace('?','',$titulo);
                        $titulo = str_replace("'",'"',$titulo);

                        $modelNoticia = new Noticia();

                        $modelNoticia->saveArray([
                            'cliente_id'        => $item->cliente_id,
                            'tipo'              => 'Automatica',
                            'situacao'          => 'Ativo',
                            'data'              => Date::date($itemBlog->pubDate, 'Y-m-d'),
                            'alias'             => $this->alias($itemBlog->title),
                            'imagem'            => 'atualizando',
                            'chamada'           => $itemBlog->title,
                            'integra'           => $itemBlog->description,
                            'linkBlog'          => $itemBlog->link
                        ]);

                        $id = $modelNoticia->id;

                        $imagem = substr($itemBlog->description, strpos($itemBlog->description, '<img'));
                        $imagem = substr($imagem, 0, strpos($imagem,'>')+1);

                        $url = substr($imagem, strpos($imagem, 'src="')+5);
                        $url = substr($url, 0,strpos($url, '"'));

                        if($url)
                        {

                            $extensao = strrchr($url,'.');

                            @mkdir('arquivo/'.$item->cliente_id.'/noticia/'.$id.'/');
                            try{


                                $destino = 'arquivo/'.$item->cliente_id.'/noticia/'.$id.'/thumb'.$extensao;

                                $contents=file_get_contents($url);
                                file_put_contents($destino,$contents);

                            }catch (Exception $e){
                                print_r($e->getMessage());
                            }


                            $modelNoticia = Noticia::where('id', $id)->first();
                            $modelNoticia->saveArray([
                                'imagem' => 'thumb'.$extensao
                            ]);

                        }

                    }

                }

            }

        }

        public final function alias($prNome)
        {

            $alias = $prNome;

            $alias = preg_replace("/&([a-z])[a-z]+;/i", "$1", htmlentities(trim(strtolower($alias))));

            $alias = str_replace(array('/','.', '-',',',':', '?', '!','&','$', '#','@','%','*'),' ',$alias);

            $alias = str_replace(' ', '-', $alias);

            $alias = preg_replace('/--+/', '-', $alias);

            return $alias;

        }

    }