<?php

namespace Backend;

use Base\Enumeracao;
use Base\Mensagem;
use Base\Table;
use Parvus\Date;
use Parvus\Input;
use Parvus\Redirect;

class Analytics extends Base
{

    protected $titulo = 'Scripts';

    public final function actionGetForm()
    {

        $model = \Model\Analytics::where('cliente_id', $this->usuario->cliente_id)->first();

        $modelCliente = \Model\ParametroGeral::where('cliente_id', $this->usuario->cliente_id)
            ->first();

        $this->view('configuracao/analytics/form', array(
            'item' => $model,
            'dados'=>$modelCliente
        ));


    }

    public final function actionPostForm()
    {

        $model = \Model\Analytics::where('cliente_id', $this->usuario->cliente_id)->first();

        /**
         * Se não estiver cadastrado, insere um novo
         */

        if ($model == NULL) {

            $model = new \Model\Analytics();

        }

        $model->saveArray([
            'cliente_id' => $this->usuario->cliente_id,
            'script' => Input::get('script'),
            'script_proposta' => Input::get('script_proposta'),
            'script_facebook_pixel' => Input::get('script_facebook_pixel')
        ]);


        $modelCliente = \Model\ParametroGeral::where('cliente_id', $this->usuario->cliente_id)
            ->first();


        $modelCliente->saveArray([
            'header' => Input::get('header'),
            'footer' => Input::get('footer'),
            'body' => Input::get('body'),
        ]);


        Mensagem::sucesso('Script inserido com sucesso!');

        Redirect::to('backend/analytics/form');

    }


}