#TABLE#
CREATE TABLE IF NOT EXISTS `cliente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(50) DEFAULT NULL,
  `nome` varchar(255) NOT NULL,
  `CNPJ` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `favicon` varchar(255) DEFAULT NULL,
  `telefone_cabecalho` varchar(15) DEFAULT NULL,
  `telefone_rodape` varchar(15) DEFAULT NULL,
  `email_cabecalho` varchar(255) DEFAULT NULL,
  `email_rodape` varchar(255) DEFAULT NULL,
  `cor_primaria` varchar(10) DEFAULT '#004587',
  `cor_secundaria` varchar(10) DEFAULT '#FDDD00',
  `endereco_rua` varchar(255) DEFAULT NULL,
  `endereco_numero` varchar(255) DEFAULT NULL,
  `endereco_bairro` varchar(255) DEFAULT NULL,
  `endereco_cidade` varchar(255) DEFAULT NULL,
  `endereco_uf` varchar(2) DEFAULT NULL,
  `endereco_cep` varchar(255) DEFAULT NULL,
  `endereco_complemento` varchar(255) DEFAULT NULL,
  `chat` longtext DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) DEFAULT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='Cliente da Windi';

#TABLE#
CREATE TABLE IF NOT EXISTS `analytics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `script` text DEFAULT NULL,
  `script_proposta` text DEFAULT NULL,
  `script_facebook_pixel` text DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_analytics_cliente` (`cliente_id`),
  CONSTRAINT `FK_analytics_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


#TABLE#
CREATE TABLE IF NOT EXISTS `banner` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(9) NOT NULL,
  `descricao` varchar(255) NOT NULL,
  `ordem` int(9) NOT NULL,
  `arquivo` varchar(255) NOT NULL,
  `link` longtext DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_banner_cliente` (`cliente_id`),
  CONSTRAINT `FK_banner_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


#TABLE#
CREATE TABLE IF NOT EXISTS `configuracao_contato` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(9) NOT NULL,
  `mapa_link` text DEFAULT NULL,
  `email_formulario` varchar(255) DEFAULT NULL,
  `email_informacao` varchar(255) DEFAULT NULL,
  `telefone_tipo_1` varchar(255) DEFAULT NULL,
  `telefone_valor_1` varchar(15) DEFAULT NULL,
  `telefone_tipo_2` varchar(255) DEFAULT NULL,
  `telefone_valor_2` varchar(15) DEFAULT NULL,
  `telefone_tipo_3` varchar(255) DEFAULT NULL,
  `telefone_valor_3` varchar(15) DEFAULT NULL,
  `horario_tipo_1` varchar(255) DEFAULT NULL,
  `horario_valor_1` varchar(255) DEFAULT NULL,
  `horario_tipo_2` varchar(255) DEFAULT NULL,
  `horario_valor_2` varchar(255) DEFAULT NULL,
  `horario_tipo_3` varchar(255) DEFAULT NULL,
  `horario_valor_3` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK__cliente` (`cliente_id`),
  CONSTRAINT `FK__cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


#TABLE#
CREATE TABLE IF NOT EXISTS `configuracao_email` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL DEFAULT 0,
  `emissor_email` varchar(255) NOT NULL,
  `emissor_senha` varchar(255) NOT NULL,
  `autenticacao_seguranca` enum('ssl','tls') NOT NULL,
  `porta` int(11) NOT NULL,
  `receptor_nome` varchar(255) DEFAULT NULL,
  `receptor_email` varchar(255) DEFAULT NULL,
  `nome_ficha_cadastral` varchar(255) NOT NULL,
  `email_ficha_cadastral` varchar(255) DEFAULT NULL,
  `nome_proposta` varchar(255) DEFAULT NULL,
  `email_proposta` varchar(255) DEFAULT NULL,
  `nome_contato` varchar(255) DEFAULT NULL,
  `email_contato` varchar(255) DEFAULT NULL,
  `smtp` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email_to_cliente` (`cliente_id`),
  CONSTRAINT `email_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `contato` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` enum('Matriz','Filial') DEFAULT NULL,
  `nome` longtext DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `endereco_rua` varchar(255) DEFAULT NULL,
  `endereco_numero` varchar(255) DEFAULT NULL,
  `endereco_cep` varchar(255) DEFAULT NULL,
  `endereco_complemento` varchar(255) DEFAULT NULL,
  `endereco_bairro` varchar(255) DEFAULT NULL,
  `endereco_cidade` varchar(255) DEFAULT NULL,
  `endereco_uf` varchar(255) DEFAULT NULL,
  `endereco_mapa` longtext DEFAULT NULL,
  `telefone_icone_1` enum('WhatsApp','Telefone') DEFAULT 'Telefone',
  `telefone_tipo_1` varchar(255) DEFAULT NULL,
  `telefone_valor_1` varchar(255) DEFAULT NULL,
  `telefone_icone_2` enum('WhatsApp','Telefone') DEFAULT 'Telefone',
  `telefone_tipo_2` varchar(255) DEFAULT NULL,
  `telefone_valor_2` varchar(255) DEFAULT NULL,
  `telefone_icone_3` enum('WhatsApp','Telefone') DEFAULT 'Telefone',
  `telefone_tipo_3` varchar(255) DEFAULT NULL,
  `telefone_valor_3` varchar(255) DEFAULT NULL,
  `horario_tipo_1` varchar(255) DEFAULT NULL,
  `horario_valor_1` varchar(255) DEFAULT NULL,
  `horario_tipo_2` varchar(255) DEFAULT NULL,
  `horario_valor_2` varchar(255) DEFAULT NULL,
  `horario_tipo_3` varchar(255) DEFAULT NULL,
  `horario_valor_3` varchar(255) DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `empresa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `descricao` longtext NOT NULL,
  `imagem` varchar(255) NOT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `empresa_to_cliente` (`cliente_id`),
  CONSTRAINT `empresa_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `empresa_galeria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `imagem` varchar(255) NOT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

#TABLE#
CREATE TABLE IF NOT EXISTS `ficha_cadastral` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) DEFAULT NULL,
  `nome` varchar(255) NOT NULL,
  `cpf` varchar(17) NOT NULL,
  `rg` varchar(255) NOT NULL,
  `orgao_emissor_rg` varchar(255) DEFAULT NULL,
  `data_emissao_rg` datetime DEFAULT NULL,
  `uf_rg` varchar(2) DEFAULT NULL,
  `telefone` varchar(15) DEFAULT NULL,
  `celular` varchar(15) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `naturalidade` varchar(255) DEFAULT NULL,
  `data_nascimento` datetime DEFAULT NULL,
  `sexo` enum('Masculino','Feminino') DEFAULT NULL,
  `estado_civil` enum('Solteiro','Casado') DEFAULT NULL,
  `profissao` varchar(255) DEFAULT NULL,
  `numero_dependente` int(11) DEFAULT NULL,
  `nome_pai` varchar(255) DEFAULT NULL,
  `nome_mae` varchar(255) DEFAULT NULL,
  `endereco` varchar(255) DEFAULT NULL,
  `endereco_numero` int(11) DEFAULT NULL,
  `endereco_complemento` varchar(255) DEFAULT NULL,
  `endereco_bairro` varchar(255) DEFAULT NULL,
  `endereco_cep` varchar(255) DEFAULT NULL,
  `endereco_cidade` varchar(255) DEFAULT NULL,
  `endereco_uf` varchar(255) DEFAULT NULL,
  `endereco_tipo_residencia` varchar(255) DEFAULT NULL,
  `endereco_tempo_residencia` varchar(255) DEFAULT NULL,
  `endereco_telefone` varchar(15) DEFAULT NULL,
  `endereco_tipo_telefone` varchar(255) DEFAULT NULL,
  `endereco_correspondencia` varchar(255) DEFAULT NULL,
  `profissional_tipo_ocupacao` varchar(255) DEFAULT NULL,
  `profissional_profissao` varchar(255) DEFAULT NULL,
  `profissional_empresa` varchar(255) DEFAULT NULL,
  `profissional_cnpj` varchar(255) DEFAULT NULL,
  `profissional_cargo_funcao` varchar(255) DEFAULT NULL,
  `profissional_data_admissao` datetime DEFAULT NULL,
  `profissional_telefone` varchar(15) DEFAULT NULL,
  `profissional_endereco_comercial` varchar(255) DEFAULT NULL,
  `profissional_endereco_numero` varchar(255) DEFAULT NULL,
  `profissional_endereco_bairro` varchar(255) DEFAULT NULL,
  `profissional_endereco_cep` varchar(255) DEFAULT NULL,
  `profissional_endereco_cidade` varchar(255) DEFAULT NULL,
  `profissional_endereco_uf` varchar(255) DEFAULT NULL,
  `profissional_salario` varchar(255) DEFAULT NULL,
  `profissional_fonte_renda` varchar(255) DEFAULT NULL,
  `profissional_origem` varchar(255) DEFAULT NULL,
  `profissional_renda_bruta` varchar(255) DEFAULT NULL,
  `profissional_mes_ano` varchar(255) DEFAULT NULL,
  `referencia_pessoal_1` varchar(255) DEFAULT NULL,
  `referencia_telefone_1` varchar(15) DEFAULT NULL,
  `referencia_pessoal_2` varchar(255) DEFAULT NULL,
  `referencia_telefone_2` varchar(15) DEFAULT NULL,
  `referencia_banco_1` varchar(255) DEFAULT NULL,
  `referencia_agencia_1` varchar(255) DEFAULT NULL,
  `referencia_conta_corrente_1` varchar(255) DEFAULT NULL,
  `referencia_gerente_1` varchar(255) DEFAULT NULL,
  `referencia_banco_telefone_1` varchar(15) DEFAULT NULL,
  `referencia_banco_2` varchar(255) DEFAULT NULL,
  `referencia_agencia_2` varchar(255) DEFAULT NULL,
  `referencia_conta_corrente_2` varchar(255) DEFAULT NULL,
  `referencia_gerente_2` varchar(255) DEFAULT NULL,
  `referencia_banco_telefone_2` varchar(15) DEFAULT NULL,
  `marca` varchar(255) DEFAULT NULL,
  `modelo` varchar(255) DEFAULT NULL,
  `ano` varchar(255) DEFAULT NULL,
  `combustivel` varchar(255) DEFAULT NULL,
  `valor_venda` varchar(255) DEFAULT NULL,
  `numero_parcela` int(11) DEFAULT NULL,
  `valor_financiado` varchar(255) DEFAULT NULL,
  `conjuge_nome` varchar(255) DEFAULT NULL,
  `conjuge_cpf` varchar(17) DEFAULT NULL,
  `conjuge_rg` varchar(11) DEFAULT NULL,
  `conjuge_data_nascimento` datetime DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ficha_to_cliente` (`cliente_id`),
  CONSTRAINT `ficha_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `descricao` varchar(255) DEFAULT NULL,
  `icone` varchar(255) NOT NULL,
  `foto` varchar(255) NOT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `foto_to_cliente` (`cliente_id`),
  CONSTRAINT `foto_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `google360` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `enabled` text DEFAULT NULL,
  `log_cadastro_usuario_id` int(11) DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_cadastro_data` date DEFAULT NULL,
  `log_alterado_data` date DEFAULT NULL,
  `log_excluido_data` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_cliente_cadastro` (`cliente_id`),
  CONSTRAINT `fk_cliente_cadastro` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `modal` (
  `id` int(11) NOT NULL,
  `exibe` enum('Sim','Não') NOT NULL DEFAULT 'Não',
  `imagem` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `noticia` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `tipo` enum('Automatica','Manual') NOT NULL DEFAULT 'Manual',
  `situacao` enum('Ativo','Inativo') NOT NULL DEFAULT 'Ativo',
  `data` date NOT NULL,
  `alias` varchar(255) NOT NULL,
  `imagem` varchar(255) NOT NULL,
  `chamada` varchar(255) NOT NULL,
  `integra` text DEFAULT NULL,
  `linkBlog` text DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) DEFAULT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `noticia_to_cliente` (`cliente_id`),
  CONSTRAINT `noticia_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `pagina` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nome` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


#TABLE#
CREATE TABLE IF NOT EXISTS `pagina_cliente` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pagina_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `exibe` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `nome` varchar(255) DEFAULT NULL,
  `log_cadastro_data` datetime DEFAULT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pagina_id` (`pagina_id`),
  KEY `pagina_cliente` (`cliente_id`),
  CONSTRAINT `pagina_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `pagina_id` FOREIGN KEY (`pagina_id`) REFERENCES `pagina` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `parametro_geral` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) DEFAULT NULL,
  `tema` enum('Tema 1','Tema 2','Tema 3') DEFAULT NULL,
  `menu_fixo` enum('Sim','Não') DEFAULT 'Não',
  `tipo_banner` enum('Largura fixa','Largura variável') DEFAULT 'Largura variável',
  `importa_noticia_blog` enum('Sim','Não') DEFAULT NULL,
  `filtro_exibe_marca` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `filtro_exibe_ano` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `filtro_exibe_mais_recente_dia` int(9) NOT NULL DEFAULT 10,
  `nome_pagina_home` varchar(255) NOT NULL DEFAULT 'Home',
  `filtro_exibe_modelo` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `filtro_exibe_quantidade_veiculo` int(9) NOT NULL DEFAULT 10,
  `exibe_auto_load_estoque` int(9) NOT NULL DEFAULT 10,
  `exibe_todo_opcional` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `exibe_placa` enum('Início','Final') NOT NULL DEFAULT 'Início',
  `exibe_placa_mascara` varchar(50) DEFAULT NULL,
  `exibe_ano` enum('Ano modelo','Ano fabricação+Ano Modelo') NOT NULL DEFAULT 'Ano modelo',
  `exibe_estoque_home` enum('Sim','Não') NOT NULL DEFAULT 'Não',
  `tem_fundo_preco_estoque` enum('Sim','Não') NOT NULL DEFAULT 'Sim',
  `quantidade_veiculo_home` int(11) NOT NULL DEFAULT 12,
  `compartilhar_veiculo` enum('Sim','Não') NOT NULL DEFAULT 'Não',
  `link_facebook` longtext DEFAULT NULL,
  `ordem` enum('Maior Preço Primeiro','Menor Preço Primeiro','Ordem Alfabética dos Modelos') NOT NULL DEFAULT 'Maior Preço Primeiro',
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  `recaptcha` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_parametro_geral_cliente` (`cliente_id`),
  CONSTRAINT `FK_parametro_geral_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `rede_social` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL DEFAULT 0,
  `link_facebook` text DEFAULT NULL,
  `link_instagram` text DEFAULT NULL,
  `link_twitter` text DEFAULT NULL,
  `link_youtube` text DEFAULT NULL,
  `link_google+` text DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rede_social_to_cliente` (`cliente_id`),
  CONSTRAINT `rede_social_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `rodape` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telefone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `endereco_rua` varchar(255) DEFAULT NULL,
  `endereco_numero` varchar(255) DEFAULT NULL,
  `endereco_bairro` varchar(255) DEFAULT NULL,
  `endereco_cidade` varchar(255) DEFAULT NULL,
  `endereco_uf` varchar(255) DEFAULT NULL,
  `endereco_cep` varchar(255) DEFAULT NULL,
  `endereco_complemento` varchar(255) DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `rodape_fixo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exibe` enum('Sim','Não') NOT NULL DEFAULT 'Não',
  `frase_principal` varchar(255) DEFAULT NULL,
  `frase_secundaria` varchar(255) DEFAULT NULL,
  `telefone_tipo_1` enum('WhatsApp','Telefone') DEFAULT 'WhatsApp',
  `telefone_numero_1` varchar(255) DEFAULT NULL,
  `telefone_frase_1` varchar(255) DEFAULT NULL,
  `telefone_tipo_2` enum('WhatsApp','Telefone') DEFAULT 'Telefone',
  `telefone_numero_2` varchar(255) DEFAULT NULL,
  `telefone_frase_2` varchar(255) DEFAULT NULL,
  `telefone_tipo_3` enum('WhatsApp','Telefone') DEFAULT NULL,
  `telefone_numero_3` varchar(255) DEFAULT NULL,
  `telefone_frase_3` varchar(255) DEFAULT NULL,
  `telefone_tipo_4` enum('WhatsApp','Telefone') DEFAULT NULL,
  `telefone_numero_4` varchar(255) DEFAULT NULL,
  `telefone_frase_4` varchar(255) DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `seo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `palavra_chave` varchar(255) DEFAULT NULL,
  `log_cadastro_data` date DEFAULT NULL,
  `log_alterado_data` date DEFAULT NULL,
  `log_excluido_data` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `usuario` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `email` varchar(255) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `tipo` enum('Administrador') NOT NULL DEFAULT 'Administrador',
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cliente_to_usuario` (`cliente_id`),
  CONSTRAINT `cliente_to_usuario` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `veiculo_marca` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `nome` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `veiculo_marca_to_cliente` (`cliente_id`),
  CONSTRAINT `veiculo_marca_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `veiculo_marca_modelo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `veiculo_marca_id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `complemento` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `veiculo_marca_modelo_to_veiculo_marca` (`veiculo_marca_id`),
  CONSTRAINT `veiculo_marca_modelo_to_veiculo_marca` FOREIGN KEY (`veiculo_marca_id`) REFERENCES `veiculo_marca` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `versao` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `data` date NOT NULL,
  `texto` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


#TABLE#
CREATE TABLE IF NOT EXISTS `veiculo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `veiculo_marca_id` int(11) NOT NULL,
  `veiculo_marca_modelo_id` int(11) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `codigo` varchar(255) NOT NULL,
  `nome` varchar(255) NOT NULL,
  `cidade` varchar(255) DEFAULT NULL,
  `placa` varchar(255) DEFAULT NULL,
  `fabricacao` int(4) NOT NULL,
  `modelo` int(4) NOT NULL,
  `valor` decimal(12,2) NOT NULL,
  `data` datetime NOT NULL,
  `quilometragem` int(11) unsigned DEFAULT NULL,
  `potencia` varchar(255) DEFAULT NULL,
  `porta` int(11) unsigned DEFAULT NULL,
  `cor` varchar(255) DEFAULT NULL,
  `tipo` enum('Carro','Moto','Triciclo','Quadriciclo','Barco','Jet Ski','Ônibus','Micronibus','Van','Motor home','Máquinas agrícolas','Implemento Rodoviário') NOT NULL,
  `combustivel` set('Álcool','Gasolina','GNV','Diesel','Elétrico') DEFAULT NULL,
  `observacao` text DEFAULT NULL,
  `opcional` text DEFAULT NULL,
  `destaque` tinyint(1) DEFAULT NULL,
  `repasse` tinyint(1) DEFAULT NULL,
  `oferta` tinyint(1) DEFAULT NULL,
  `imagem` varchar(255) DEFAULT NULL,
  `filial_apelido` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`),
  KEY `veiculo_to_cliente` (`cliente_id`),
  KEY `veiculo_to_marca` (`veiculo_marca_id`),
  KEY `veiculo_to_marca_modelo` (`veiculo_marca_modelo_id`),
  CONSTRAINT `veiculo_to_cliente` FOREIGN KEY (`cliente_id`) REFERENCES `cliente` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `veiculo_to_marca` FOREIGN KEY (`veiculo_marca_id`) REFERENCES `veiculo_marca` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `veiculo_to_marca_modelo` FOREIGN KEY (`veiculo_marca_modelo_id`) REFERENCES `veiculo_marca_modelo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


#TABLE#
CREATE TABLE IF NOT EXISTS `veiculo_imagem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `veiculo_id` int(11) NOT NULL,
  `nome` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `veiculo_to_imagem` (`veiculo_id`),
  CONSTRAINT `veiculo_to_imagem` FOREIGN KEY (`veiculo_id`) REFERENCES `veiculo` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

#TABLE#
CREATE TABLE IF NOT EXISTS `youtube` (
  `id` int(11) NOT NULL,
  `exibe` enum('Sim','Não') NOT NULL,
  `canal` text DEFAULT NULL,
  `video_1` text DEFAULT NULL,
  `video_2` text DEFAULT NULL,
  `video_3` text DEFAULT NULL,
  `log_cadastro_data` datetime NOT NULL,
  `log_cadastro_usuario_id` int(11) NOT NULL,
  `log_alterado_data` datetime DEFAULT NULL,
  `log_alterado_usuario_id` int(11) DEFAULT NULL,
  `log_excluido_data` datetime DEFAULT NULL,
  `log_excluido_usuario_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#TABLE#
CREATE TABLE IF NOT EXISTS `google360`(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `enabled` TEXT,
  `log_cadastro_usuario_id` INT,
  `log_alterado_usuario_id` INT,
  `log_cadastro_data` DATE,
  `log_alterado_data` DATE,
  `log_excluido_data` DATE,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_cliente_cadastro` FOREIGN KEY (`cliente_id`) REFERENCES `cliente`(`id`) ON UPDATE CASCADE ON DELETE CASCADE
);


