<?php

class alt_formulario_lead extends WP_Widget
{
    protected static $did_script = false;

    function __construct()
    {
        parent::__construct(

        // Base ID of your widget
            'alt_formulario_lead',

            // Widget name will appear in UI
            'Altimus - Formulário Padrão',

            // Widget description
            array(
                'description' => 'Formulário padrão de conversão de vendas',
            )
        );


        add_action('wp_enqueue_scripts', array($this, 'scripts'));
    }

    public function scripts()
    {
        $url_widget = plugin_dir_url(__FILE__);
        $versao = 2021;

        wp_enqueue_script('def-padrao-js', $url_widget . 'assets/main.js', 'jquery', $versao, true);
        wp_enqueue_style('def-padrao-style', $url_widget . 'assets/style.css', null, $versao, 'all');
        wp_enqueue_script('def-jquery-mask', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.maskedinput/1.4.1/jquery.maskedinput.min.js', 'jquery', $versao, true);
    }

    public function widget($args, $instance)
    {
        global $wp;
        global $post;


        $titulo = !empty($instance['titulo']) ? $instance['titulo'] : 'Fale conosco';
        $email_destino = !empty($instance['email_destino']) ? $instance['email_destino'] : '';
        $assunto = !empty($instance['assunto']) ? $instance['email_destino'] : '';
        $layout = !empty($instance['layout']) ? $instance['layout'] : '';

        $current_url = home_url(add_query_arg('_nonce_upload', wp_create_nonce('nonce_upload'), '/wp-admin/admin-ajax.php?action=alt_form_submit'));


        $veiculo_id = $post->ID;
        $url = home_url($wp->request);

        $arrInfo = get_info_principal(true);
        if (!isset($arrInfo['email']) || empty($arrInfo['email'])) {
            echo "<div class='alert alert-danger'>Formulário inativado, configure o email principal da matriz</div>";
        }

        if($layout){
            include 'template-simple.php';
        }else{
            include 'template.php';
        }


    }

    public function form($instance)
    {

        $titulo = !empty($instance['titulo']) ? $instance['titulo'] : 'Fale conosco';
        $email_destino = !empty($instance['email_destino']) ? $instance['email_destino'] : '';

        update_option('email_destino_formulario', $email_destino);
        include 'form.php';

    }

    public function update($new_instance, $old_instance)
    {
        $instance = $old_instance;
        $instance['titulo'] = strip_tags($new_instance['titulo']);
        $instance['email_destino'] = $new_instance['email_destino'];
        $instance['assunto'] = strip_tags($new_instance['assunto']);

        return $instance;

    }
}


add_action('wp_ajax_alt_form_submit', 'alt_form_submit');
add_action('wp_ajax_nopriv_alt_form_submit', 'alt_form_submit');

function alt_form_submit()
{
    if (!isset($_GET['_nonce_upload']) || !wp_verify_nonce($_GET['_nonce_upload'], 'nonce_upload')) {

        $msg_error = 'Aconteceu um erro interno no nosso site, tente novamente mais tarde ou fale conosco por telefone.';
        wp_send_json(['msg' => $msg_error, 'status' => 401]);

    } else {
        try {


            try {

                $email_destino = get_option('email_destino_formulario');

                if (empty($email_destino)) {

                    $arrInfo = get_info_principal(true);
                    if (!isset($arrInfo['email']) || empty($arrInfo['email'])) {
                        throw new Exception('Não foi possível enviar o email para a revenda.');
                    }

                    $email_destino = $arrInfo['email'];
                }

                $mensagem = '';



                $para = $email_destino;
                $assunto_email = 'Novo contato - Site';
                $headers = array('Content-Type: text/html; charset=UTF-8', 'from:'.$email_destino);



                $arrPost = $_POST;

                $nome = $arrPost['nome'] ?? 'Não especificado';
                $email = $arrPost['email'] ?? 'Não especificado';
                $telefone = $arrPost['telefone'] ?? 'Não especificado';
                $conteudo = $arrPost['mensagem'] ?? 'Não especificado';
                $assunto = $arrPost['assunto'] ?? null;

                $url_veiculo = $arrPost['url'] ?? 'Não especificado';
                $id_veiculo = $arrPost['veiculo_id'] ?? 'Não especificado';


                if (empty($email) || empty($telefone) || empty($nome)) {
                    $msg_validate = 'Alguns campos obrigatórios para que possamos entrar em contato com você não foram preenchidos.';
                    throw new Exception($msg_validate);
                }


                require_once 'template-email.php';


                wp_mail($para, $assunto_email, $mensagem, $headers, []);

            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }


            $msg = 'Mensagem enviado com sucesso.';

            $arrRetorno['status'] = 200;
            $arrRetorno['msg'] = $msg;

        } catch (Exception $e) {
            $arrRetorno['status'] = 401;
            $arrRetorno['msg'] = $e->getMessage();
        }
        wp_send_json($arrRetorno, $arrRetorno['status']);
    }

}
