<?php


if (file_exists(dirname(__FILE__) . '/cmb2/init.php')) {
    require_once dirname(__FILE__) . '/cmb2/init.php';
} elseif (file_exists(dirname(__FILE__) . '/CMB2/init.php')) {
    require_once dirname(__FILE__) . '/CMB2/init.php';
}

add_action('init', 'alt_bodywork', 0);
function alt_bodywork()
{
// Add new taxonomy, make it hierarchical like categories
//first do the translations part for GUI
    $labels = array(
        'name' => __('Carroceria'),
        'singular_name' => 'Carroceria',
        'search_items' => 'Busca Carroceria',
        'all_items' => 'Todas as Carrocerias',
        'parent_item' => 'Hierarquia Carroceria',
        'parent_item_colon' => __('Parent Carroceria:'),
        'edit_item' => __('Editar Carroceria'),
        'update_item' => __('Atualizar Carroceria'),
        'add_new_item' => __('Adicionar Carroceria'),
        'new_item_name' => __('Adicionar'),
        'menu_name' => __('Carroceria de veículo'),
    );
// Now register the taxonomy
    register_taxonomy('carroceria',
        array('product','veiculos'),
        array(
            'hierarchical' => true,
            'labels' => $labels,
            'show_ui' => true,
            'show_in_rest' => true,
            'show_admin_column' => true,
            'query_var' => true,
            'rewrite' => array('slug' => 'carroceria'),
        ));


}


//REST
add_action('rest_api_init', 'get_taxonomies_custom_veiculos_carroceria');

function get_taxonomies_custom_veiculos_carroceria()
{

    // register_rest_field ( 'name-of-post-type', 'name-of-field-to-return', array-of-callbacks-and-schema() )
    register_rest_field('product', 'carroceria', array(
            'get_callback' => 'get_carroceria_do_veiculo',
            'update_callback' => 'update_carroceria_veiculo',
            'schema' => null,
        )
    );
}

function update_carroceria_veiculo($value, $object, $field_name)
{

    $term = $value;
    $taxonomy = 'carroceria';
    $parent_term = term_exists($term, 'carroceria'); // array is returned if taxonomy is given
    //Manually creating the taxonomy term
    wp_insert_term($term, $taxonomy);
    //Manually assigning the term
    wp_set_object_terms($object->id, $term, $taxonomy);
    return update_post_meta($object->id, $field_name, $value);


}

function get_carroceria_do_veiculo($object)
{
    $post_id = $object['id'];
    return get_the_terms($post_id, 'carroceria');
}


/**
 * Campos adicionais
 */


add_action('cmb2_admin_init', 'alt_register_taxonomy_carroceria_metabox');

function alt_register_taxonomy_carroceria_metabox()
{
    $prefix = 'alt_term_';

    $cmb_term = new_cmb2_box(array(
        'id' => $prefix . 'carroceria',
        'title' => 'Imagem de categoria',
        'object_types' => array('term'),
        'taxonomies' => array('carroceria'),
        'new_term_section' => true,
    ));

    $cmb_term->add_field(array(
        'name' => 'Logo da carroceria',
        'desc' => 'Selecione o arquivo de imagem da carroceria.',
        'id' => 'carroceria_img',
        'type' => 'file',
        'options' => array(
            'url' => false,
        ),
    ));


}



