<?php

add_action('cmb2_admin_init', 'setup_listagem');


function setup_listagem()
{
    $theme_selected = 1;
    $theme = wp_get_theme();
    if ($theme->get('TextDomain') == 'altimus-2') {
        $theme_selected = 2;
    };


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup_listagem',
        'title' => 'Configurações Listagem (Estoque)',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_listagem', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    if ($theme_selected == 2) {

        $menu_layout = array(
            'bloco' => 'Blocos',
            'lista' => 'Lista',
        );
    } else {

        $menu_layout = array(
            'lista' => 'Lista',
            'bloco' => 'Blocos',
            'superior' => 'Filtro superior',
        );
    }


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página Estoque</h2>',
        'name' => 'Layout de exibição <br/>dos veículos',
        'desc' => '',
        'id' => 'layout_estoque',
        'type' => 'select',
        'default' => 'bloco',
        'options' => $menu_layout,
    ));


    $cmb_options->add_field(array(
        'name' => 'Total de veículos a serem exibidos',
        'desc' => '',
        'default' => '15',
        'id' => 'total_lista_estoque',
        'type' => 'text_small',
    ));

    $cmb_options->add_field(array(
        'name' => 'Ordenação <br/>padrão',
        'desc' => '',
        'id' => 'ordenaca_padrao',
        'type' => 'select',
        'default' => 'order_ano_asc ',
        'options' => array(
            'order_destaque_desc' => 'Ordenar por popularidade',
            'order_preco_desc' => 'Ordenar por preço: Maior para o menor',
            'order_preco_asc' => 'Ordenar por preço: Menor para o maior',
            'order_ano_desc' => 'Ordenar por ano: Maior para o menor',
            'order_ano_asc' => 'Ordenar por ano: Menor para o maior',
            'mais_recentes' => 'Ordenar por: Mais recentes',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Exibir tarjeta de veículos em <strong>Destaque</strong>',
        'desc' => '',
        'id' => 'tarjeta_destaque',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir tarjeta de veículos <strong>Repasse</strong>',
        'desc' => '',
        'id' => 'tarjeta_repasse',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    /*
    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Whatsapp</h2>',
        'name' => 'Mostrar Whatsapp na listagem de veículos',
        'desc' => '',
        'id' => 'mostrar_whatsapp',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Texto do botão',
        'desc' => 'Utilizar no máximo de 10 caracteres',
        'default' => 'Whatsapp',
        'id' => 'texto_do_botao',
        'type' => 'text',
        'attributes' => array(
            'maxlength' => '10',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Número do whatsapp',
        'desc' => 'Número do whatsapp padrão <strong>(Utilizar apenas números)</strong> exemplo 554788888888',
        'default' => '554788888888',
        'id' => 'numero_whatsapp',
        'type' => 'text',
    ));

    $cmb_options->add_field(array(
        'name' => 'Mensagem padrão do whatsapp',
        'desc' => '',
        'default' => 'Olá, Gostaria de mais informações',
        'id' => 'mensagem_whatsapp',
        'type' => 'text',
    ));
    */

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Widget veículos</h2>',
        'name' => 'Características dos veículos',
        'desc' => '',
        'id' => 'caracteristicas',
        'type' => 'multicheck',
        'default' => array('alt_kilometragem', 'alt_cambio', 'alt_ano_mod', 'alt_combustivel'),
        'options' => array(
            'alt_kilometragem' => 'Quilometragem',
            'alt_cambio' => 'Cambio',
            'alt_ano_mod' => 'Ano modelo',
            'alt_combustivel' => 'Combustível',
            'alt_marca' => 'Marca',
            'alt_modelo' => 'Modelo',
            'alt_modelo_complemento' => 'Modelo complemento',
            'alt_ano_fab' => 'Ano fabricação',
            'alt_cor' => 'Cor',
            'alt_portas' => 'Porta',
        ),
    ));
}


function get_caracteristas_widget()
{
    $dados = get_option('alt_group_listagem');
    return $dados['caracteristicas'];
}


function get_tarjeta_destaque()
{
    $dados = get_option('alt_group_listagem');
    return $dados['tarjeta_destaque'] == 'sim' ? true : false;
}

function get_tarjeta_repasse()
{
    $dados = get_option('alt_group_listagem');
    return $dados['tarjeta_repasse'] == 'sim' ? true : false;;
}

function get_layout_estoque()
{
    $dados = get_option('alt_group_listagem');
    $retorno = $dados['layout_estoque'];


    if (isset($_REQUEST['tipo_block'])) {
        $retorno = $_REQUEST['tipo_block'];
    }

    if (isset($_REQUEST['view'])) {
        $retorno = $_REQUEST['view'];
    }

    if(empty($retorno)){
        return 'block';
    }

    return $retorno;
}


function get_total_veiculo_no_estoque()
{

    $dados = get_option('alt_group_listagem');
    return $dados['total_lista_estoque'] ?? 12;
}

function get_ordenacao_padrao()
{
    $dados = get_option('alt_group_listagem');
    return $dados['ordenaca_padrao'] ?? 'order_destaque_desc';
}

