<?php

add_action('cmb2_admin_init', 'setup');


function setup()
{
    $versao = 1;


    $cmb_options = new_cmb2_box(array(
        'id' => 'alt_setup',
        'title' => 'Configurações do tema Altimus',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_setup', // The option key and admin menu page slug.
        'icon_url' => 'dashicons-palmtree', // Menu icon. Only applicable if 'parent_slug' is left empty.

    ));


    $btn_personal = '<a href="/wp-admin/admin-ajax.php?action=criar_paginas_default" class="button button-primary">IMPORTAR DADOS INICIAIS</a>';
    $btn_personal .= '<a href="/wp-admin/admin-ajax.php?action=fotos_nao_usadas" class="button button-danger" style="margin: 0px 0px 20px 20px;">LIMPAR FOTOS</a>';

    $cmb_options->add_field(array(
        'before_row' => $btn_personal,
        'name' => 'Logo',
        'desc' => 'Faça o upload da imagem ou informe a URL (Tamanho recomendado 153x43)',
        'id' => 'logo',
        'type' => 'file',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Fazer upload' // Change upload button text. Default: "Add or Upload File"
        ),
        'query_args' => array(
            'type' => array(
                // 	'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),

    ));


    $pages = get_pages();
    $arrPages = [];
    foreach ($pages as $page) {
        $arrPages[$page->post_title] = $page->post_title;
    };

    $cmb_options->add_field(array(
        'name' => 'Página padrão de estoque',
        'desc' => '',
        'id' => 'pagina_padrao_estoque',
        'type' => 'select',
        'default' => 'Estoque',
        'options' => $arrPages,
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir noticias na home',
        'desc' => '',
        'id' => 'exibir_noticias',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(

        'name' => 'Aviso LGPD',
        'desc' => 'Exibir modal LGPD - ATENÇÃO, ao ativar essa modal é necessário criar uma nova página chamada politica de privacidade<br/>O SLUG deve ser obrigatoriamente <strong>politica-de-privacidade</strong>',
        'id' => 'modal_lgpd',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Código GTM',
        'id' => 'codigo_gtm',
        'desc' => 'Lembre-se de cadastrar o cliente no GTM e configurar o Google Analytics<br/> e o relatório do cliente no Google Data Studio através do GTM',
        'type' => 'text',
        'default' => '',

    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Imagem padrão</h2>',
        'name' => 'Imagem padrão (Veículos)',
        'desc' => 'Imagem padrão para quando o veículo não tem foto',
        'id' => 'foto_padrao_veiculo',
        'type' => 'file',
        'default' => 'https://via.placeholder.com/350x265?text=Sem%20Foto',
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Fazer upload' // Change upload button text. Default: "Add or Upload File"
        ),
        'query_args' => array(
            'type' => array(
                // 	'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Depoimentos</h2>',
        'name' => 'Exibir depoimentos',
        'desc' => '',
        'id' => 'exibir_depoimentos',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Layout da sessão depoimentos',
        'desc' => '',
        'id' => 'layout_depoimentos',
        'type' => 'select',
        'default' => 'modelo-1',
        'options' => array(
            'modelo-1' => 'Modelo 1',
            'modelo-2' => 'Modelo 2',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Filtro</h2>',
        'name' => 'Exibir filtro na página inicial do site?',
        'desc' => '',
        'id' => 'exibir_filtro_home',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir opção de busca textual?',
        'desc' => '',
        'id' => 'exibir_filtro_busca_textual',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Carroceria</h2>',
        'name' => 'Deseja exibir o filtro por carroceria?',
        'desc' => 'Sedan, Esportivo, Hatch, etc',
        //'attributes' => ['onChange' => 'mostrarMarcas()'],
        'id' => 'filtro_por_carroceria',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Marcas</h2>',
        'name' => 'Mostrar marcas',
        'desc' => '',
        'id' => 'mostrar_marcas',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Deseja exibir somente marcas do estoque?',
        'desc' => '',
        'attributes' => ['onChange' => 'mostrarMarcas()'],
        'id' => 'mostrar_somente_estoque',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $group_field_id = $cmb_options->add_field(array(

        'id' => 'marcas_home',
        'type' => 'group',
        'description' => 'Marcas que serão exibidas na home (Tamanho recomendado 142x75) tamanhos fora dessa proporsão não serão exibidos corretamente.',

        'options' => array(
            'closed' => true,
            'group_title' => '{#}º Registro ', // since version 1.1.4, {#} gets replaced by row number
            'add_button' => 'Adicionar',
            'remove_button' => 'Remover',
            'remove_confirm' => 'Tem certeza que deseja remover esse registro?', // Performs confirmation before removing group.

        ),
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'Nome',
        'id' => 'nome',
        'description' => 'Esse campo será utilizado no ALT das imagens',
        'type' => 'text',
    ));
    $cmb_options->add_group_field($group_field_id, array(

        'name' => 'URL de destino',
        'id' => 'url_destino',
        'type' => 'text_url',
    ));
    $cmb_options->add_group_field($group_field_id, array(
        'name' => 'Imagem',
        'desc' => 'Faça o upload da imagem',
        'id' => 'imagem',
        'type' => 'file',

    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos em destaque (Home)</h2>',
        'name' => 'Exibir veiculos em destaque',
        'desc' => '',
        'id' => 'exibir_destaques',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Destaques',
        'desc' => 'Total de veículos em destaque na Home',
        'id' => 'total_veiculos_em_destaque',
        'type' => 'text',
        'default' => '6',
    ));

    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como destaque',
        'desc' => '',
        'id' => 'tipo_veiculo_destaque',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));
    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em destaque',
        'desc' => '',
        'id' => 'exibir_repasse_destaque',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página destaques',
        'desc' => 'Titulo da página destaques',
        'default' => '',
        'id' => 'destaques_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais recentes (Home)</h2>',
        'name' => 'Exibir veiculos mais recentes',
        'desc' => '',
        'id' => 'exibir_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'name' => 'Mais recentes',
        'desc' => 'Total de veículos mais recentes na Home',
        'id' => 'total_veiculos_mais_recentes',
        'type' => 'text',
        'default' => '6',
    ));
    $cmb_options->add_field(array(
        'name' => 'Tipo de veículo a ser exibido como mais recentes',
        'desc' => '',
        'id' => 'tipo_veiculo_recentes',
        'type' => 'select',
        'default' => 'todos',
        'options' => listaTipos(),
    ));

    $cmb_options->add_field(array(
        'name' => 'Exibir repasses em veículos mais recentes',
        'desc' => '',
        'id' => 'exibir_repasse_mais_recentes',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais recentes',
        'desc' => 'Titulo da página mais recentes',
        'default' => '',
        'id' => 'mais_recentes_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Sessão - Veículos mais procurados (Home)</h2>',
        'name' => 'Exibir veículos mais procurados',
        'desc' => '',
        'id' => 'exibir_mais_procurados',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));
    $cmb_options->add_field(array(
        'name' => 'Total de veículos mais procurados',
        'desc' => '',
        'id' => 'total_veiculos_mais_procurados',
        'type' => 'text',
        'default' => '3',
    ));
    $cmb_options->add_field(array(
        'name' => 'Titulo da página mais procurados',
        'desc' => 'Titulo da página mais procurados',
        'default' => '',
        'id' => 'mais_procurados_titulo',
        'type' => 'textarea_small',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Apresentação de titulo dos veículos</h2>',
        'name' => 'Mostrar titulo personalizado',
        'desc' => '',
        'id' => 'titulo_personalizado',
        'type' => 'select',
        'default' => 'nao',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(

        'name' => 'Formação do titulo personalizado dos veículos',
        'desc' => '',
        'id' => 'titulo',
        'type' => 'multicheck',
        'default' => array('marca', 'modelo', 'modelo_complemento', 'ano_fabricacao'),
        'options' => array(
            'marca' => 'Marca',
            'modelo' => 'Modelo',
            'modelo_complemento' => 'Modelo complemento',
            'ano_fabricacao' => 'Ano fabricação',
            'ano_modelo' => 'Ano modelo',
            'cor' => 'Cor',
            'porta' => 'Porta',
            'cambio' => 'Cambio',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Página de notícias</h2>',
        'name' => 'Importar noticias automaticamente?',
        'id' => 'importar_noticias',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Relatório de performance</h2>',
        'name' => 'Emitir automaticamente relatório de performance?',
        'id' => 'emitir_relatorio_performance',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));

    $cmb_options->add_field(array(
        'name' => 'Para qual e-mail o relatório de performance deve ser enviado?',
        'desc' => '',
        'id' => 'email_relatorio_performance',
        'type' => 'text',
        'default' => '',
    ));


    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Formatar placa</h2>',
        'name' => 'Formatar placa',
        'desc' => 'Usar * para ocultar caracteres. Ex: A**-***A',
        'id' => 'formatar_placa',
        'type' => 'text',
        'default' => 'A**-***A',
    ));

    $cmb_options->add_field(array(
        'before_row' => '<br/><h2>Barra de rolagem</h2>',
        'name' => 'Exibir icone top page?',
        'desc' => 'Icone que fica no campo esquerdo responsável por rolar a tela para o topo novamente quando clicado.',
        'id' => 'barra_rolagem',
        'type' => 'select',
        'default' => 'sim',
        'options' => array(
            'sim' => 'Sim',
            'nao' => 'Não',
        ),
    ));


    //Init plugin


    $values = get_option('alt_group_setup');

    if (isset($values['marcas_home'])) {
        if (count($values['marcas_home']) == 0) {

            if (empty($values['marcas_home'][0]['nome'])) {
                $values['marcas_home'] = alt_lista_marcas_padrao();
                update_option('alt_group_setup', $values);
            }
        };


    }

}

function get_layout_totalizadores()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['layout_totalizadores'])) {
        return $dados['layout_totalizadores'];
    }
    return 'default';
}

function get_exibir_titulo_personalizado()
{
    $dados = get_option('alt_group_setup');
    return $dados['titulo_personalizado'] == 'sim' ? true : false;

}

function get_titulo_destaques()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['destaques_titulo'])) {
        return $dados['destaques_titulo'];
    }
    return null;
}

function get_titulo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_recentes_titulo'])) {
        return $dados['mais_recentes_titulo'];
    }
    return null;
}

function get_titulo_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    if (!empty($dados['mais_procurados_titulo'])) {
        return $dados['mais_procurados_titulo'];
    }
    return null;
}


function get_todas_marcas()
{


    $dados = get_option('alt_group_setup');


    if ($dados['mostrar_somente_estoque'] == 'sim') {
        return get_marcas_do_estoque_com_veiculo();
    }

    return $dados['marcas_home'];
}

function get_marcas_do_estoque_com_veiculo()
{

    $categories = get_terms([
        'taxonomy' => 'marca',
        'hide_empty' => true,
        'orderby' => 'count',
        'order' => 'DESC'
    ]);
    $arrRetorno = [];
    foreach ($categories as $key => $categoria) {


        $info['url_destino'] = alt_get_url_estoque() . '?marca=' . $categoria->slug;
        $info['imagem'] = get_term_meta($categoria->term_id, 'marca_img', true);
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;

        if (empty($info['imagem'])) {
            continue;
        }


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;


}


function get_show_barra_rolagem()
{
    $dados = get_option('alt_group_setup');
    return $dados['barra_rolagem'] == 'sim' ? true : false;
}

function get_importar_noticias()
{
    $dados = get_option('alt_group_setup');
    return $dados['importar_noticias'] == 'sim' ? true : false;
}


function get_formatar_placa()
{
    $dados = get_option('alt_group_setup');
    return $dados['formatar_placa'];
}


function get_formacao_titulo()
{
    $dados = get_option('alt_group_setup');
    return $dados['titulo'];
}

function buscarFormularios($form_id = null)
{

    $args = array('post_type' => 'wpcf7_contact_form', 'posts_per_page' => -1);
    $cf7Forms = get_posts($args);
    $arrIds = wp_list_pluck($cf7Forms, 'ID');
    $arrTitulos = wp_list_pluck($cf7Forms, 'post_title');
    $arrDados[0] = 'Inativo';

    foreach ($arrIds as $index => $ids) {
        $arrDados[$ids] = $arrTitulos[$index];
    }

    return $arrDados;
}

function listaTipos()
{


    $arrTermos = get_terms('tipo');

    $arrRet = [];

    $arrRet['todos'] = 'Todos';
    foreach ($arrTermos as $termos) {
        $arrRet[$termos->slug] = $termos->name;
    }
    return $arrRet;
}

function get_mostrar_ultimas_noticias()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_noticias'] == 'sim' ? true : false;
}

function get_layout_depoimentos()
{

    $dados = get_option('alt_group_setup');
    $modelo = $dados['layout_depoimentos'];
    if (empty($modelo)) {
        return 'modelo-1';
    }
    return $modelo;
}

if (!function_exists('formato_visualizacao')) {
    function formato_visualizacao()
    {

        $dados = get_option('alt_group_setup');


        if ($dados['formato_visualizacao'] == 'wide') {
            return 'container-fluid';
        }

        return 'container';
    }

}

function get_mostrar_depoimentos()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_depoimentos'] == 'sim' ? true : false;
}

function get_mostrar_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_procurados'] == 'sim' ? true : false;
}

function get_mostrar_total_veiculos_mais_procurados()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_mais_procurados'];
}


function get_mostrar_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_destaques'] == 'sim' ? true : false;
}

function get_total_veiculos_destaque()
{
    $dados = get_option('alt_group_setup');
    return $dados['total_veiculos_em_destaque'];
}

function get_exibir_repasse_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_destaque'];
}

function get_exibir_repasse_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_repasse_mais_recentes'];
}

function get_tipo_veiculo_destaques()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_destaque'];
}

function get_tipo_veiculo_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['tipo_veiculo_recentes'];
}

function get_mostrar_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');
    return $dados['exibir_mais_recentes'] == 'sim' ? true : false;
}


function mostrar_icones_sociais_header()
{
    $dados = get_option('alt_group_midias_sociais');
    return $dados['exibir_social_cabecalho'] == 'sim' ? true : false;
}

function mostrar_icones_sociais_footer()
{
    $dados = get_option('alt_group_midias_sociais');
    return $dados['exibir_social_rodape'] == 'sim' ? true : false;
}

function get_total_veiculos_mais_recentes()
{
    $dados = get_option('alt_group_setup');

    return $dados['total_veiculos_mais_recentes'];
}

add_shortcode('alt_short_code_logo', 'alt_short_code_logo');

function alt_get_url_logo()
{
    $arrOptions = get_option('alt_group_setup');
    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
    } else {
        $url = $arrOptions['logo'];
    }

    return $url;
}

function alt_short_code_logo($size = null)
{

    $arrOptions = get_option('alt_group_setup');

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        echo '<img alt="logo da empresa" src="' . $url . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    } else {
        echo '<img alt="logo da empresa"  src="' . $arrOptions['logo'] . '" class="logo-header img-responsive" alt="Logo da loja" ' . $size . '/>';
    }
}

function alt_url_logo()
{
    $arrOptions = get_option('alt_group_setup');

    if (empty($arrOptions['logo'])) {
        $url = get_template_directory_uri() . '/assets/images/logo.png';
        return $url;
    }

    return $arrOptions['logo'];
}

function get_mostrar_totalizadores()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_totalizadores'] == 'sim' ? true : false;
}

function get_totalizadores()
{
    $dados = get_option('alt_group_setup');


    $arr['titulo_sessao_totalizadores'] = $dados['titulo_sessao_totalizadores'] ?? null;
    $arr['experiencia'] = $dados['anos_experiencia'] ?? null;
    $arr['total_veiculos'] = $dados['total_veiculos'] ?? null;
    $arr['total_ofertas'] = $dados['total_ofertas'] ?? null;
    $arr['total_clientes'] = $dados['total_clientes'] ?? null;

    return $arr;
}

function get_mostrar_carroceria()
{
    $dados = get_option('alt_group_setup');
    return $dados['filtro_por_carroceria'] == 'sim' ? true : false;
}

function get_listar_carrocerias()
{
    $categories = get_terms(['taxonomy' => 'carroceria', 'hide_empty' => false, 'orderby' => 'count', 'order' => 'DESC']);
    $arrRetorno = [];


    $total = 0;
    foreach ($categories as $key => $categoria) {

        $total++;
        if ($total > 6) {
            continue;
        }
        $img = get_term_meta($categoria->term_id, 'carroceria_img', true);

        if (empty($img)) {
            continue;
        }

        $info['slug'] = $categoria->slug;
        $info['imagem'] = $img;
        $info['nome'] = $categoria->name;
        $info['total'] = $categoria->count;
        $info['slug'] = $categoria->slug;


        $arrRetorno[$key] = $info;
    }


    return $arrRetorno;
}


function get_mostrar_marcas()
{
    $dados = get_option('alt_group_setup');
    return $dados['mostrar_marcas'] == 'sim' ? true : false;
}


function get_show_filtro_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_home'])) {
        return true;
    }
    return $dados['exibir_filtro_home'] == 'sim' ? true : false;
}

function get_show_textual_busca_home()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['exibir_filtro_busca_textual'])) {
        return true;
    }
    return $dados['exibir_filtro_busca_textual'] == 'sim' ? true : false;
}


function get_modal_lgpd()
{

    $dados = get_option('alt_group_setup');

    if (!isset($dados['modal_lgpd'])) {
        return true;
    }
    return $dados['modal_lgpd'] == 'sim' ? true : false;
}

function get_imagem_padrao_veiculo_id()
{

    $dados = get_option('alt_group_setup');
    if (!isset($dados['foto_padrao_veiculo'])) {
        return true;
    }

    return $dados['foto_padrao_veiculo_id'];
}

function get_imagem_padrao_veiculo()
{

    $dados = get_option('alt_group_setup');
    if (!isset($dados['foto_padrao_veiculo'])) {
        return true;
    }


    return $dados['foto_padrao_veiculo'];
}

function get_pagina_padrao_estoque()
{

    $dados = get_option('alt_group_setup');

    if (!isset($dados['pagina_padrao_estoque'])) {
        return 'estoque';
    }
    return $dados['pagina_padrao_estoque'];

}

function get_emitir_relatorio_performance()
{
    $dados = get_option('alt_group_setup');

    if (!isset($dados['emitir_relatorio_performance'])) {
        return true;
    }
    return $dados['emitir_relatorio_performance'] == 'sim' ? true : false;
}

function get_email_relatorio_performance()
{

    $dados = get_option('alt_group_setup');
    return $dados['email_relatorio_performance'];

}

function hook_javascript()
{
    ?>
    <script>
        alert('Page is loading...');
    </script>
    <?php
}

add_action('wp_head', 'alt_tag_google');
add_action('after_body_open_tag', 'alt_tag_google_body');
function alt_tag_google()
{

    if (VERSION_PLUGIN_ALTIMUS <= 2021090) {
        return;
    }

    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (empty($gtm)) {
        return;
    }
    echo "<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','" . $gtm . "');</script>
<!-- End Google Tag Manager -->";

}

add_action('admin_notices', 'mensagem_de_erro_gtm');
function mensagem_de_erro_gtm()
{
    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (VERSION_PLUGIN_ALTIMUS <= 2021090) {
        return;
    }

    if (empty($gtm)) {
        $class = 'notice notice-error';
        $message = 'Código GTM Não foi configurado, ele é obrigatório para a emissão de relatórios de performance.';
        printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
    }

}

function alt_tag_google_body()
{
    $dados = get_option('alt_group_setup');
    $gtm = $dados['codigo_gtm'] ?? null;

    if (VERSION_PLUGIN_ALTIMUS <= 2021090) {
        return;
    }

    if (empty($gtm)) {
        return;
    }

    echo "<!-- Google Tag Manager (noscript) -->
<noscript><iframe src=\"https://www.googletagmanager.com/ns.html?id=" . $gtm . "\"
height=\"0\" width=\"0\" style=\"display:none;visibility:hidden\"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->";
}
