<?php


//Preparar relatório do site


//Calcular todos os acesso
if (!function_exists('set_total_acessos_site')) {
    function set_total_acessos_site()
    {
        $numero_acesso = (int)get_option('alt_view_page') ?? 0;
        $numero_acesso = $numero_acesso + 1;
        update_option('alt_view_page', $numero_acesso);
    }

    add_filter('wp_head', 'set_total_acessos_site');

}


//Calcular todos os leads recebidos
if (!function_exists('set_total_leads')) {
    function set_total_leads()
    {
        $total_leads = (int)get_option('alt_count_leads') ?? 0;
        $total_leads = $total_leads + 1;
        update_option('alt_count_leads', $total_leads);
    }

    add_action('set_total_leads', 'set_total_leads');
    add_filter('wpcf7_before_send_mail', 'set_total_leads');
}


//Calcular todos os clicks em whatsapp
if (!function_exists('set_click_whatsapp')) {
    function set_click_whatsapp()
    {
        $total_leads = (int)get_option('alt_count_leads_whatsapp') ?? 0;
        $total_leads = $total_leads + 1;
        update_option('alt_count_leads_whatsapp', $total_leads);
    }

    add_action('set_click_whatsapp', 'set_click_whatsapp');
}


if (!function_exists('alt_relatorio_performance')) {
    function alt_relatorio_performance()
    {
        do_action('alt_relatorio_performance_send');
    }

    add_action('alt_relatorio_performance', 'alt_relatorio_performance');

}

if (!function_exists('alt_relatorio_performance_send')) {
    function alt_relatorio_performance_send()
    {

        try {
            $dados['pageview'] = get_option('alt_view_page') ?? 0;
            $dados['email'] = get_option('alt_count_leads') ?? 0;
            $dados['whatsapp'] = get_option('alt_count_leads_whatsapp') ?? 0;
            $email_destinatario = get_email_relatorio_performance();

            if (empty($dados['pageview'])) {
                throw new Exception('Nenhum registro para ser processado.');
            }

            if(empty($email_destinatario)){
                throw new Exception('Não existe um email de destinatário configurado.');
            }

            //Enviar email com os dados do cliente
            include 'email-template.php';

            $headers[] = 'From: Me Myself <me@example.net>';
            $headers[] = 'Content-Type: text/html; charset=UTF-8';
            $enviado = wp_mail('felipe.silva@altimus.com.br', 'Relatório de desempenho', $html_template, $headers);


            update_option('alt_view_page', 0);
            update_option('alt_count_leads', 0);
            update_option('alt_count_leads_whatsapp', 0);

            wp_die('Registro enviado para ' . $email_destinatario);

        } catch (Exception $e) {

            error_log($e->getMessage(), 0);

            wp_die($e->getMessage());
        }


    }

    add_action('wp_mail_failed', function ($error) {
        wp_die("<pre>" . print_r($error, true) . "</pre>");
    });

    add_action('alt_relatorio_performance_send', 'alt_relatorio_performance_send');


    add_action('rest_api_init', function () {
        register_rest_route('altimus/v1', 'relatorio', array(
                'methods' => 'GET',
                'callback' => 'alt_relatorio_performance_send',
            )
        );
    }
    );
}
