<?php
add_action('alt_cron_noticias', 'alt_importar_noticias_cron');
//do_action('alt_cron_noticias'); //ativar o cron para debug
function alt_importar_noticias_cron()
{

    require_once(ABSPATH . "wp-includes/pluggable.php");


    $arrNoticias = importar_noticias_curl();


    $user_id = get_current_user_id();


    foreach ($arrNoticias as $noticia) {

        try {
            //VERIFICAR SE NOTICIA JÁ EXISTE
            $the_slug = $noticia['slug'];
            $args = array(
                'name' => $the_slug,
                'post_type' => 'post'
            );
            $my_posts = get_posts($args);
            if ($my_posts) {
                continue;
            }


            $my_post = array(
                'post_title' => $noticia['title'],
                'post_content' => html_entity_decode(json_decode($noticia['conteudo'])),
                'post_status' => 'publish',
                'post_name' => $the_slug,
                'post_author' => 1,
                'post_date' => date('Y-m-d')//$noticia['data']

            );


            $post_id = wp_insert_post($my_post);


            $attach_id = alt_insert_attachment_from_url($noticia['imagem'], $post_id);

            $url_imagem = $noticia['imagem'];
            /*
            $data_url = parse_url($url_imagem);
            $arrNameUrl = explode('/', $data_url['path']);
            $name_file = array_pop($arrNameUrl);
            $file = wp_upload_bits(sanitize_file_name($name_file), null, file_get_contents($url_imagem));
            $attachment = array(
                'guid' => $file['url'],
                'post_mime_type' => $file['type'],
                'post_title' => sanitize_file_name($name_file),
                'post_content' => '',
                'post_status' => 'inherit'
            );
            $attach_id = wp_insert_attachment($attachment, $file['file'], $post_id);
            require_once(ABSPATH . 'wp-admin/includes/image.php');
            $attach_data = wp_generate_attachment_metadata($attach_id, $file['file']);
            wp_update_attachment_metadata($attach_id, $attach_data);

            */
            set_post_thumbnail($post_id, $attach_id);

            if (!empty($noticia['categorias'])) {
                $arrCategoriasPost = explode(',', $noticia['categorias']);


                $cat_id = [];
                foreach ($arrCategoriasPost as $cat_name):

                    $taxonomy = 'category';
                    $cat_name = trim($cat_name);
                    $cat = term_exists($cat_name, $taxonomy);


                    if (empty($cat)) {
                        $cat = wp_insert_term($cat_name, $taxonomy);
                        $cat_id[] = $cat['term_id'];
                    } else {
                        $cat_id[] = $cat['term_id'];
                    }


                endforeach;

                if (!empty($cat_id)) {
                    wp_set_post_terms($post_id, $cat_id, $taxonomy);
                }

            }
        } catch (Exception $e) {

            die($e->getMessage());
        }


    }


}


function importar_noticias_curl()
{

    try {
        $url = 'http://cms-site.altimus.com.br/conteudos/show.json';
        include_once(ABSPATH . WPINC . '/class-http.php');
        $request = new WP_Http;
        $data = $request->get($url);
        $conteudo = json_decode($data['body'], true);
        return $conteudo['conteudo'];
    } catch (Exception $e) {

        return [];
    }


}
