<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
if (!function_exists('alt_filiais')) {
    function alt_filiais()
    {
        $args_cursos_post_type = array(
            'labels' => array(
                'name' => 'Filiais/Matriz',
                'add_new' => 'Adicionar nova filial',
                'add_new_item' => 'Titulo da filial',
                'edit_item' => 'Titulo da filial'
            ),
            'public' => true,
            'menu_icon' => 'dashicons-store',
            'supports' => array('title'),
            //'register_meta_box_cb' => ''
        );
        register_post_type('filiais', $args_cursos_post_type);
    }
    
    add_action('init', 'alt_filiais');
}


function alt_filiais_posts_column_views($columns)
{
    $columns['post_matriz'] = 'Matriz';
    return $columns;
}

function alt_filiais_posts_custom_column_views($column)
{

    if ($column === 'post_matriz') {

        $count = get_post_meta(get_the_ID(), 'alt_matriz', true);
        echo $count == 'on' ? '<strong>Sim</strong>' : 'Não';
    }
}

add_action('manage_filiais_posts_custom_column', 'alt_filiais_posts_custom_column_views');
add_filter('manage_filiais_posts_columns', 'alt_filiais_posts_column_views');
