<?php
require_once plugin_dir_path(__FILE__) . 'metabox/metabox_filiais.php';

function alt_filiais()
{
    $args_cursos_post_type = array(
        'labels' => array(
            'name' => 'Filiais/Matriz',
            'add_new' => 'Adicionar nova filial',
            'add_new_item' => 'Titulo da filial',
            'edit_item' => 'Titulo da filial'
        ),
        'public' => true,
        'menu_icon' => 'dashicons-store',
        'supports' => array('title'),
        //'register_meta_box_cb' => ''
    );
    register_post_type('filiais', $args_cursos_post_type);
}

add_action('init', 'alt_filiais');


add_shortcode('shortcode_filiais', 'shortcode_filiais');


function formatarNumero($TEL)
{
    $tam = strlen(preg_replace("/[^0-9]/", "", $TEL));
    if ($tam == 13) { // COM CÓDIGO DE ÁREA NACIONAL E DO PAIS e 9 dígitos
        return "+" . substr($TEL, 0, $tam - 11) . "(" . substr($TEL, $tam - 11, 2) . ")" . substr($TEL, $tam - 9, 5) . "-" . substr($TEL, -4);
    }
    if ($tam == 12) { // COM CÓDIGO DE ÁREA NACIONAL E DO PAIS
        return "+" . substr($TEL, 0, $tam - 10) . "(" . substr($TEL, $tam - 10, 2) . ")" . substr($TEL, $tam - 8, 4) . "-" . substr($TEL, -4);
    }
    if ($tam == 11) { // COM CÓDIGO DE ÁREA NACIONAL e 9 dígitos
        return "(" . substr($TEL, 0, 2) . ")" . substr($TEL, 2, 5) . "-" . substr($TEL, 7, 11);
    }
    if ($tam == 10) { // COM CÓDIGO DE ÁREA NACIONAL
        return "(" . substr($TEL, 0, 2) . ")" . substr($TEL, 2, 4) . "-" . substr($TEL, 6, 10);
    }
    if ($tam <= 9) { // SEM CÓDIGO DE ÁREA
        return substr($TEL, 0, $tam - 4) . "-" . substr($TEL, -4);
    }
}

function gerarLink($valor, $tipo)
{

    if (empty($valor)) {
        return null;
    }

    $url = '#';
    if ($tipo == 'telefone') {
        $url = 'tel:' . $valor;
    }

    if ($tipo == 'email') {
        $url = 'mailto:' . $valor;
    }

    if ($tipo == 'whatsapp') {
        $iphone = strpos($_SERVER['HTTP_USER_AGENT'], "iPhone");
        $android = strpos($_SERVER['HTTP_USER_AGENT'], "Android");
        $palmpre = strpos($_SERVER['HTTP_USER_AGENT'], "webOS");
        $berry = strpos($_SERVER['HTTP_USER_AGENT'], "BlackBerry");
        $ipod = strpos($_SERVER['HTTP_USER_AGENT'], "iPod");
        $url = 'https://api.whatsapp.com/send?phone=55' . $valor;

    }


    return $url;


}

function formatarDados($arrEntrada)
{


    $tipo = $arrEntrada['tipo'];
    $valor = $arrEntrada['valor'];
    $descricao = $arrEntrada['descricao'] ?? null;

    $arrTelefone = $arrEntrada;
    $arrTelefone['numero'] = formatarNumero($valor);
    $arrTelefone['link'] = gerarLink($valor, $tipo);
    $arrTelefone['descricao'] = !empty($descricao) ? ' - ' . $descricao : null;


    return $arrTelefone;
}

function shortcode_filiais($arrtr)
{


    $tipo = isset($arrtr['tipo']) ? $arrtr['tipo'] : 'footer';


    global $post;
    ob_start();
// WP Query Parameters
    $args = array(
        'post_type' => 'filiais',
        'post_status' => array('publish'),
        'orderBy' => 'date',
        'order' => 'asc'
    );

    $query = new WP_Query($args);
    $post_count = $query->post_count;
    if ($post_count <= 2) {
        $size = '6';
    };

    if ($post_count >= 3) {
        $size = '3';
    };


    if ($query->have_posts()) :

        while ($query->have_posts()) : $query->the_post();
            $endereco = get_post_meta(get_the_ID(), 'alt_filiais_endereco', true) ?? null;
            $email = get_post_meta(get_the_ID(), 'alt_filiais_email', true) ?? null;
            $arrTelefones = get_post_meta(get_the_ID(), 'alt_filial_contatos', true) ?? null;
            $mapa = get_post_meta(get_the_ID(), 'alt_filial_mapa', true) ?? null;
            if ($tipo == 'footer') {
                include('template/filial_tipo_footer.php');
            }
            if ($tipo == 'contato') {
                include('template/filial_tipo_contato.php');
            }


            ?>

        <?php
        endwhile;
    endif;

}


function alt_filiais_posts_column_views($columns)
{
    $columns['post_matriz'] = 'Matriz';
    return $columns;
}

function alt_filiais_posts_custom_column_views($column)
{

    if ($column === 'post_matriz') {

        $count = get_post_meta(get_the_ID(), 'alt_matriz', true);
        echo $count == 'on' ? '<strong>Sim</strong>' : 'Não';
    }
}

add_action('manage_filiais_posts_custom_column', 'alt_filiais_posts_custom_column_views');
add_filter('manage_filiais_posts_columns', 'alt_filiais_posts_column_views');