<?php

add_action('wp_ajax_nopriv_verificarVersao', 'verificarVersao');
add_action('wp_ajax_verificarVersao', 'verificarVersao');

/**
 * Verficar a versão atual do site
 */
function verificarVersao()
{
    global $wp_version;

    $filter = [];

    if (!empty($_GET['marca'])) {
        $filter[] = array(
            'taxonomy' => 'marca',
            'field' => 'slug',
            'terms' => $_GET['marca'],
        );
    }

    $dir = plugin_dir_path( __FILE__ );
    $objPlugin = get_plugin_data( $dir . './../altimus.php' , false, false );



    $objTheme = wp_get_theme();
    $ultima_atualizacao = 'Nao definido';
    if (get_option('ultima_atualizacao_theme')) {
        $ultima_atualizacao = get_option('ultima_atualizacao_theme');
    }


    $arrReturn['versao'] = $objTheme->get('Version');
    $arrReturn['versao_theme'] = $objTheme->get('Version');
    $arrReturn['versao_plugin'] = $objPlugin['Version'];
    $arrReturn['versao_wordpress'] = $wp_version;
    $arrReturn['data_atualizacao'] = $ultima_atualizacao;
    $arrReturn['info'] = [];

    echo json_encode($arrReturn);
    die;

}

/**
 * Registrar data de atualização do tema
 */
add_action('after_setup_theme', 'registrar_data_de_atualizacao');
function registrar_data_de_atualizacao()
{

    $current_version = wp_get_theme()->get('Version');
    $old_version = get_option('versao_do_thema');
    if ($old_version !== $current_version) {
        update_option('versao_do_thema', $current_version);
        update_option('ultima_atualizacao_theme', date('Y-m-d H:i:s'));
    }
}