<?php
/*
  Name: Altimus
  Plugin Name: Altimus
  Plugin URI: http://manutencaosites.windi.com.br/plugin/v2/plugin.json
  Description: Plugin de integração com o sistema Altimus
  Author: Felipe Oliveira
  Version: 2022.03.14.0
  Author URI: http://www.altimus.com.br/
  Text Domain: altimus
 */
define('MY_PLUGIN_PATH', plugin_dir_path(__FILE__));

if (!function_exists('get_plugin_data')) {
    require_once(ABSPATH . 'wp-admin/includes/plugin.php');
    $plugin_data = get_plugin_data(__FILE__);
    $plugin_version = $plugin_data['Version'];


    $versao = intval(str_replace('.', '', $plugin_version));

    define('VERSION_PLUGIN_ALTIMUS', $versao);
}


//Customização
require_once 'inc/setup.php';

register_activation_hook(__FILE__, 'create_database_lead');

function alt_mailtrap($phpmailer)
{
    $phpmailer->isSMTP();
    $phpmailer->Host = 'smtp.mailtrap.io';
    $phpmailer->SMTPAuth = true;
    $phpmailer->Port = 2525;
    $phpmailer->Username = 'bc74cf83536fbc';
    $phpmailer->Password = '2690ebf02e5427';
}

if (in_array($_SERVER['REMOTE_ADDR'], array('127.0.0.1', '::1'))) {
    add_action('phpmailer_init', 'alt_mailtrap');
}


function auto_update_specific_plugins($update, $item)
{
    // Array of plugin slugs to always auto-update
    $plugins = array(
        'altimus'
    );

    if (in_array($item->slug, $plugins)) {
        return true;
    } else {
        return $update;
    }
}

function auto_update_specific_theme($update, $item)
{


    // Array of plugin slugs to always auto-update
    $themes = array(
        'altimus',
        'altimus2',
        'altimus3',
        'altimus4'
    );

    if (in_array($item->slug, $themes)) {
        return true;
    } else {
        return $update;
    }
}

/**
 * Atualizar automaticamente tema e plugin
 */
add_filter('auto_update_theme', 'auto_update_specific_theme', 10, 2);
add_filter('auto_update_plugin', 'auto_update_specific_plugins', 10, 2);


//Importar dados iniciais
require_once 'inc/import/ImportarXml.php';

require_once 'inc/schema.php';

require_once 'inc/seguranca.php';

require_once 'inc/api.php';


require_once 'inc/submit.php';

require_once 'inc/imagensResize.php';

require_once 'inc/report/report.php';

//Alteraçãos no woocommercea
/**
 * Desativado a integração com WC
 */
//require_once 'inc/woocommerce.php';
require_once 'inc/util.php';
require_once 'inc/setup/database.php';


require_once 'inc/taxonomy.php';
require_once 'inc/sidebar.php';
require_once 'inc/cronjobs.php';
require_once 'inc/shortcodes.php';
require_once 'inc/widget.php';

//TYPE POSTS
require_once 'inc/custom-post/depoimentos.php';
//require_once 'inc/custom-post/banners.php';
require_once 'inc/custom-post/banners/banners.php';
require_once 'inc/custom-post/filiais/filiais.php';
require_once 'inc/custom-post/galeria.php';
require_once 'inc/custom-post/time.php';
require_once 'inc/custom-post/veiculos.php';
require_once 'inc/custom-post/popups.php';
/**
 * Ativar cronjob de importação de conteúdo
 */
require_once 'inc/tgm.php';


/**
 * Criação da LP
 */


register_activation_hook(__FILE__, 'ativar_importacao_blog');


add_action('admin_menu', 'remove_menu_custom');


function remove_menu_custom()
{
    //remove_menu_page('edit-comments.php');
    //remove_menu_page('edit.php?post_type=page');
    //remove_menu_page('edit.php');
    //remove_menu_page('upload.php');

}


add_filter('sidebar_widget_footer', 'footer_widgets');

/* Register our callback function */
function footer_widgets($params)
{

    return $params;
}


/**
 * Habilitar do_shorcode in Widget HTML
 */
add_filter('widget_custom_html_content', 'do_shortcode');


/**
 * VERIFICAR SE PRECISA DE ATUALIZAÇÃO
 */


require 'plugin-update-checker/plugin-update-checker.php';

$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'http://manutencaosites.windi.com.br/plugin/v2/plugin.json',
    __FILE__, //Full path to the main plugin file or functions.php.
    'altimus'
);


/**
 * DISABILITAR O GUTTEMBERBE
 */

if (!function_exists('alt_disable_gutenberg')) {
    function alt_disable_gutenberg()
    {

        global $wp_filter;

        $callbacks_array = $wp_filter['init']->callbacks;

        foreach ($wp_filter as $tag => $priorities) {
            foreach ($priorities->callbacks as $priority => $callback_data) {
                foreach ($callback_data as $callback_function_name => $callback_function_data) {

                    if (strpos($callback_function_name, 'disable_gutenberg') !== false) {
                        continue;
                    }

                    // Gutenberg disabler
                    if (strpos($callback_function_name, 'gutenberg') !== false || strpos($callback_function_name, 'block_editor')) {

                        remove_filter($tag, $callback_function_name, $priority);

                    }

                }
            }
        }

        $wp_filter['init']->callbacks = $callbacks_array;

        add_filter('use_block_editor_for_post_type', '__return_false');
    }
}
add_action('admin_init', 'alt_disable_gutenberg');


add_action('admin_bar_menu', 'toolbar_link_to_mypage', 999);
function toolbar_link_to_mypage($wp_admin_bar)
{


    $args0 = array(
        'id' => 'alt_menu_altimus',     // id of the existing child node (New > Post)
        'title' => 'Configurações Altimus', // alter the title of existing node
        'parent' => false,          // set parent to false to make it a top level (parent) node
    );

    $args1 = array(
        'id' => 'alt_setup',     // id of the existing child node (New > Post)
        'title' => 'Configurações gerais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args2 = array(
        'id' => 'alt_cores',     // id of the existing child node (New > Post)
        'title' => 'Configurações de cores', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_cores',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args3 = array(
        'id' => 'alt_header',     // id of the existing child node (New > Post)
        'title' => 'Configurações Header', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_contato_header',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args4 = array(
        'id' => 'alt_midias',     // id of the existing child node (New > Post)
        'title' => 'Configurações Mídias sociais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_midias_sociais',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args5 = array(
        'id' => 'alt_listagem',     // id of the existing child node (New > Post)
        'title' => 'Configurações listagem (Estoque)', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_listagem',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args6 = array(
        'id' => 'alt_detalhes',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configurações detalhes do veículo', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup_detalhes',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );


    $args7 = array(
        'id' => 'alt_contatos',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configurações WhatsApp', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_contato_header',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $wp_admin_bar->add_node($args0);
    $wp_admin_bar->add_node($args1);
    $wp_admin_bar->add_node($args2);
    $wp_admin_bar->add_node($args3);
    $wp_admin_bar->add_node($args4);
    $wp_admin_bar->add_node($args5);
    $wp_admin_bar->add_node($args6);
    $wp_admin_bar->add_node($args7);
}


//Removes the meta tag generator name and version that generated with the wp_head()function.
remove_action('wp_head', 'wp_generator');


add_filter('wpcf7_spam', '__return_false');

/**
 * Alterar titulo
 */
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (!is_plugin_active('wordpress-seo/wp-seo.php')) {

    add_filter('document_title_parts', 'alt_change_document_title_parts', 1, 1);
    add_action('wp_head', 'alt_set_description', 1);

    function alt_set_description()
    {

        $arrInfo = get_info_principal(true);
        $descricao = "A melhor revenda de veículos em " . $arrInfo['cidade'];
        $descricao .= " Encontre os melhores veículos perto de você. Diversas marcas e modelos, acesse nosso estoque";

        echo '<meta name="description" content="' . $descricao . '"/>';
    }

    function alt_change_document_title_parts($title_parts)
    {

        $arrInfo = get_info_principal(true);
        $titulo = $arrInfo['nome_fantasia'];
        $subTitulo = $arrInfo['cidade'] . ' - ' . $arrInfo['estado'];


        if (is_front_page()) {
            $title_parts['tagline'] = $subTitulo;
            $title_parts['title'] = $titulo;
        } else {
            $title_parts['site'] = $titulo;
            $title_parts['tagline'] = $subTitulo;
        }
        return $title_parts;
    }


}

require_once 'inc/lgpd.php';
require_once 'inc/lp/index.php';


