<?php


//Buscar imagens dos veículos
if (!function_exists('buscar_imagem_placeholder')) {
    function buscar_imagem_placeholder($size)
    {


        $dimensions = wc_get_image_size($size);
        $placeholder_image = get_option('woocommerce_placeholder_image', 0);

        if (wp_attachment_is_image($placeholder_image)) {

            $image_html = wp_get_attachment_image(
                $placeholder_image,
                $size,
                false,
                array(
                    'alt' => __('Placeholder', 'woocommerce'),
                    'class' => 'woocommerce-placeholder wp-post-image img-responsive',
                )
            );
        } else {


            $tamanhos = wp_get_additional_image_sizes();

            if (!is_array($size)) {
                $encontrado = array_key_exists($size, $tamanhos);
            }


            if ($encontrado) {
                $dimensions = $tamanhos[$size];
            }

            $image = wc_placeholder_img_src($size);

            $url = plugin_dir_url('altimus') . 'altimus/img/default.png';
            $image_html = '<img src="' . esc_attr($url) . '" alt="' . esc_attr__('Placeholder', 'woocommerce') . '" width="' . esc_attr($dimensions['width']) . '" class="woocommerce-placeholder wp-post-image img-responsive" height="' . esc_attr($dimensions['height']) . '" />';
        }
        echo $image_html;
    }
}


//Listar todas as caracteristicas do veículos
if (!function_exists('alt_lista_caracteristicas')) {
    function alt_lista_caracteristicas($produto_id)
    {

        $arrCaracteristicas = get_caracteristas_widget();


        $list = '<ul class="tmpl-slider-grid__info list-unstyled features_list">';

        if (empty($arrCaracteristicas)) {


            $km = get_post_meta($produto_id, 'alt_kilometragem', true);
            if (!empty($km)) {
                $list .= '<li><i class="fas fa-tachometer-alt" aria-hidden="true"></i>' . number_format($km, 0, '', '.') . ' km</li>';
            } else {
                $list .= '<li><i class="fas fa-tachometer-alt" aria-hidden="true"></i>Consultar</li>';
            }

            $cambio = get_post_meta($produto_id, 'alt_cambio', true);
            if (!empty($cambio)) {

                $cambio = str_replace('Câmbio ', '', $cambio);

                $list .= '<li><i class="fas fa-project-diagram" aria-hidden="true"></i>' . $cambio . '</li>';
            } else {
                $list .= '<li><i class="fas fa-project-diagram" aria-hidden="true"></i>Consultar</li>';
            }


            $tipo = get_ano_veiculo();

            $ano = get_post_meta($produto_id, 'alt_ano_mod', true);

            if ($tipo == 'ano_modelo_fabricacao') {
                $ano = get_post_meta($produto_id, 'alt_ano_mod', true) . '/' . get_post_meta($produto_id, 'alt_ano_fab', true);
            }
            if ($tipo == 'ano_fabricacao') {
                $ano = get_post_meta($produto_id, 'alt_ano_fab', true);
            }

            if (!empty($ano)) {
                $list .= '<li><i class="far fa-calendar-alt" aria-hidden="true"></i> Ano ' . $ano . '</li>';
            } else {
                $list .= '<li><i class="far fa-calendar-alt" aria-hidden="true"></i>Consultar</li>';
            }


            $combustivel = get_post_meta($produto_id, 'alt_combustivel', true);
            if (!empty($combustivel)) {

                $list .= '<li><i class="fas fa-gas-pump" aria-hidden="true"></i>' . $combustivel . '</li>';
            } else {
                $list .= '<li><i class="fas fa-gas-pump" aria-hidden="true"></i>Consultar</li>';
            }


        } else {


            foreach ($arrCaracteristicas as $caracteristica) {


                $icone = get_icon_caracteristica($caracteristica);
                $titulo = get_title_caracteristica($caracteristica);

                $valor = get_post_meta($produto_id, $caracteristica, true);

                if ($caracteristica == 'alt_modelo') {
                    $valor = alt_get_marca_modelo_tipo($produto_id, 'modelo');
                }

                if ($caracteristica == 'alt_marca') {
                    $valor = alt_get_marca_modelo_tipo($produto_id, 'marca');
                }

                if ($caracteristica == 'alt_portas') {
                    $valor .= " Portas";
                }

                if ($caracteristica == 'alt_kilometragem') {
                    $valor = number_format($valor, '0', '', '.');
                }

                if (!empty($valor)) {
                    $list .= '<li><i title="' . $titulo . '"  class="' . $icone . '" aria-hidden="true"></i>' . $valor . '</li>';
                } else {
                    $list .= '<li><i title="' . $titulo . '" class="' . $icone . '" aria-hidden="true"></i>Consultar</li>';
                }


            }

        };


        $list .= '</ul>';
        return $list;
    }

    add_action('alt_lista_caracteristicas', 'alt_lista_caracteristicas', 10);
}

if (!function_exists('get_icon_caracteristica')) {
    function get_icon_caracteristica($alt_name)
    {
        switch ($alt_name) {
            case 'alt_kilometragem':
                $icon = 'fas fa-tachometer-alt';
                break;
            case 'alt_cambio':
                $icon = 'fas fa-project-diagram';
                break;
            case 'alt_ano_fab':
            case 'alt_ano_mod':
                $icon = 'far fa-calendar-alt';
                break;
            case 'alt_combustivel':
                $icon = 'fas fa-gas-pump';
                break;
            case 'alt_marca':
            case 'alt_modelo':
                $icon = 'fab fa-bandcamp';
                break;
            case 'alt_cambio':
                $icon = 'fa fa-power-off';
                break;
            case 'alt_placa':
                $icon = 'fas fa-list';
                break;
            case 'alt_cor':
                $icon = 'fas fa-brush';
                break;
            case 'alt_portas':
                $icon = 'icon-portas';
                break;
            default:
                $icon = 'fas fa-car';
        }

        return $icon;
    }
}


if (!function_exists('get_title_caracteristica')) {
    function get_title_caracteristica($alt_name)
    {
        switch ($alt_name) {
            case 'alt_kilometragem':
                $title = 'Quilometragem';
                break;
            case 'alt_cambio':
                $title = 'Câmbio';
                break;
            case 'alt_ano_fab':
                $title = 'Ano de Fabricação';
                break;
            case 'alt_ano_mod':
                $title = 'Ano modelo';
                break;
            case 'alt_combustivel':
                $title = 'Combustível';
                break;
            case 'alt_marca':
                $title = 'Marca';
                break;
            case 'alt_modelo':
                $title = 'Modelo';
                break;
            case 'alt_cambio':
                $title = 'Cambio';
                break;
            case 'alt_placa':
                $title = 'Placa';
                break;
            case 'alt_cor':
                $title = 'Cor';
                break;
            case 'alt_portas':
                $title = 'Portas';
                break;
            default:
                $title = 'Versão';
        }

        return $title;
    }
}


if (!function_exists('alt_get_marca_modelo_tipo')) {
    function alt_get_marca_modelo_tipo($produto_id, $cod_produto)
    {

        $arrTerm = get_the_terms($produto_id, $cod_produto, true);

        if (empty($arrTerm)) {
            return 'Não definido';
        }

        return $arrTerm['0']->name;
    }
}


if (!function_exists('alt_get_url_marca_modelo_tipo')) {
    function alt_get_url_marca_modelo_tipo($produto_id, $cod_produto)
    {
        $arrTerm = get_the_terms($produto_id, $cod_produto, true);

        if (empty($arrTerm)) {
            return 'Não definido';
        }


        $link = get_term_link($arrTerm[0]);


        return "<a href=" . $link . " class='label label-default'>" . $arrTerm['0']->name . "</a>";
    }
}


//Retornar se é um destaque
if (!function_exists('get_if_destaque')) {
    function get_if_destaque($produto_id)
    {

        $str_destaque = get_post_meta($produto_id, 'alt_destaque', true);
        $str_repasse = get_post_meta($produto_id, 'alt_repasse', true);


        if (!empty($str_destaque) && get_tarjeta_destaque()) {
            echo '<div class="ribbon_3"> <span class="tax-list">DESTAQUE</span></div>';
            return;
        }


    }

    add_action('get_if_destaque', 'get_if_destaque', 1);
}


//Retorna se é destaque
if (!function_exists('alt_get_if_repasse')) {
    function alt_get_if_repasse($produto_id)
    {


        $str_repasse = get_post_meta($produto_id, 'alt_repasse', true);

        if (!empty($str_repasse) && get_tarjeta_repasse()) {
            echo '<span title="Veículo de repasse">
                    <i class="fa fa-info-circle"></i>
                    Repasse
                </span>';
            return;
        }


    }

    add_action('get_if_destaque', 'get_if_destaque', 1);
}


if (!function_exists('alt_get_video')) {
    function alt_get_video($produto_id, $modelo = 1, $width = null, $height = null)
    {

        $str_data = get_post_meta($produto_id, 'alt_youtube', true);

        if (empty($width) || empty($height)) {

            $sizes = wp_get_registered_image_subsizes('alt_imagem_veiculo');


            extract($sizes['alt_imagem_veiculos_estoque']);


            $height = $width * 3 / 4 - 200;

            if ($modelo == 3) {
                $height = '300';
                $width = '100%';
            }
        }

        if (empty(trim($str_data)) || $str_data == null) {
            return false;
        }

        if (strpos($str_data, 'embed') !== false) {

            /**
             * Tratar embad
             */
            $local = explode('embed', $str_data);
            $codigo = str_replace('/', '', $local['1']);
            $url = 'http://www.youtube.com/watch?v=' . $codigo;
            return iframe_youtube($url, $width, $height);

        } else {

            if (empty($str_data)) {
                return false;
            }
            return iframe_youtube($str_data, $width, $height);
        }


    }


    function iframe_youtube($url, $width = 560, $height = 315, $fullscreen = true)
    {
        parse_str(parse_url($url, PHP_URL_QUERY), $my_array_of_vars);


        $sizes = 'width="' . $width . '" height="' . $height . '" ';
        if (wp_is_mobile()) {
            $sizes = $sizes = 'width="100%" height="190"';
        }


        $youtube = '<iframe allowtransparency="true" scrolling="no" ' . $sizes . ' src="//www.youtube.com/embed/' . $my_array_of_vars['v'] . '" frameborder="0"' . ($fullscreen ? ' allowfullscreen' : NULL) . '></iframe>';
        return $youtube;
    }
}

if (!function_exists('alt_get_video_thumb')) {
    function alt_get_video_thumb($produto_id)
    {


        $str_data = get_post_meta($produto_id, 'alt_thumb_youtube', true);


        if (empty($str_data)) {

            $url_youtube = get_post_meta($produto_id, 'alt_youtube', true);


            if (strpos($url_youtube, 'embed') !== false) {

                $arrURL = explode('/', $url_youtube);
                $cod = $arrURL[count($arrURL) - 1];
            } else {
                parse_str(parse_url($url_youtube, PHP_URL_QUERY), $my_array_of_vars);
                $cod = $my_array_of_vars['v'] ?? null;

            }


            return "https://img.youtube.com/vi/" . $cod . "/default.jpg";


        }

        return $str_data;
    }
}


if (!function_exists('alt_buscar_ano')) {
    function alt_buscar_ano()
    {


        $cod_produto = 'alt_ano_mod';
        $cod_produto = 'alt_ano_fab';

        $str_data = get_post_meta($produto_id, $cod_produto, true);

    }
}

//Exibir informações de um veículo
if (!function_exists('alt_get_caracteristicas')) {
    function alt_get_caracteristicas($produto_id, $cod_produto)
    {

        if (empty($cod_produto)) {
            return;
        }

        $str_data = get_post_meta($produto_id, $cod_produto, true);


        if ($cod_produto == 'alt_placa') {
            $str_data = alt_formatarPlaca($str_data);
        }


        if ($cod_produto == 'alt_ano_mod' || $cod_produto == 'alt_ano_fab') {

            $tipo = get_ano_veiculo();

            if ($tipo == 'ano_modelo') {
                $str_data = get_post_meta($produto_id, 'alt_ano_mod', true);
            }

            if ($tipo == 'ano_fabricacao') {
                $str_data = get_post_meta($produto_id, 'alt_ano_fab', true);
            }

            if ($tipo == 'ano_modelo_fabricacao') {

                $str_data = get_post_meta($produto_id, 'alt_ano_fab', true) . '/' . get_post_meta($produto_id, 'alt_ano_mod', true);

            }


        }


        if ($cod_produto = 'alt_acessorios') {

            if (empty($str_data)) {
                return;
            }


            $volume = [];

            if (gettype($str_data) == 'string') {
                return $str_data;
            }
            foreach ($str_data as $key => $row) {


                if (ocultarAcessorios($row['descricao'])) {
                    unset($str_data[$key]);
                    continue;
                }

                $volume[$key] = $row['descricao'];

            }


            if (!empty($volume) && !empty($str_data)) {
                array_multisort($volume, SORT_ASC, $str_data);
            }


        }

        if (empty($str_data)) {
            return '---';
        }

        return $str_data;
    }


}


function ocultarAcessorios($tipo)
{

    $tipo = sanitize_title(strtolower($tipo));
    $acessoriosOcultar = [
        sanitize_title('automatizado'),
        sanitize_title('automático'),
        sanitize_title('câmbio automático'),
        sanitize_title('câmbio automatizado'),
        sanitize_title('câmbio manual'),
        sanitize_title('cvt')
    ];

    return in_array($tipo, $acessoriosOcultar);

}

//Formatar place do veículo
if (!function_exists('alt_formatarPlaca')) {
    function alt_formatarPlaca($prPlaca)
    {

        $prMascara = get_formatar_placa();


        if ($prPlaca == NULL || $prPlaca == 'Array') {

            return '';

        }

        if (empty($prMascara)) {
            return $prPlaca;
        }

        $ultimo = substr($prPlaca, -1);
        $primeiro = substr($prPlaca, 0, 1);

        return $primeiro . '*****' . $ultimo;

    }
}

if (!function_exists('alt_get_imagem_veiculo')) {
    function alt_get_imagem_veiculo($size)
    {

        global $product;
        //$html_image = $product ? get_imagem_product($product, $size, ['class' => 'img-responsive', 'alt' => $product->name]) : '';
        $html_image = buscar_imagem_produto($product, $size);
        echo $html_image;


    }

    add_action('alt_get_imagem_veiculo', 'alt_get_imagem_veiculo', 1);
}





if (!function_exists('buscar_imagem_produto')) {
    function buscar_imagem_produto($product, $size)
    {

        if (empty($product->get_image_id())) {
            return wc_placeholder_img($size, array("class" => "img-responsive", "alt" => 'Sem imagem definida'));
        }
        return wp_get_attachment_image($product->get_image_id(), $size, "", array("class" => "img-responsive"));
    }
}

if (!function_exists('get_imagem_product')) {
    function get_imagem_product($product, $size = 'alt_imagem_veiculo_destaque', $attr = array(), $placeholder = true)
    {
        $image = '';
        if ($product->get_image_id()) {
            $image = wp_get_attachment_image($product->get_image_id(), $size, false, $attr);
        } elseif ($product->get_parent_id()) {
            $parent_product = wc_get_product($product->get_parent_id());
            if ($parent_product) {
                $image = $parent_product->get_image($size, $attr, $placeholder);
            }
        }

        if (!$image && $placeholder) {


            $image = buscar_imagem_placeholder($size, $attr);


        }


        //return apply_filters('woocommerce_product_get_image', $image, $product, $size, $attr, $placeholder, $image);
    }
}


if (!function_exists('woocommerce_veiculos_similares')) {

    /**
     * Output the related products.
     */
    function woocommerce_veiculos_similares($product = null)
    {

        echo "<h3>Confira outros veículos</h3>";

        $modelo = wc_get_product_terms($product->get_id(), 'modelo', array('fields' => 'slugs'));

        $tax_query = array(
            'relation' => 'AND',
            array(
                'taxonomy' => 'modelo',
                'field' => 'slug',
                'terms' => $modelo
            ),
            array(
                'taxonomy' => 'modelo',
                'terms' => 'any'
            )
        );
        $args = array(
            'post__not_in' => array($product->get_id()),
            'post_type' => array('product'),
            'posts_per_page' => 4,
            'columns' => 4,
            'tax_query' => $tax_query,
            'orderby' => 'title',
        );

        $modelos_similares = new WP_Query($args);

        $total_encontrado = 0;
        $veiculos_exibidos = [];
        if ($modelos_similares->have_posts()) {
            while ($modelos_similares->have_posts()) {
                $modelos_similares->the_post();
                $veiculos_exibidos[] = get_the_ID();
                wc_get_template_part('content', 'similares');
                $total_encontrado++;
            }
            wp_reset_postdata();
        }
        wp_reset_query();


        //Prioritaramente trazer veiculos do mesmo modelo dpeois disso, a diferença em veiculos de preço similar
        $total_atrazer = 4 - $total_encontrado;

        if ($total_encontrado == 4) {
            return;
        }


        $price = $product->get_price();
        $percentesValue = $price / 100 * 30;
        $min = $price - $percentesValue;
        $max = $price + $percentesValue;

        $valorProximo = array(
            'relation' => 'OR',
            array(
                'key' => '_price',
                'value' => array($min, $max),
                'compare' => 'BETWEEN',
                'type' => 'NUMERIC'
            ),

        );


        $veiculos_exibidos[] = $product->get_id();

        $args = array(
            'post__not_in' => $veiculos_exibidos,
            'post_type' => array('product'),
            'posts_per_page' => $total_atrazer,
            'columns' => $total_atrazer,
            'meta_query' => $valorProximo,
            //'tax_query' => $tax_query,
            'orderby' => 'title',
        );


        $query_preco_similar = new WP_Query($args);
        if ($query_preco_similar->have_posts()) {
            while ($query_preco_similar->have_posts()) {
                $query_preco_similar->the_post();
                wc_get_template_part('content', 'similares');
                $total_encontrado++;
            }
            wp_reset_postdata();
        }
        wp_reset_query();


        $shop_page_url = get_permalink(wc_get_page_id('shop'));

        if ($total_encontrado < 4) {

            echo "<div class='col-md-12 text-center'><a href='$shop_page_url' class='btn'>Estoque completo</a></div>";
        }


    }
}


if (!function_exists('alt_get_theme')) {

    function alt_get_theme()
    {
        $theme_selected = 1;
        $theme = wp_get_theme();
        if ($theme->get('TextDomain') == 'altimus-2') {
            $theme_selected = 2;
        };


        return $theme_selected;
    }


}


if (!function_exists('alt_get_tags')) {
    function alt_get_tags($produto_id)
    {
        $str_tags = get_post_meta($produto_id, 'alt_tags', true);

        if (!empty($str_tags)) {
            $tags = explode(',', $str_tags);

            $str = '<div class="listagem_tags">';
            foreach ($tags as $tag) {
                $str .= '<div class="label_icon pull-right" style="position: relative;margin-left: 5px;">' . $tag . '</div>';
            }
            $str .= '</div>';

            return $str;
        }


    }
}

if (!function_exists('pr')) {
    function pr($data)
    {
        echo "<pre>";
        print_r($data);
        echo "</pre>";

    }
}

if (!function_exists('alt_mascara')) {
    function alt_mascara($mask, $str)
    {
        $str = str_replace(" ", "", $str);
        for ($i = 0; $i < strlen($str); $i++) {
            $mask[strpos($mask, "#")] = $str[$i];
        }

        $mask = str_replace('#', '', $mask);
        return $mask;
    }
}
