<?php

//modificar query de busca para permitir filtrar dados personalizados
if (!function_exists('modify_query')) {

    add_action('woocommerce_product_query', 'modify_query');
    function modify_query($query)
    {


        if (!is_admin() && $query->is_main_query() && $query->query_vars['post_type'] == 'product') {

            $meta_query = $query->get('meta_query');


            if (isset($_GET['destaque'])) {

                $meta_query[] = array(
                    'key' => 'alt_destaque',
                    'value' => 'on',
                    'compare' => '='
                );


            }

            if (isset($_GET['carrozero'])) {

                $meta_query['relation'] = 'OR';
                $meta_query[] = array(
                    'key' => 'alt_zerokm',
                    'compare' => '=',
                    'value' => 'on'
                );

                $meta_query[] = array(
                    'key' => 'alt_zerokm',
                    'compare' => '=',
                    'value' => '1'
                );


            }


            if (isset($_GET['repasse'])) {
                $valor = $_GET['repasse'];


                if ($valor == 'off') {
                    $meta_query['relation'] = 'OR';
                    $meta_query[] = array(
                        'key' => 'alt_repasse',
                        'compare' => '=',
                        'value' => ''
                    );


                } else {
                    $meta_query['relation'] = 'OR';
                    $meta_query[] = array(
                        'key' => 'alt_repasse',
                        'compare' => '=',
                        'value' => 'on'
                    );

                    $meta_query[] = array(
                        'key' => 'alt_repasse',
                        'compare' => '=',
                        'value' => '1'
                    );

                }


            }

            if (isset($_GET['min_km'])) {
                $meta_query[] = array(
                    'key' => 'alt_kilometragem',
                    'value' => $_GET['min_km'],
                    'compare' => '>=',
                    'type' => 'NUMERIC'
                );
            }

            if (isset($_GET['max_km'])) {
                $meta_query[] = array(
                    'key' => 'alt_kilometragem',
                    'value' => $_GET['max_km'],
                    'compare' => '<=',
                    'type' => 'NUMERIC'
                );
            }

            if (isset($_GET['filial'])) {
                $meta_query[] = array(
                    'key' => 'alt_localizacao',
                    'value' => $_GET['filial'],
                    'compare' => '=',

                );
            }

            if (isset($_GET['ano'])) {
                $meta_query[] = array(
                    'key' => 'alt_ano_mod',
                    'value' => $_GET['ano'],
                    'compare' => '=',

                );
            }


            if (isset($_GET['min_ano'])) {
                $meta_query[] = array(
                    'key' => 'alt_ano_mod',
                    'value' => $_GET['min_ano'],
                    'compare' => '>=',
                    'type' => 'NUMERIC'
                );
            }

            if (isset($_GET['max_ano'])) {
                $meta_query[] = array(
                    'key' => 'alt_ano_mod',
                    'value' => $_GET['max_ano'],
                    'compare' => '<=',
                    'type' => 'NUMERIC'
                );
            }


            if (isset($_GET['cambio'])) {
                $meta_query[] = array(
                    'key' => 'alt_cambio',
                    'value' => $_GET['cambio'],
                    'compare' => '=',

                );
            }

            if (isset($_GET['combustivel'])) {
                $meta_query[] = array(
                    'key' => 'alt_combustivel',
                    'value' => $_GET['combustivel'],
                    'compare' => '=',

                );
            }


            if (isset($_GET['s'])) {
                //$query->query_vars['orderby'] = 'price-desc';
                $query->query_vars['orderby'] = 'last_modified';
                $query->query_vars['order'] = 'asc';

            }


            if (isset($_GET['min_ano'])) {
                $meta_query[] = array(
                    'key' => 'alt_ano_mod',
                    'value' => $_GET['min_ano'],
                    'compare' => '>=',
                    'type' => 'NUMERIC'
                );
            }

            if (isset($_GET['max_ano'])) {
                $meta_query[] = array(
                    'key' => 'alt_ano_mod',
                    'value' => $_GET['max_ano'],
                    'compare' => '<=',
                    'type' => 'NUMERIC'
                );
            }


            if (isset($_GET['acessorios'])) {

                $arrFiltroAcessorios = explode(':', $_GET['acessorios']);
                $meta_query['relation'] = 'OR';

                foreach ($arrFiltroAcessorios as $acessorio) {

                    $meta_query[] = array(
                        'key' => 'alt_acessorios',
                        'value' => serialize($acessorio),
                        'compare' => 'LIKE',
                    );
                }



            }


            $query->set('meta_query', $meta_query);


        }


    }
}

if (!function_exists('dump_request')) {
    //add_filter( 'posts_request', 'dump_request' );
    function dump_request($input)
    {

        echo "<pre>";
        print_r($input);
        echo "</pre>";
        return $input;
    }
}


function alt_load_more_filter($args, $id)
{

    $order = get_ordenacao_padrao();

    if ($order == 'alt_ano_mod') {

        $args['meta_key'] = 'alt_ano_mod';
        $args['orderby'] = 'meta_value';
        $args['order'] = 'asc';

    }

    if ($order == 'alt_ano_mod_desc') {
        $args['meta_key'] = 'alt_ano_mod';
        $args['orderby'] = 'meta_value';
        $args['order'] = 'desc';
    }


    if ($order == 'popularity') {

        $args['orderby'] = 'meta_value_num';
        $args['order'] = 'desc';
        $args['meta_key'] = 'total_sales';
    }


    return $args;
}

add_filter('alm_query_args_listar_veiculos', 'alt_load_more_filter', 10, 2);


function alt_listar_veiculos_after($query)
{


    return $query;
}

add_filter('alm_query_after_listar_veiculos', 'alt_listar_veiculos_after');
