<?php

/**
 * API request atualiza ou cria dados por meio da API
 */

if (!function_exists('custom_return_rest_api')) {
    //add_filter('rest_post_dispatch', 'custom_return_rest_api');
    function custom_return_rest_api($objResponse)
    {
        return $objResponse;
        if (empty($objResponse->data)) {
            return $objResponse;
        };


        //return $objResponse;
        if (isset($objResponse->data[0])) {
            foreach ($objResponse->data as $indice => $objResp) {

                $arrReturn[$indice]['id'] = $objResp['id'];
                $arrReturn[$indice]['name'] = $objResp['name'];
                $arrReturn[$indice]['slug'] = $objResp['slug'];
                $arrReturn[$indice]['status'] = $objResp['status'];
                $arrReturn[$indice]['price'] = $objResp['price'];
                $arrReturn[$indice]['regular_price'] = $objResp['regular_price'];
                $arrReturn[$indice]['images'] = $objResp['images'];
                $arrReturn[$indice]['modelo'] = $objResp['modelo'];
                $arrReturn[$indice]['tipo'] = $objResp['tipo'];
                $arrReturn[$indice]['marca'] = $objResp['marca'];
                $arrReturn[$indice]['outros'] = $objResp['cmb2']['dados_do_veiculo'];


            }
            $objResponse->data = $arrReturn;
            return $objResponse;
        };

        $arrReturn['id'] = $objResponse->data['id'];
        $arrReturn['name'] = $objResponse->data['name'];
        $arrReturn['slug'] = $objResponse->data['slug'];
        $arrReturn['status'] = $objResponse['status'];
        $arrReturn['price'] = $objResponse->data['price'];
        $arrReturn['regular_price'] = $objResponse->data['regular_price'];
        $arrReturn['images'] = $objResponse->data['images'];
        $arrReturn['modelo'] = $objResponse->data['modelo'];
        $arrReturn['tipo'] = $objResponse->data['tipo'];
        $arrReturn['marca'] = $objResponse->data['marca'];
        $arrReturn['outros'] = $objResponse->data['cmb2']['dados_do_veiculo'];

        $objResponse->data = $arrReturn;

        return $objResponse;
    }
}

if (!function_exists('wdm_delete_post_images')) {
    add_action("before_delete_post", "wdm_delete_post_images", 100);
    function wdm_delete_post_images($post_id)
    {


        $product = wc_get_product($post_id);
        if (empty($product)) {
            return;
        };
        $childrens = $product->get_gallery_image_ids() ?? [];
        wp_delete_attachment($product->get_image_id(), true);
        if ($childrens):
            foreach ($childrens as $attachment):
                $attachment_path = get_attached_file($attachment);
                //wp_delete_attachment_files($attachment);
                wp_delete_attachment($attachment, true);
                wp_delete_post($attachment, true);

                //Excluir o arquivo fisico
                $attachment_path = get_attached_file($attachment);
                $delete_file = unlink($attachment_path);
                wp_delete_file($attachment_path);

            endforeach;
        endif;
    }
}


/**
 * Metodo responsável por alterar o payload que será salvo no banco de dados, antes de gravar as informações
 * o hook woocommerce_before_product_object_save é quem salva as informações no banco de dados, antes dele ser executado
 * o Altimus faz um tratamento
 */
if (!function_exists('atualizar_informacaoes_salvas')) {
    add_filter('woocommerce_before_product_object_save', 'atualizar_informacaoes_salvas', 99, 1);
    function atualizar_informacaoes_salvas($product)
    {

        $form = json_decode(file_get_contents("php://input"));

        /**LIMPAR TOTAL CACHE*/
        if (function_exists('w3tc_flush_all')) {
            w3tc_flush_all();
        }

        if (!empty($form)) {

            //Validar se campos obrigatórios foram preenchidos
            if (!isset($form->tipo) || empty($form->tipo)) {
                throw new WC_Data_Exception(500, 'O campo Tipo é obrigatório', 500, []);
            }
            if (!isset($form->marca) || empty($form->marca)) {
                throw new WC_Data_Exception(500, 'O campo Marca é obrigatório', 500, []);
            }
            if (!isset($form->modelo) || empty($form->modelo)) {
                throw new WC_Data_Exception(500, 'O campo Modelo é obrigatório', 500, []);
            }


            $carroceria = $form->carroceria ?? null;
            if (empty($carroceria) || strtolower($carroceria) == 'null' || $carroceria == null) {
                $carroceria = "Não definida";
            }


            //carroceria do veículo
            $terms_carroceria = term_exists($carroceria, 'carroceria', 0);

            if (empty($terms_carroceria)) {
                $terms_carroceria = wp_insert_term($carroceria, 'carroceria', array('parent' => 0));
            }

            $parent_carroceria_id = $terms_carroceria['term_id'];


            //Tipo do veículo
            $tipo = $form->tipo ?? 'Não definida';
            $termsTipo = term_exists($tipo, 'product_cat', 0);


            if (empty($termsTipo)) {
                $termsTipo = wp_insert_term($tipo, 'product_cat', array('parent' => 0));
            }
            //Cadastro do modelo do veiculo
            $parent_tipo_id = $termsTipo['term_id'];
            $marca = $form->marca ?? 'Não definida';
            $termsMarca = term_exists($marca, 'product_cat', $parent_tipo_id);

            if (empty($termsMarca)) {
                $termsMarca = wp_insert_term($marca, 'product_cat', array('parent' => $parent_tipo_id));
            }
            $parent_marca_id = $termsMarca['term_id'];


            $modelo = $form->modelo ?? 'Não definida';
            $termsModelo = term_exists($modelo, 'product_cat', $parent_marca_id);
            if (empty($termsModelo)) {
                $termsModelo = wp_insert_term($modelo, 'product_cat', array('parent' => $parent_marca_id));
            }
            $parent_modelo_id = $termsModelo['term_id'];


            $stringTag = $modelo;
            //Save tags
            $modeloTag = term_exists($stringTag, 'product_tag');
            if (empty($modeloTag)) {
                $modeloTag = wp_insert_term($stringTag, 'product_tag');
            }


            if (!empty($product)) {


                $product->set_category_ids(array($parent_tipo_id, $parent_marca_id, $parent_modelo_id, $parent_carroceria_id), true);
                $product->set_tag_ids(array($modeloTag['term_id']));
                $arrFormacao = get_formacao_titulo();

                if (!empty($arrFormacao)) {
                    $nome = "";
                    foreach ($arrFormacao as $indices) {

                        if ($indices == 'marca') {
                            $objMarca = get_term($termsMarca['term_id']);
                            $nome .= $objMarca->name . ' ';
                        }


                        if ($indices == 'modelo') {
                            $objModelo = get_term($termsModelo['term_id']);
                            $nome .= $objModelo->name . ' ';
                        }

                        if ($indices == 'modelo_complemento') {


                            $value = $form->meta_data[array_search('alt_modelo_complemento', array_column($form->meta_data, 'key'))]->value;
                            $modelo_complemento = $value ?? get_post_meta($product->get_id(), 'alt_modelo_complemento', true);

                            if (!empty($modelo_complemento)) {
                                $nome .= $modelo_complemento . ' ';
                            }
                        }
                        if ($indices == 'ano_fabricacao') {

                            $value = $form->meta_data[array_search('alt_ano_fab', array_column($form->meta_data, 'key'))]->value;
                            $ano_fabricacao = $value ?? get_post_meta($product->get_id(), 'alt_ano_fab', true);

                            if (!empty($ano_fabricacao)) {
                                $nome .= $ano_fabricacao . ' ';
                            }

                        }
                        if ($indices == 'ano_modelo') {

                            $value = $form->meta_data[array_search('alt_ano_mod', array_column($form->meta_data, 'key'))]->value;
                            $ano_modelo = $value ?? get_post_meta($product->get_id(), 'alt_ano_mod', true);

                            //Adicionar uma barra entre o ano fab e ano mod
                            if (isset($ano_fabricacao)) {
                                $nome = substr($nome, 0, -1);
                                $nome .= '/';
                            }

                            if (!empty($ano_modelo)) {
                                $nome .= $ano_modelo . ' ';
                            }
                        }
                        if ($indices == 'cor') {

                            $value = $form->meta_data[array_search('alt_cor', array_column($form->meta_data, 'key'))]->value;
                            $cor = $value ?? get_post_meta($product->get_id(), 'alt_cor', true);


                            if (!empty($cor)) {
                                $nome .= $cor . ' ';
                            }
                        }
                        if ($indices == 'porta') {

                            $value = $form->meta_data[array_search('alt_portas', array_column($form->meta_data, 'key'))]->value;
                            $portas = $value ?? get_post_meta($product->get_id(), 'alt_portas', true);

                            if (!empty($portas)) {
                                $nome .= $portas . 'P ';
                            }
                        }
                        if ($indices == 'cambio') {
                            $value = $form->meta_data[array_search('alt_cambio', array_column($form->meta_data, 'key'))]->value;
                            $cambio = $value ?? get_post_meta($product->get_id(), 'alt_cambio', true);

                            if (!empty($cambio)) {
                                $nome .= $cambio . ' ';
                            }
                        }

                    };

                    $product->set_name($nome);
                    $product->set_slug($nome);


                }
            }

        }
    }
}

//Deletar todas as imagens de produtos não utilizadas
if (!function_exists('deletar_imagens_nao_usadas_de_produtos')) {
    add_action('deletar_imagens_nao_usadas_de_produtos', 'deletar_imagens_nao_usadas_de_produtos');
    function deletar_imagens_nao_usadas_de_produtos()
    {

        $attachments = get_posts(array(
            'post_type' => 'attachment',
            'numberposts' => -1,
            'fields' => 'ids',
            'post_parent' => 0,
        ));
        if ($attachments) {
            foreach ($attachments as $attachment) {

                $parent_id = $attachment->post_parent;
                if ('product' == get_post_type($parent_id)) {

                    $attachmentID = $attachment->ID;
                    $attachment_path = get_attached_file($attachmentID);
                    //Delete attachment from database only, not file
                    $delete_attachment = wp_delete_attachment($attachmentID, true);
                    //Delete attachment file from disk
                    $delete_file = unlink($attachment_path);
                }
            }
        }
    }
}
/**
 * Metodo resposável por excluir todas as imagens do produto caso seja mandado um payload com o campo imagens em branco
 *o woocommerce não exclui automativamente todas as imagens, ele simplesmente perde a referencia e deixa como lixo as imagens
 * desanexadas.
 */
if (!function_exists('analisar_post_api')) {
    add_action('woocommerce_rest_pre_insert_product_object', 'analisar_post_api', 10, 3);
    function analisar_post_api($param1 = null, $param2 = null, $param3 = null)
    {

        if (!empty($param1->get_id())) {

            if (!isset($param2['images']) || empty($param2['images'])) {

                $product = wc_get_product($param1->get_id());
                if (empty($product)) {
                    return;
                };
                $childrens = $product->get_gallery_image_ids() ?? [];
                //excluir imagem principal
                wp_delete_attachment($product->get_image_id(), true);
                //Excluir outras imagens
                if ($childrens):
                    foreach ($childrens as $attachment):
                        $attachment_path = get_attached_file($attachment);

                        wp_delete_attachment($attachment, true);
                        wp_delete_post($attachment, true);

                        //Excluir o arquivo fisico
                        //$delete_file = unlink($attachment_path);
                        wp_delete_file($attachment_path);

                    endforeach;
                endif;

            };


        };

        return $param1;
    }

}
