<?php

add_action('cmb2_admin_init', 'cores');

function cores()
{
    //GERENCIAR CORES


    $cmb_cores = new_cmb2_box(array(
        'id' => 'alt_setup_cores',
        'title' => 'Configuração de cores',
        'object_types' => array('options-page'),
        'option_key' => 'alt_group_cores', // The option key and admin menu page slug.
        'parent_slug' => 'alt_group_setup', // Make options page a submenu item of the themes menu.
    ));


    $theme = wp_get_theme();
    $desc_theme = $theme->get('TextDomain') ?? 'altimus';




    $cores_por_tema = [
        'altimus' => [
            'red' => 'Vermelha',
            'blue' => 'Azul',
            'dark' => 'Dark',
            'green' => 'Green',
            'orange' => 'Laranja',
            'pink' => 'Rosa',
            'purple' => 'Roxo',
            'altimus' => 'Personalizada',
        ],
        'altimus-2' => [
            'color1' => 'Vermelha',
            'color2' => 'Azul',
            'color3' => 'Amarelo',
            'color4' => 'Laranja',
            'color5' => 'Verde',
            'altimus' => 'Personalizada',
        ]
    ];


    $cmb_cores->add_field(array(
        'after_row' => '<hr/>',
        'name' => 'Escolha a paleta de cores',
        'desc' => 'Selecione uma das paletas de cores',
        'id' => 'paleta_cores',
        'type' => 'select',
        'default' => 'altimus',
        'options' => $cores_por_tema[$desc_theme],
    ));

    $cmb_cores->add_field(array(
        'before_row' => '<h1>Cores personalizadas</h1><hr/>',
        'name' => 'Cor primária',
        'desc' => 'Selecione a cor primária do site - default #000000',
        'id' => 'cor_primaria',
        'type' => 'colorpicker',
        'default' => '#000000',
    ));
    $cmb_cores->add_field(array(
        'name' => 'Cor secundária',
        'desc' => 'Selecione a cor secundaria do site - default #ffffff',
        'id' => 'cor_secundaria',
        'type' => 'colorpicker',
        'default' => '#000000',
    ));

    //Exibir apenas para tema 1 até a liberação do tema SEO
    if ($desc_theme=='altimus') {
        include 'cores_tema_1.php';
    }

}

function get_paleta_de_cores()
{
    $dados = get_option('alt_group_cores');
    return $dados['paleta_cores'] ?? 'altimus';
}

function get_cor($tipo)
{
    $dados = get_option('alt_group_cores');
    return $dados[$tipo];
}

