<?php

if (file_exists(dirname(__FILE__) . '/cmb2/init.php')) {
    require_once dirname(__FILE__) . '/cmb2/init.php';
} elseif (file_exists(dirname(__FILE__) . '/CMB2/init.php')) {
    require_once dirname(__FILE__) . '/CMB2/init.php';
}

add_action('cmb2_init', 'alt_metabox_time');


/**
 * Define the metabox and field configurations.
 */
function alt_metabox_time()
{


    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_time',
        'title' => 'Vendedores/Time',
        'object_types' => array('time'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
            'name' => 'Cargo',
            'desc' => '',
            'id' => $prefix . 'cargo',
            'type' => 'text'


        )
    );

    $cmb->add_field(array(
            'name' => 'Telefone',
            'desc' => 'Informe o telefone do vendedor ou membro do time ex: 47997466287',
            'id' => $prefix . 'telefone',
            'type' => 'text'

        )
    );

    $cmb->add_field(array(
            'name' => 'Experiência',
            'desc' => '0 a 99',
            'id' => $prefix . 'experiencia',
            'type' => 'text',
            'attributes' => array(
                'type' => 'number',
                'pattern' => '\d*',
            ),

        )
    );

    $cmb->add_field(array(
            'name' => 'Whatsapp',
            'desc' => 'Informe o whatsapp do vendedor ou membro do time ex: 5547997466287',
            'id' => $prefix . 'whatsapp',
            'type' => 'text'

        )
    );

    $cmb->add_field(array(
            'name' => 'E-mail',
            'desc' => 'Informe o email do vendedor ou membro do time',
            'id' => $prefix . 'email',
            'type' => 'text_email',
            'protocols' => array('http', 'https'),

        )
    );

    $cmb->add_field(array(
        'name' => 'Selecione a imagem',
        'desc' => 'Selecione o arquivo ou informe a URL.',
        'id' => $prefix . 'time_imagem',
        'type' => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Adicionar arquivo' // Change upload button text. Default: "Add or Upload File"
        ),
        // query_args are passed to wp.media's library query.
        'query_args' => array(
            //'type' => 'application/pdf', // Make library only display PDFs.
            // Or only allow gif, jpg, or png images
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),
        'preview_size' => 'alt-img-time', // Image size to use when previewing in the admin.
    ));


}

