<?php

if (file_exists(dirname(__FILE__) . '/cmb2/init.php')) {
    require_once dirname(__FILE__) . '/cmb2/init.php';
} elseif (file_exists(dirname(__FILE__) . '/CMB2/init.php')) {
    require_once dirname(__FILE__) . '/CMB2/init.php';
}

add_action('cmb2_init', 'alt_metabox_galeria');


/**
 * Define the metabox and field configurations.
 */
function alt_metabox_galeria()
{


    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_galeria',
        'title' => 'Galeria de imagens',
        'object_types' => array('galeria'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
            'name' => 'Link',
            'desc' => 'Informe o link que deverá ser aberto',
            'id' => $prefix . 'galeria_link',
            'type' => 'text_url',
            'protocols' => array('http', 'https'),

        )
    );

    $cmb->add_field(array(
        'name' => 'Selecione a imagem',
        'desc' => 'Selecione o arquivo ou informe a URL.',
        'id' => $prefix . 'galeria_imagem',
        'type' => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Adicionar arquivo' // Change upload button text. Default: "Add or Upload File"
        ),
        // query_args are passed to wp.media's library query.
        'query_args' => array(
            //'type' => 'application/pdf', // Make library only display PDFs.
            // Or only allow gif, jpg, or png images
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),
        'preview_size' => 'alt-banners', // Image size to use when previewing in the admin.
    ));


}

